/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.AbstractStatedIcon;
import IconRenderers.BasicCheckIcon;
import JMConstants.Constants;
import Renderers.GlossyRenderer;
import Renderers.Renderer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.text.View;

public class RenderedCheckBoxUI
extends BasicCheckBoxUI
implements Constants {
    static Renderer defaultRenderer = new GlossyRenderer();
    private static AbstractStatedIcon defaultIcon = new BasicCheckIcon();
    private Renderer renderer;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RenderedCheckBoxUI.this.component.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RenderedCheckBoxUI.this.component.getModel().setRollover(false);
        }
    };
    JCheckBox component;
    private boolean foundOpaque = false;
    private boolean opaque = false;
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedCheckBoxUI();
    }

    public static void setDefaultIconRenderer(AbstractStatedIcon icon) {
        if (icon != null) {
            defaultIcon = icon;
        }
    }

    public static AbstractStatedIcon getDefaultIconRenderer() {
        return defaultIcon;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    protected Icon getActiveIcon() {
        return this.icon == null ? RenderedCheckBoxUI.getDefaultIconRenderer() : this.icon;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener);
        super.uninstallUI(c);
        if (c == this.component) {
            this.component = null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.icon = null;
        this.component = (JCheckBox)c;
        this.component.addMouseListener(this.mouseListener);
        Object opaque = UIManager.get(this.getPropertyPrefix() + "opaque");
        if (opaque instanceof Boolean) {
            this.foundOpaque = true;
            this.opaque = (Boolean)opaque;
            this.component.setOpaque(this.opaque);
            this.component.setContentAreaFilled(this.opaque);
        }
        this.icon = UIManager.getIcon("CheckBox.icon");
        this.component.setRolloverEnabled(true);
    }

    @Override
    public Icon getDefaultIcon() {
        return this.getActiveIcon();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.foundOpaque && b.isOpaque() != this.opaque) {
            b.setOpaque(this.opaque);
        }
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        size = b.getSize(size);
        RenderedCheckBoxUI.viewRect.x = i.left;
        RenderedCheckBoxUI.viewRect.y = i.top;
        RenderedCheckBoxUI.viewRect.width = RenderedCheckBoxUI.size.width - (i.right + RenderedCheckBoxUI.viewRect.x);
        RenderedCheckBoxUI.viewRect.height = RenderedCheckBoxUI.size.height - (i.bottom + RenderedCheckBoxUI.viewRect.y);
        RenderedCheckBoxUI.iconRect.height = 0;
        RenderedCheckBoxUI.iconRect.width = 0;
        RenderedCheckBoxUI.iconRect.y = 0;
        RenderedCheckBoxUI.iconRect.x = 0;
        RenderedCheckBoxUI.textRect.height = 0;
        RenderedCheckBoxUI.textRect.width = 0;
        RenderedCheckBoxUI.textRect.y = 0;
        RenderedCheckBoxUI.textRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.getActiveRenderer().getColors().setActiveColors(c);
        if (b.isContentAreaFilled() || b.isOpaque()) {
            this.getActiveRenderer().paintBackground((Graphics2D)g, c);
        }
        if (this.icon != null) {
            this.icon.paintIcon(c, g, RenderedCheckBoxUI.iconRect.x, RenderedCheckBoxUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(c.isEnabled() ? this.getActiveRenderer().getColors().getColor(0, 0) : this.getActiveRenderer().getColors().getColor(0, 2));
                g.drawString(text, RenderedCheckBoxUI.textRect.x, RenderedCheckBoxUI.textRect.y + fm.getAscent());
            }
        }
    }
}

