/*
 * Decompiled with CFR 0.152.
 */
package ToolTip;

import ToolTip.AbstractToolTip;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public abstract class TextToolTip
extends AbstractToolTip {
    private final JLabel label = new JLabel();

    public TextToolTip(Component owner) {
        super(owner);
        this.initLabel(null);
    }

    public TextToolTip(Component owner, String text) {
        super(owner);
        this.initLabel(text);
    }

    public TextToolTip(Component owner, String text, int x, int y) {
        super(owner);
        this.initLabel(text);
        this.setLocation(x, y);
    }

    void initLabel(String text) {
        this.w.setComponent(this.label);
        this.label.setOpaque(false);
        this.label.setBorder(new EmptyBorder(this.pad, this.pad, this.pad, this.pad));
        this.setBackground(TOOLTIP_YELLOW);
        if (text != null) {
            this.setText(text);
        }
        this.w.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TextToolTip.this.setLocation();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setText(String s) {
        boolean bl = this.haveText = s != null && s.length() > 0;
        if (this.visible && !this.haveText) {
            this.hide();
        }
        this.label.setText(s);
        if (this.visible) {
            this.w.pack();
            this.w.repaint();
        }
    }

    @Override
    public void show() {
        if (!this.visible && this.haveText) {
            super.show();
        }
    }
}

