/*
 * Decompiled with CFR 0.152.
 */
package TextTools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DrawCircularText {
    private static final double DegreesPerRadian = 0.0174533;
    private static final double RadianPerDegrees = 57.2958;

    public static ReturnShape drawTextAroundCircle(Graphics2D g, String text, int centerAngleInDegrees, boolean squash, CircularTextPosition circularTextPosition, boolean flip2, double radius, double centerX, double centerY, Font font, GlyphDrawer glyphDrawer) {
        return DrawCircularText.drawTextAroundCircle(g, text, centerAngleInDegrees, squash, circularTextPosition, flip2, radius, centerX, centerY, font, glyphDrawer, null);
    }

    public static ReturnShape drawTextAroundCircle(Graphics2D g, String text, int centerAngleInDegrees, boolean squash, CircularTextPosition circularTextPosition, boolean flip2, double radius, double centerX, double centerY, Font font, GlyphDrawer glyphDrawer, Color highlightColor) {
        double maxDescent;
        double maxAscent;
        boolean flip = centerAngleInDegrees >= 90 && centerAngleInDegrees <= 270;
        ReturnShape shape = new ReturnShape();
        AffineTransform oldTransform = g.getTransform();
        glyphDrawer.saveGraphicsStateBeforeDraw(g);
        FontMetrics fm = g.getFontMetrics(font);
        FontRenderContext frc = g.getFontRenderContext();
        char[] characters = text.toCharArray();
        int characterCount = characters.length;
        if (flip) {
            char[] reversedCharacters = new char[characterCount];
            for (int index = 0; index < characterCount; ++index) {
                reversedCharacters[index] = characters[characterCount - index - 1];
            }
            characters = reversedCharacters;
        }
        if (squash) {
            maxAscent = 0.0;
            maxDescent = 0.0;
        } else {
            maxAscent = fm.getMaxAscent();
            maxDescent = fm.getMaxDescent();
        }
        double spaceCharacterWidth = fm.charWidth('.');
        double leading = fm.getLeading();
        boolean[] charactersAreSpaces = new boolean[characterCount];
        GlyphVector[] characterGlyphVectors = new GlyphVector[characterCount];
        Rectangle2D[] characterGlyphBounds = new Rectangle2D[characterCount];
        double[] characterWidths = new double[characterCount + 1];
        double[] characterAscents = new double[characterCount];
        double[] characterDescents = new double[characterCount];
        for (int index = 0; index < characterCount; ++index) {
            char character = characters[index];
            boolean isSpace = character == ' ' || Character.isSpaceChar(character);
            GlyphVector glyphVector = font.createGlyphVector(frc, Character.toString(character));
            Rectangle2D glyphBounds = glyphVector.getVisualBounds();
            double width = isSpace ? spaceCharacterWidth : glyphBounds.getWidth();
            double ascent = -glyphBounds.getY();
            double descent = glyphBounds.getHeight() - ascent;
            charactersAreSpaces[index] = isSpace;
            characterGlyphVectors[index] = glyphVector;
            characterGlyphBounds[index] = glyphBounds;
            characterWidths[index] = width;
            characterAscents[index] = ascent;
            characterDescents[index] = descent;
            if (!squash) continue;
            maxAscent = Math.max(maxAscent, ascent) * 1.25;
            maxDescent = Math.max(maxDescent, descent);
        }
        double actualRadius = circularTextPosition.calculateActualRadius(radius, maxAscent, maxDescent, flip);
        double currentAngleInRadians = 0.0;
        double charWidthInRadians = 0.0;
        double firstcharWidthInRadians = 0.0;
        double[] characterAnglesInRadians = new double[characterCount];
        characterAnglesInRadians[0] = currentAngleInRadians;
        firstcharWidthInRadians = Math.sin((characterWidths[0] / 2.0 + leading + characterWidths[1] / 2.0) / actualRadius);
        currentAngleInRadians += firstcharWidthInRadians;
        for (int index = 1; index < characterCount; ++index) {
            characterAnglesInRadians[index] = currentAngleInRadians;
            charWidthInRadians = Math.sin((characterWidths[index] / 2.0 + leading + characterWidths[index + 1] / 2.0) / actualRadius);
            currentAngleInRadians += charWidthInRadians;
        }
        shape.degreeAngleSweep = (firstcharWidthInRadians + charWidthInRadians + characterAnglesInRadians[characterCount - 1] - characterAnglesInRadians[0]) * 57.2958;
        shape.degreeAngleStart = (double)centerAngleInDegrees - shape.degreeAngleSweep / 2.0;
        shape.degreeAngleStop = (double)centerAngleInDegrees + shape.degreeAngleSweep;
        shape.innerRadius = actualRadius;
        shape.outerRadius = actualRadius + maxAscent;
        shape.centerX = (int)centerX;
        shape.centerY = (int)centerY;
        if (highlightColor != null) {
            g.setColor(highlightColor);
            g.fill(shape.getToHitShape());
            ((OutlinedFilledGlyphDrawer)glyphDrawer).drawOutline = 0;
        } else {
            ((OutlinedFilledGlyphDrawer)glyphDrawer).drawOutline = 1;
        }
        double angleAdjustment = (double)centerAngleInDegrees * 0.0174533 - (characterAnglesInRadians[characterCount - 1] - characterAnglesInRadians[0]) / 2.0;
        int index = 0;
        while (index < characterCount) {
            int n = index++;
            characterAnglesInRadians[n] = characterAnglesInRadians[n] + angleAdjustment;
        }
        AffineTransform stringTransform = oldTransform;
        if (stringTransform == null) {
            stringTransform = new AffineTransform();
        }
        for (int index2 = 0; index2 < characterCount; ++index2) {
            if (charactersAreSpaces[index2]) continue;
            GlyphVector glyphVector = characterGlyphVectors[index2];
            Rectangle2D glyphBounds = characterGlyphBounds[index2];
            if (flip) {
                AffineTransform oldGlyphVectorTransform = glyphVector.getGlyphTransform(0);
                if (oldGlyphVectorTransform == null) {
                    oldGlyphVectorTransform = new AffineTransform();
                }
                AffineTransform newGlyphVectorTransform = new AffineTransform(oldGlyphVectorTransform);
                newGlyphVectorTransform.scale(-1.0, -1.0);
                newGlyphVectorTransform.translate(-(glyphBounds.getWidth() + glyphBounds.getX() + glyphBounds.getX()), glyphBounds.getHeight() + (maxAscent - characterAscents[index2]) - characterDescents[index2] - maxDescent);
                glyphVector.setGlyphTransform(0, newGlyphVectorTransform);
            }
            AffineTransform characterTransform = new AffineTransform(stringTransform);
            characterTransform.translate(centerX, centerY);
            characterTransform.rotate(characterAnglesInRadians[index2]);
            characterTransform.translate(-(glyphBounds.getX() + glyphBounds.getWidth() / 2.0), -(actualRadius + maxDescent));
            g.setTransform(characterTransform);
            glyphDrawer.drawGlyph(g, glyphVector.getOutline(0.0f, 0.0f));
        }
        glyphDrawer.restoreGraphicsStateAfterDraw(g);
        g.setTransform(oldTransform);
        return shape;
    }

    private static GeneralPath genToHitShape(ReturnShape shape, int centerX, int centerY) {
        double degreeAngleStop = DrawCircularText.adjustAngle(shape.degreeAngleStart);
        GeneralPath newShape = new GeneralPath();
        Arc2D.Double topArc = new Arc2D.Double((double)centerX - shape.outerRadius, (double)centerY - shape.outerRadius, shape.outerRadius * 2.0, shape.outerRadius * 2.0, degreeAngleStop - shape.degreeAngleSweep, shape.degreeAngleSweep, 0);
        Arc2D.Double botArc = new Arc2D.Double((double)centerX - shape.innerRadius, (double)centerY - shape.innerRadius, shape.innerRadius * 2.0, shape.innerRadius * 2.0, degreeAngleStop, -shape.degreeAngleSweep, 0);
        Point2D topStart = topArc.getStartPoint();
        Point2D botStart = botArc.getStartPoint();
        newShape.moveTo(topStart.getX(), topStart.getY());
        newShape.append(topArc, false);
        newShape.lineTo(botStart.getX(), botStart.getY());
        newShape.append(botArc, true);
        newShape.closePath();
        return newShape;
    }

    private static double adjustAngle(double angle) {
        return angle <= 90.0 ? 90.0 - angle : 360.0 - (angle - 90.0);
    }

    public static class ReturnShape {
        int centerX;
        int centerY;
        public double degreeAngleSweep;
        public double degreeAngleStart;
        public double degreeAngleStop;
        public double innerRadius;
        public double outerRadius;
        public GeneralPath stringPath;
        GeneralPath toHitShape;

        public GeneralPath getToHitShape() {
            if (this.toHitShape == null) {
                this.toHitShape = DrawCircularText.genToHitShape(this, this.centerX, this.centerY);
            }
            return this.toHitShape;
        }
    }

    public static enum CircularTextPosition {
        OUTSIDE_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius;
            }
        }
        ,
        BASELINE_ON_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius - (flip ? maxAscent : maxDescent);
            }
        }
        ,
        INSIDE_CIRCLE{

            @Override
            double calculateActualRadius(double radius, double maxAscent, double maxDescent, boolean flip) {
                return radius - maxAscent - maxDescent;
            }
        };


        abstract double calculateActualRadius(double var1, double var3, double var5, boolean var7);
    }

    public static interface GlyphDrawer {
        public void saveGraphicsStateBeforeDraw(Graphics2D var1);

        public void drawGlyph(Graphics2D var1, Shape var2);

        public void restoreGraphicsStateAfterDraw(Graphics2D var1);
    }

    public static class OutlinedFilledGlyphDrawer
    implements GlyphDrawer {
        public static final int USE_NO_HIGHLIGHT_COLOR = 0;
        public static final int USE_PRIVATE_HIGHLIGHT_COLOR = 1;
        public static final int USE_GLOBAL_HIGHLIGHT_COLOR = 2;
        public static Color globalOutlineColor = Color.YELLOW;
        Color oldGraphicsStateColor;
        Stroke oldGraphicsStateStroke;
        Color fillColor;
        public Color privateOutlineColor = Color.white;
        Stroke stroke = new BasicStroke(1.0f, 0, 1);
        Stroke strokeHighlight = new BasicStroke(2.0f, 0, 1);
        int drawOutline = 2;
        boolean drawFill = true;

        public Color getDrawOutlineColor() {
            return this.privateOutlineColor;
        }

        public void setDrawOutlineColor(Color outlineColor) {
            this.privateOutlineColor = outlineColor;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void setDrawOutline(int drawOutline) {
            this.drawOutline = drawOutline;
        }

        public int getDrawOutline() {
            return this.drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor) {
            this.fillColor = textColor;
            this.drawOutline = 2;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, int drawOutline) {
            this.fillColor = textColor;
            this.drawOutline = drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor) {
            this.fillColor = textColor;
            this.privateOutlineColor = outlineColor;
            this.drawOutline = 1;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke) {
            this.fillColor = textColor;
            this.privateOutlineColor = outlineColor;
            this.drawOutline = 1;
            this.stroke = stroke;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke, int drawOutline) {
            this.fillColor = textColor;
            globalOutlineColor = outlineColor;
            this.stroke = stroke;
            this.drawOutline = drawOutline;
        }

        public OutlinedFilledGlyphDrawer(Color textColor, Color outlineColor, Stroke stroke, int drawOutline, boolean drawFill) {
            this.fillColor = textColor;
            globalOutlineColor = outlineColor;
            this.stroke = stroke;
            this.drawOutline = drawOutline;
            this.drawFill = drawFill;
        }

        @Override
        public void saveGraphicsStateBeforeDraw(Graphics2D g) {
            this.oldGraphicsStateColor = g.getColor();
            this.oldGraphicsStateStroke = g.getStroke();
        }

        @Override
        public void drawGlyph(Graphics2D preTransformedG, Shape glyph) {
            if (this.drawOutline > 0) {
                preTransformedG.setColor(this.drawOutline == 2 ? globalOutlineColor : this.privateOutlineColor);
                preTransformedG.setStroke(this.strokeHighlight);
                preTransformedG.draw(glyph);
            }
            if (this.drawFill) {
                preTransformedG.setColor(this.fillColor);
                preTransformedG.fill(glyph);
            }
        }

        @Override
        public void restoreGraphicsStateAfterDraw(Graphics2D g) {
            g.setColor(this.oldGraphicsStateColor);
            g.setStroke(this.oldGraphicsStateStroke);
        }
    }
}

