/*
 * Decompiled with CFR 0.152.
 */
package StatusBarDialogs;

import JMScrollBars.JMProgressBar;
import StatusBarDialogs.ThreadRunner;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanProperty;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FrmStatusBar
extends JDialog {
    private boolean cancelled = false;
    private ThreadRunner activeRunner = null;
    private JButton cmdCancel;
    private JPanel jPanel1;
    public JMProgressBar progressBar;

    public FrmStatusBar(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.progressBar.setMinimum(0L);
        this.progressBar.setMaximum(100L);
    }

    public void run(final ThreadRunner ... runners) {
        boolean cancellable = false;
        for (ThreadRunner runner : runners) {
            if (runner == null || !runner.isCancellable()) continue;
            cancellable = true;
            break;
        }
        this.cmdCancel.setVisible(cancellable);
        this.cmdCancel.setEnabled(cancellable);
        this.cmdCancel.setText("Cancel");
        this.pack();
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        this.setLocationRelativeTo(this.getParent());
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (ThreadRunner runner : runners) {
                    if (runner == null) continue;
                    FrmStatusBar.this.activeRunner = runner;
                    if (runner.isCancellable() && FrmStatusBar.this.cancelled) break;
                    runner.run();
                    if (runner.isCancelled()) break;
                }
                return null;
            }

            @Override
            protected void done() {
                FrmStatusBar.this.activeRunner = null;
                FrmStatusBar.this.cancelled = false;
                FrmStatusBar.this.setVisible(false);
            }
        }.execute();
        super.setVisible(true);
    }

    public void runSameThread(ThreadRunner runner) {
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(true);
        runner.run();
        this.setVisible(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.progressBar = new JMProgressBar();
        this.cmdCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Opening Project");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(new Dimension(200, 25));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FrmStatusBar.this.formKeyPressed(evt);
            }
        });
        this.jPanel1.setOpaque(false);
        this.progressBar.setBackground(new Color(204, 204, 204));
        this.progressBar.setBorderColor(new Color(255, 255, 255));
        this.progressBar.setProgressBarColor(new Color(51, 255, 51));
        this.progressBar.setFont(new Font("Segoe UI", 1, 14));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmStatusBar.this.cmdCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, 271, Short.MAX_VALUE).addComponent(this.cmdCancel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.progressBar, -1, 45, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.cmdCancel).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        if (this.activeRunner != null && this.activeRunner.isCancellable()) {
            this.activeRunner.setCancelled(true);
            this.cmdCancel.setText("Cancelling...");
            this.cmdCancel.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmStatusBar.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmStatusBar.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmStatusBar.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmStatusBar.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmStatusBar dialog = new FrmStatusBar((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @BeanProperty(preferred=true, description="Sets the maximum value allowed for the progress bar")
    public void setMaximum(long newValue) {
        this.progressBar.setMaximum(newValue);
    }

    public void setMaximum(int newValue) {
        this.progressBar.setMaximum(newValue);
    }

    public long getMaximum() {
        return this.progressBar.getMaximum();
    }

    @BeanProperty(preferred=true, description="Sets the minimum value allowed for the progress bar")
    public void setMinimum(long newValue) {
        this.progressBar.setMinimum(newValue);
    }

    public void setMinimum(int newValue) {
        this.progressBar.setMinimum(newValue);
    }

    public long getMinimum() {
        return this.progressBar.getMinimum();
    }

    @BeanProperty(hidden=true)
    public void setValues(int min, int max) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
    }

    @BeanProperty(hidden=true)
    public void setValues(int min, int max, int value) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(value);
    }

    @BeanProperty(hidden=true)
    public void setValues(int min, int max, String title) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(0);
        this.setTitle(title);
    }

    @BeanProperty(hidden=true)
    public void setValues(int min, int max, int value, String title) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(value);
        this.setTitle(title);
    }

    @BeanProperty(hidden=true)
    public void setValues(long min, long max, String title) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(0);
        this.setTitle(title);
    }

    @BeanProperty(hidden=true)
    public void setValues(long min, long max, long value, String title) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(value);
        this.setTitle(title);
    }

    @BeanProperty(preferred=true, description="Sets the value for the progress bar")
    public void setValue(long newValue) {
        this.progressBar.setValue(newValue);
    }

    @BeanProperty(hidden=true)
    public void setValue(int newValue) {
        this.progressBar.setValue(newValue);
    }

    public long getValue() {
        return this.progressBar.getValue();
    }

    @BeanProperty(preferred=true, description="If true, the progress bar displays the value as a percent of the maximum.  Otherwise the raw value is shown.")
    public void setShowPercent(boolean show) {
        if (show && this.progressBar.getShowValueStyle() != 0) {
            this.progressBar.setShowValueStyle(0);
        } else if (!show && this.progressBar.getShowValueStyle() != 2) {
            this.progressBar.setShowValueStyle(2);
        }
    }

    public boolean isShowPercent() {
        return this.progressBar.getShowValueStyle() == 0;
    }

    @BeanProperty(preferred=true, description="Sets the fill color for the progressbar.")
    public void setBarFillColor(Color color) {
        this.progressBar.setProgressBarColor(color);
    }

    public Color getBarFillColor() {
        return this.progressBar.getProgressBarColor();
    }

    @BeanProperty(preferred=true, description="Sets the border color for the progressbar.")
    public void setBarBorderColor(Color color) {
        this.progressBar.setBorderColor(color);
    }

    public Color getBarBorderColor() {
        return this.progressBar.getBorderColor();
    }
}

