/*
 * Decompiled with CFR 0.152.
 */
package SplitFrame;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class SimpleSplitFrame
extends JPanel {
    Component c1 = new JPanel();
    Component c2 = new JPanel();
    Divider divider;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DIVIDER_SIZE = 5;
    private ORIENTATIONS orientation = ORIENTATIONS.Null;
    private boolean mousePressed = false;
    private static final Cursor resizeCursorH = new Cursor(11);
    private static final Cursor resizeCursorV = new Cursor(8);
    private static final Cursor defaultCursor = new Cursor(0);

    public SimpleSplitFrame() {
        this.initFrame(ORIENTATIONS.Horizontal);
    }

    public SimpleSplitFrame(ORIENTATIONS orientation) {
        this.initFrame(orientation);
    }

    public Component getComponent1() {
        return this.c1;
    }

    public Component getComponent2() {
        return this.c2;
    }

    public void setOrientation(ORIENTATIONS orientation) {
        if (!this.orientation.equals((Object)orientation)) {
            this.orientation = orientation;
            if (orientation.equals((Object)ORIENTATIONS.Horizontal)) {
                this.divider = new DividerH();
            } else if (orientation.equals((Object)ORIENTATIONS.Vertical)) {
                this.divider = new DividerV();
            }
        }
    }

    public ORIENTATIONS getOrientation() {
        return this.orientation;
    }

    public void setDividerLocation(int location) {
        this.divider.setDividerLocation(location);
    }

    public void setRelDividerLocation(float location) {
        this.divider.setRelativeWeight(location);
    }

    private void initFrame(ORIENTATIONS orientation) {
        this.setOrientation(orientation);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (SimpleSplitFrame.this.divider.mouseOver(arg0)) {
                    SimpleSplitFrame.this.mousePressed = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                SimpleSplitFrame.this.mousePressed = false;
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                SimpleSplitFrame.this.setCursor(defaultCursor);
                SimpleSplitFrame.this.divider.mouseOverDivider = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent arg0) {
                if (SimpleSplitFrame.this.mousePressed) {
                    SimpleSplitFrame.this.divider.mouseDragged(arg0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
                if (!SimpleSplitFrame.this.mousePressed) {
                    SimpleSplitFrame.this.divider.mouseOver(arg0);
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                SimpleSplitFrame.this.divider.resizeComponents();
                SimpleSplitFrame.this.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.setRelDividerLocation(0.3f);
        this.setVisible(true);
    }

    public void setComponent1(Component c) {
        if (this.c1 != null || c == null) {
            this.remove(this.c1);
        }
        if (c == null) {
            return;
        }
        this.add(c);
        this.c1 = c;
        this.divider.resizeComponents();
        this.revalidate();
    }

    public void setComponent2(Component c) {
        if (this.c2 != null || c == null) {
            this.remove(this.c2);
        }
        if (c == null) {
            return;
        }
        this.add(c);
        this.c2 = c;
        this.divider.resizeComponents();
        this.revalidate();
    }

    public static enum ORIENTATIONS {
        Horizontal,
        Vertical,
        Null;

    }

    private class DividerH
    extends Divider {
        public DividerH() {
            this.resizeCursor = resizeCursorH;
        }

        @Override
        public void setDividerLocation(int newLocation) {
            int wd = SimpleSplitFrame.this.getWidth();
            this.left = Math.max(Math.min(newLocation, wd - 10), 5);
            this.right = this.left + 5;
            this.bottom = SimpleSplitFrame.this.getHeight();
            if (wd > 10) {
                if (SimpleSplitFrame.this.c1 != null) {
                    SimpleSplitFrame.this.c1.setBounds(0, 0, this.left, this.bottom);
                    SimpleSplitFrame.this.c1.revalidate();
                }
                if (SimpleSplitFrame.this.c2 != null) {
                    SimpleSplitFrame.this.c2.setBounds(this.right, 0, wd - this.right, this.bottom);
                    SimpleSplitFrame.this.c2.revalidate();
                }
                SimpleSplitFrame.this.revalidate();
            }
        }

        @Override
        public int getDividerLocation() {
            return this.left;
        }

        @Override
        public void resizeComponents() {
            this.setDividerLocation(this.left);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.setDividerLocation(e.getX());
        }
    }

    private abstract class Divider {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        float relWeight = 0.3f;
        boolean mouseOverDivider = false;
        Cursor resizeCursor;

        private Divider() {
        }

        public abstract void setDividerLocation(int var1);

        public abstract int getDividerLocation();

        public abstract void resizeComponents();

        public abstract void mouseDragged(MouseEvent var1);

        public void setRelativeWeight(float rw) {
            if (rw > 0.1f && rw < 0.9f) {
                this.relWeight = rw;
                SimpleSplitFrame.this.divider.setDividerLocation((int)((float)SimpleSplitFrame.this.getWidth() * SimpleSplitFrame.this.divider.relWeight));
                this.resizeComponents();
            }
        }

        public float getRelativeWeight() {
            return this.relWeight;
        }

        private boolean mouseOver(MouseEvent e) {
            boolean newMouseOverDivider;
            int mx = e.getX();
            int my = e.getY();
            boolean bl = newMouseOverDivider = mx >= this.left && mx <= this.right && my >= this.top && my <= this.bottom;
            if (newMouseOverDivider != this.mouseOverDivider) {
                this.mouseOverDivider = newMouseOverDivider;
                SimpleSplitFrame.this.setCursor(this.mouseOverDivider ? SimpleSplitFrame.this.divider.resizeCursor : defaultCursor);
            }
            return this.mouseOverDivider;
        }
    }

    private class DividerV
    extends Divider {
        public DividerV() {
            this.resizeCursor = resizeCursorV;
        }

        @Override
        public void setDividerLocation(int newLocation) {
            int ht = SimpleSplitFrame.this.getHeight();
            this.top = Math.max(Math.min(newLocation, ht - 10), 5);
            this.bottom = this.top + 5;
            this.right = SimpleSplitFrame.this.getWidth();
            this.left = 0;
            if (ht > 10) {
                if (SimpleSplitFrame.this.c1 != null) {
                    SimpleSplitFrame.this.c1.setBounds(0, 0, this.right, this.top);
                }
                if (SimpleSplitFrame.this.c2 != null) {
                    SimpleSplitFrame.this.c2.setBounds(0, this.bottom, this.right, SimpleSplitFrame.this.getHeight() - this.bottom);
                }
            }
        }

        @Override
        public int getDividerLocation() {
            return this.top;
        }

        @Override
        public void resizeComponents() {
            this.setDividerLocation(this.top);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.setDividerLocation(e.getY());
        }
    }
}

