/*
 * Decompiled with CFR 0.152.
 */
package SnapGeneFileReader;

import SnapGeneFileReader.XMLAttribute;
import SnapGeneFileReader.XMLConstants;
import SnapGeneFileReader.XMLDocument;
import SnapGeneFileReader.XMLParser;
import java.util.ArrayList;

class XMLElement
implements XMLConstants {
    public ArrayList<XMLElement> elements;
    String name = null;
    int m_eStyle = 0;
    public ArrayList<XMLAttribute> attributes;
    XMLElement parent;
    String body = "";
    protected boolean forceCharData = false;

    public XMLElement() {
    }

    public XMLElement(String name) {
        this.name = name;
    }

    public String toString() {
        return super.toString() + ", name=" + this.name + ", attributes=" + (this.attributes != null ? Integer.valueOf(this.attributes.size()) : "0") + ", elements=" + (this.elements != null ? Integer.valueOf(this.elements.size()) : "0");
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasText() {
        return this.body != null && this.body.length() > 0;
    }

    public String getText() {
        if (this.hasText()) {
            return this.body;
        }
        return "";
    }

    public void setText(String text) {
        this.body = text;
        if (this.body == null) {
            this.body = "";
        }
    }

    public boolean isForceCharData() {
        return this.forceCharData;
    }

    public void setForceCharData(boolean forceCharData) {
        this.forceCharData = forceCharData;
    }

    public int getTagStyle() {
        return this.m_eStyle;
    }

    public void setTagStyle(int tagStyle) {
        this.m_eStyle = tagStyle;
    }

    public void setTagType(String RHS) {
        this.name = RHS;
    }

    public String getTagType() {
        return this.name;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasElements() {
        return this.elements != null && !this.elements.isEmpty();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public void setParent(XMLElement parent) {
        if (parent == null) {
            if (this.parent != null) {
                this.parent.removeElement(this);
            }
        } else {
            parent.addElement(this);
        }
    }

    public int getAttributeCount() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return 0;
        }
        return this.attributes.size();
    }

    public int getElementCount() {
        if (this.elements == null || this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.size();
    }

    public void addElement(XMLElement element) {
        this.addElement(element, 0);
    }

    public XMLElement addElement(String name) {
        return this.addElement(name, "", 0);
    }

    public XMLElement addElement(String name, String body) {
        return this.addElement(name, body, 0);
    }

    public XMLElement addElement(String name, String body, int before) {
        XMLElement element = new XMLElement();
        element.setName(name);
        element.body = body;
        this.addElement(element, before);
        return element;
    }

    public void addElement(XMLElement element, int before) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (this.elements.contains(element)) {
            return;
        }
        if (element.parent != null) {
            element.parent.removeElement(element);
        }
        if (before == 0) {
            this.elements.add(element);
        } else {
            this.elements.add(before, element);
        }
        element.parent = this;
    }

    public XMLElement getElement(int index) {
        if (this.elements == null || index >= this.elements.size()) {
            return null;
        }
        return this.elements.get(index);
    }

    public XMLElement getElement(String keyWord) {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        for (XMLElement element : this.elements) {
            if (!element.name.equals(keyWord)) continue;
            return element;
        }
        return null;
    }

    public String getChildElementText(String keyWord, String defaultText, int startingIndex) {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        for (int x = startingIndex; x < this.elements.size(); ++x) {
            XMLElement element = this.elements.get(x);
            if (!element.name.equals(keyWord)) continue;
            return element.body;
        }
        return defaultText;
    }

    public String getChildElementText(String keyWord, String defaultText) {
        return this.getChildElementText(keyWord, defaultText, 0);
    }

    public int getIndex() {
        if (this.parent == null || this.parent.elements == null) {
            return -1;
        }
        return this.parent.elements.indexOf(this);
    }

    public XMLElement[] getElements() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        XMLElement[] outArray = new XMLElement[this.elements.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = this.elements.get(x);
        }
        return outArray;
    }

    public int getElementIndex(String keyWord) {
        if (this.elements == null || this.elements.isEmpty()) {
            return -1;
        }
        for (int x = 0; x < this.elements.size(); ++x) {
            if (!this.elements.get(x).getName().equalsIgnoreCase(keyWord)) continue;
            return x;
        }
        return -1;
    }

    public void addAttribute(XMLAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        if (!this.attributes.contains(attribute)) {
            if (attribute.parent != null && this.parent.attributes.contains(attribute)) {
                this.parent.attributes.remove(attribute);
            }
            this.attributes.add(attribute);
            attribute.parent = this;
        }
    }

    public XMLAttribute addAttribute(String keyWord, boolean value) {
        return this.addAttribute(keyWord, value ? "true" : "false");
    }

    public XMLAttribute addAttribute(String keyWord, int value) {
        return this.addAttribute(keyWord, String.valueOf(value));
    }

    public XMLAttribute addAttribute(String keyWord, String value) {
        XMLAttribute attrib = new XMLAttribute(keyWord, value);
        this.addAttribute(attrib);
        return attrib;
    }

    public XMLAttribute getAttribute(int index) {
        if (this.attributes == null || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index);
    }

    public int getAttribute(String name, int defaultVal) {
        return Integer.valueOf(this.getAttribute(name, String.valueOf(defaultVal)));
    }

    public boolean getAttribute(String name, boolean defaultVal) {
        String sVal;
        switch (sVal = this.getAttribute(name, "false").toLowerCase()) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        return defaultVal;
    }

    public String getAttribute(String name, String defaultVal) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            for (XMLAttribute attribute : this.attributes) {
                if (!attribute.keyWord.equals(name)) continue;
                return attribute.value;
            }
        }
        return defaultVal;
    }

    public float getAttribute(String name, float defaultVal) {
        return Float.valueOf(this.getAttribute(name, String.valueOf(defaultVal))).floatValue();
    }

    public long getAttribute(String name, long defaultVal) {
        return Long.valueOf(this.getAttribute(name, String.valueOf(defaultVal)));
    }

    int getAttributeIndex(String keyWord) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return -1;
        }
        for (int x = 0; x < this.attributes.size(); ++x) {
            if (!this.attributes.get((int)x).keyWord.equalsIgnoreCase(keyWord)) continue;
            return x;
        }
        return -1;
    }

    public XMLAttribute[] getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return null;
        }
        XMLAttribute[] outArray = new XMLAttribute[this.attributes.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = this.attributes.get(x);
        }
        return outArray;
    }

    public void removeAttribute(int index) {
        if (this.attributes == null || this.attributes.size() < index) {
            return;
        }
        this.attributes.remove(index);
    }

    public void removeAttribute(String keyWord) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return;
        }
        int foundIndex = -1;
        for (int x = 0; x < this.attributes.size(); ++x) {
            XMLAttribute attribute = this.attributes.get(x);
            if (!attribute.keyWord.equalsIgnoreCase(keyWord)) continue;
            foundIndex = x;
            break;
        }
        if (foundIndex > -1) {
            this.attributes.remove(foundIndex);
        }
    }

    public void removeElement(int index) {
        if (this.elements != null && this.elements.size() > index) {
            XMLElement child = this.elements.get(index);
            child.parent = null;
            this.elements.remove(child);
        }
    }

    public void removeElement(XMLElement element) {
        if (this.elements != null && !this.elements.isEmpty()) {
            element.parent = null;
            this.elements.remove(element);
        }
    }

    public void removeElement(String keyWord) {
        int index = this.getElementIndex(keyWord);
        if (index > -1) {
            this.removeElement(index);
        }
    }

    public void setName(String RHS) {
        this.name = RHS;
    }

    public String getName() {
        return this.name;
    }

    String serializeTag(int tagStyle) {
        if (tagStyle == 0 || tagStyle == 2) {
            StringBuilder builder = new StringBuilder("<" + this.name);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (XMLAttribute attribute : this.attributes) {
                    builder.append(" ").append(attribute.serialize());
                }
            }
            if (tagStyle == 2) {
                builder.append("/>");
            } else {
                builder.append(">");
            }
            return builder.toString();
        }
        return "</" + this.name + ">";
    }

    private String serializeTag() {
        return this.serializeTag(0);
    }

    public String serialize() {
        if (this.name == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.serializeTag());
        if (this.body != null && this.body.length() > 0) {
            if (this.body.length() > 49) {
                builder.append("\r\n" + XMLParser.escapeString(this.body) + "\r\n");
            } else {
                builder.append(XMLParser.escapeString(this.body));
            }
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            for (XMLElement element : this.elements) {
                builder.append(element.serialize());
            }
        }
        builder.append(this.serializeTag(1));
        return builder.toString();
    }

    public String exportToString() {
        return this.exportToString(0);
    }

    public String exportToString(int indentLevel) {
        boolean haveElements;
        StringBuilder outString = new StringBuilder();
        int spacesPerIndent = 4;
        String indent = "";
        String NLIndent = "";
        String NLIndent2 = "";
        if (this.name == null) {
            return "";
        }
        if (indentLevel > 0) {
            indent = XMLDocument.repeat(' ', indentLevel * spacesPerIndent);
        }
        NLIndent = "\r\n" + indent;
        NLIndent2 = "\r\n" + XMLDocument.repeat(' ', (indentLevel + 1) * spacesPerIndent);
        String tmpBody = null;
        if (this.parent != null) {
            outString.append(NLIndent);
        }
        outString.append(this.serializeTag());
        boolean haveBody = false;
        boolean bl = haveElements = this.elements != null && !this.elements.isEmpty();
        if (this.body != null && this.body.length() > 0 && (tmpBody = XMLParser.escapeString(this.body)) != null && tmpBody.length() > 0) {
            if (haveElements || tmpBody.contains("\r\n")) {
                haveBody = true;
                outString.append(NLIndent2).append(tmpBody.replace("\r\n", NLIndent2));
            } else {
                outString.append(tmpBody);
            }
        }
        if (haveElements) {
            haveElements = true;
            for (XMLElement element : this.elements) {
                outString.append(element.exportToString(indentLevel + 1));
            }
        }
        if (haveBody || haveElements) {
            outString.append(NLIndent);
        }
        outString.append(this.serializeTag(1));
        return outString.toString();
    }
}

