/*
 * Decompiled with CFR 0.152.
 */
package SnapGeneFileReader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class SnapGene {
    SnapGene() {
    }

    public static void main(String[] args) throws IOException {
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".dna")) {
                    System.out.println("parsing: " + file.toString());
                    FileInputStream fis = new FileInputStream(file.toFile());
                    boolean negativeTest = file.getFileName().toString().startsWith("bad_");
                    if (negativeTest) {
                        try {
                            SnapGeneDoc snapGeneDoc = SnapGene.parse(fis);
                        }
                        catch (Exception e) {
                            System.out.println("Caught expected exception parsing negative test case: " + e.toString());
                            e.printStackTrace();
                        }
                    } else {
                        SnapGeneDoc snapGeneDoc = SnapGene.parse(fis);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Path p = Paths.get(args[0], new String[0]);
        Files.walkFileTree(p, (FileVisitor<? super Path>)visitor);
    }

    public static SnapGeneDoc parse(InputStream is) throws IOException {
        int count;
        SnapGeneDoc doc = new SnapGeneDoc();
        byte[] bs = new byte[5];
        while ((count = is.read(bs)) == 5) {
            Segment seg;
            byte[] data;
            byte type = bs[0];
            int len = ByteBuffer.wrap(bs, 1, 4).getInt();
            if (len != is.read(data = new byte[len])) {
                throw new IllegalArgumentException("Expected " + len + " bytes");
            }
            switch (type) {
                case 0: {
                    if (doc.dna != null) {
                        throw new IllegalArgumentException("Duplicate DNA segment");
                    }
                    doc.dna = DNASegment.parse(data);
                    seg = doc.dna;
                    break;
                }
                case 6: {
                    if (doc.notes != null) {
                        throw new IllegalArgumentException("Duplicate notes segment");
                    }
                    doc.notes = NotesSegment.parse(data);
                    seg = doc.notes;
                    break;
                }
                case 9: {
                    if (doc.desc != null) {
                        throw new IllegalArgumentException("Duplicate description segment");
                    }
                    doc.desc = DescriptionSegment.parse(data);
                    seg = doc.desc;
                    break;
                }
                case 10: {
                    if (doc.features != null) {
                        throw new IllegalArgumentException("Duplicate features segment");
                    }
                    doc.features = FeaturesSegment.parse(data);
                    seg = doc.features;
                    break;
                }
                default: {
                    seg = UnsupportedSegment.parse(type, data);
                }
            }
            doc.segments.add(seg);
        }
        if (doc.desc == null) {
            throw new IllegalArgumentException("SnapGene description segment not found");
        }
        return doc;
    }

    static Document createDocument(String xml) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Error parsing XML", e);
        }
    }

    static List<Element> getElements(Element parent) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            ret.add((Element)node);
        }
        return ret;
    }

    static List<Element> getElementsByTagName(Element parent, String tagName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element child;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !(child = (Element)node).getTagName().equals(tagName)) continue;
            ret.add(child);
        }
        return ret;
    }

    static Element getElementByTagName(Element parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element child;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !(child = (Element)node).getTagName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    static String getInnerText(Element el) {
        NodeList nl = el.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return "";
        }
        if (len == 1) {
            return nl.item(0).getNodeValue();
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            ret.append(nl.item(i).getNodeValue());
        }
        return ret.toString();
    }

    static String getElementInnerText(Element parent, String tagName) {
        Element child = SnapGene.getElementByTagName(parent, tagName);
        if (child == null) {
            return null;
        }
        return SnapGene.getInnerText(child);
    }

    static String getAttribute(Element el, String name, String ... alternateNames) {
        if (el.hasAttribute(name)) {
            return el.getAttribute(name);
        }
        for (String attrName : alternateNames) {
            if (!el.hasAttribute(attrName)) continue;
            return el.getAttribute(attrName);
        }
        return null;
    }

    static String getAttribute(Element el, QName name, QName ... alternateNames) {
        if (el.hasAttributeNS(name.getNamespaceURI(), name.getLocalPart())) {
            return el.getAttributeNS(name.getNamespaceURI(), name.getLocalPart());
        }
        for (QName attrName : alternateNames) {
            if (!el.hasAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart())) continue;
            return el.getAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
        }
        return null;
    }

    static Set<String> getOtherAttributeNames(Element el, Set<String> except) {
        HashSet<String> attrs = new HashSet<String>();
        NamedNodeMap nnm = el.getAttributes();
        int len = nnm.getLength();
        for (int i = 0; i < len; ++i) {
            String name;
            Node node = nnm.item(i);
            if (!(node instanceof Attr) || except.contains(name = ((Attr)node).getName())) continue;
            attrs.add(name);
        }
        return attrs;
    }

    static String toXMLString(Element el) {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(el);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return result.getWriter().toString();
    }

    private static Date parseDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Boolean parseBool(String boolStr) {
        if (boolStr == null) {
            return null;
        }
        return "1".equals(boolStr);
    }

    private static Integer parseInt(String intStr) {
        if (intStr == null) {
            return null;
        }
        try {
            return Integer.valueOf(intStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Double parseDouble(String doubleStr) {
        if (doubleStr == null) {
            return null;
        }
        try {
            return Double.parseDouble(doubleStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class SnapGeneDoc {
        public DescriptionSegment desc;
        public DNASegment dna;
        public NotesSegment notes;
        public FeaturesSegment features;
        public List<Segment> segments = new ArrayList<Segment>(10);

        SnapGeneDoc() {
        }
    }

    static class DNASegment
    extends Segment {
        public static final int TYPE = 0;
        public final String topology;
        public final String strandedness;
        public final boolean Dam;
        public final boolean Dcm;
        public final boolean EcoKI;
        public final String sequence;

        public DNASegment(String topology, String strandedness, boolean Dam, boolean Dcm, boolean EcoKI, String sequence) {
            this.topology = topology;
            this.strandedness = strandedness;
            this.Dam = Dam;
            this.Dcm = Dcm;
            this.EcoKI = EcoKI;
            this.sequence = sequence;
        }

        public static DNASegment parse(byte[] data) {
            byte flags = data[0];
            String sequence = new String(data, 1, data.length - 1, Charset.forName("US-ASCII"));
            BitSet bs = BitSet.valueOf(new byte[]{flags});
            String topology = bs.get(0) ? "circular" : "linear";
            String strandedness = bs.get(1) ? "double-stranded" : "single-stranded";
            boolean Dam = bs.get(2);
            boolean Dcm = bs.get(3);
            boolean EcoKI = bs.get(4);
            return new DNASegment(topology, strandedness, Dam, Dcm, EcoKI, sequence);
        }
    }

    static class NotesSegment
    extends Segment {
        public static final int TYPE = 6;
        public final String uuid;
        public final String type;
        public final Boolean confirmedExperimentally;
        public final String description;
        public final Date created;
        public final Date modified;
        public final String createdBy;
        public final String accessionNumber;
        public final String codeNumber;
        public final String organism;
        public final String sequenceClass;
        public final String transformedInto;
        public final String customMapLabel;
        public final Boolean useCustomMapLabel;
        public final String comments;
        public final List<Reference> references;

        public NotesSegment(String uuid, String type, Boolean confirmedExperimentally, String description, Date created, Date modified, String createdBy, String accessionNumber, String codeNumber, String organism, String sequenceClass, String transformedInto, String customMapLabel, Boolean useCustomMapLabel, String comments, List<Reference> references) {
            this.uuid = uuid;
            this.type = type;
            this.confirmedExperimentally = confirmedExperimentally;
            this.description = description;
            this.created = created;
            this.modified = modified;
            this.createdBy = createdBy;
            this.accessionNumber = accessionNumber;
            this.codeNumber = codeNumber;
            this.organism = organism;
            this.sequenceClass = sequenceClass;
            this.transformedInto = transformedInto;
            this.customMapLabel = customMapLabel;
            this.useCustomMapLabel = useCustomMapLabel;
            this.comments = comments;
            this.references = references;
        }

        public static NotesSegment parse(byte[] data) {
            String s = new String(data, Charset.forName("UTF-8"));
            return NotesSegment.parse(SnapGene.createDocument(s));
        }

        private static NotesSegment parse(Document doc) {
            Element docEl = doc.getDocumentElement();
            if (!"Notes".equals(docEl.getTagName())) {
                throw new IllegalArgumentException("Expected 'Notes' element");
            }
            String uuid = SnapGene.getElementInnerText(docEl, "UUID");
            String type = SnapGene.getElementInnerText(docEl, "Type");
            Boolean confirmedExperimentally = SnapGene.parseBool(SnapGene.getElementInnerText(docEl, "ConfirmedExperimentally"));
            String description = SnapGene.getElementInnerText(docEl, "Description");
            Date created = SnapGene.parseDate(SnapGene.getElementInnerText(docEl, "Created"));
            Date modified = SnapGene.parseDate(SnapGene.getElementInnerText(docEl, "LastModified"));
            String createdBy = SnapGene.getElementInnerText(docEl, "CreatedBy");
            String accessionNumber = SnapGene.getElementInnerText(docEl, "AccessionNumber");
            String codeNumber = SnapGene.getElementInnerText(docEl, "CodeNumber");
            String organism = SnapGene.getElementInnerText(docEl, "Organism");
            String sequenceClass = SnapGene.getElementInnerText(docEl, "SequenceClass");
            String transformedInto = SnapGene.getElementInnerText(docEl, "TransformedInto");
            String customMapLabel = SnapGene.getElementInnerText(docEl, "CustomMapLabel");
            Boolean useCustomMapLabel = SnapGene.parseBool(SnapGene.getElementInnerText(docEl, "CustomMapLabel"));
            String comments = SnapGene.getElementInnerText(docEl, "Comments");
            ArrayList<Reference> references = new ArrayList<Reference>(4);
            Element refsEl = SnapGene.getElementByTagName(docEl, "References");
            List<Element> refEls = refsEl != null ? SnapGene.getElementsByTagName(refsEl, "Reference") : Collections.emptyList();
            for (Element refEl : refEls) {
                String title = SnapGene.getAttribute(refEl, "title", new String[0]);
                String pubMedID = SnapGene.getAttribute(refEl, "pubMedID", new String[0]);
                String journal = SnapGene.getAttribute(refEl, "journal", new String[0]);
                String authors = SnapGene.getAttribute(refEl, "authors", new String[0]);
                references.add(new Reference(title, pubMedID, journal, authors));
            }
            return new NotesSegment(uuid, type, confirmedExperimentally, description, created, modified, createdBy, accessionNumber, codeNumber, organism, sequenceClass, transformedInto, customMapLabel, useCustomMapLabel, comments, references);
        }
    }

    static class DescriptionSegment
    extends Segment {
        public static final int TYPE = 9;
        public final String type;
        public final short exportVersion;
        public final short importVersion;

        public DescriptionSegment(String type, short exportVersion, short importVersion) {
            this.type = type;
            this.exportVersion = exportVersion;
            this.importVersion = importVersion;
        }

        public static DescriptionSegment parse(byte[] data) {
            if (data.length != 14) {
                throw new IllegalArgumentException("Expected segment length of 14");
            }
            String name = new String(data, 0, 8, Charset.forName("US-ASCII"));
            if (!name.equals("SnapGene")) {
                throw new IllegalArgumentException("Expected 'SnapGene' in description segment");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, 8, 6);
            String type = bb.getShort() == 0 ? "unknown" : "DNA";
            short exportVersion = bb.getShort();
            short importVersion = bb.getShort();
            return new DescriptionSegment(type, exportVersion, importVersion);
        }
    }

    static class FeaturesSegment
    extends Segment {
        public final List<Feature> features;

        public FeaturesSegment(List<Feature> features) {
            this.features = features;
        }

        public static FeaturesSegment parse(byte[] data) {
            String s = new String(data, Charset.forName("UTF-8"));
            return FeaturesSegment.parse(SnapGene.createDocument(s));
        }

        public static FeaturesSegment parse(Document doc) {
            Element docEl = doc.getDocumentElement();
            if (!"Features".equals(docEl.getTagName())) {
                throw new IllegalArgumentException("Expected 'Features' element");
            }
            ArrayList<Feature> features = new ArrayList<Feature>(100);
            for (Element featureEl : SnapGene.getElementsByTagName(docEl, "Feature")) {
                features.add(Feature.parse(featureEl));
            }
            return new FeaturesSegment(features);
        }
    }

    static class UnsupportedSegment
    extends Segment {
        public int type;
        public byte[] data;

        UnsupportedSegment() {
        }

        public static UnsupportedSegment parse(int type, byte[] data) {
            UnsupportedSegment seg = new UnsupportedSegment();
            seg.type = type;
            seg.data = data;
            return seg;
        }
    }

    static class Feature {
        public final String name;
        public final String type;
        public final Directionality directionality;
        public final String geneticCode;
        public final Boolean translateFirstCodonAsMet;
        public final Boolean allowSegmentOverlaps;
        public final Boolean consecutiveTranslationNumbering;
        public final Boolean swappedSegmentNumbering;
        public final Boolean hitsStopCodon;
        public final Double translationMW;
        public final List<Integer> cleavageArrows;
        public final Integer readingFrame;
        public final Boolean visible;
        public final List<Seg> segments;
        public final List<Map.Entry<String, ?>> qualifiers;
        private static final Set<String> parsedAttrs = new HashSet<String>(Arrays.asList("name", "type", "directionality", "geneticCode", "translateFirstCodonAsMet", "allowSegmentOverlaps", "consecutiveTranslationNumbering", "swappedSegmentNumbering", "hitsStopCodon", "translationMW", "cleavageArrows", "readingFrame", "visible"));
        private static final Set<String> ignoredAttrs = new HashSet<String>(Arrays.asList("recentID", "prioritize", "maxRunOn", "maxFusedRunOn", "consecutiveNumberingStartsFrom", "detectionMode"));
        private static final Set<String> knownAttrs = new HashSet<String>();

        public Feature(String name, Directionality directionality, String geneticCode, Boolean translateFirstCodonAsMet, Boolean allowSegmentOverlaps, Boolean consecutiveTranslationNumbering, Boolean swappedSegmentNumbering, Boolean hitsStopCodon, Double translationMW, String type, List<Integer> cleavageArrows, Integer readingFrame, Boolean visible, List<Seg> segments, List<Map.Entry<String, ?>> qualifiers) {
            this.name = name;
            this.directionality = directionality;
            this.geneticCode = geneticCode;
            this.translateFirstCodonAsMet = translateFirstCodonAsMet;
            this.allowSegmentOverlaps = allowSegmentOverlaps;
            this.consecutiveTranslationNumbering = consecutiveTranslationNumbering;
            this.swappedSegmentNumbering = swappedSegmentNumbering;
            this.hitsStopCodon = hitsStopCodon;
            this.translationMW = translationMW;
            this.type = type;
            this.cleavageArrows = cleavageArrows;
            this.readingFrame = readingFrame;
            this.visible = visible;
            this.segments = segments;
            this.qualifiers = qualifiers;
        }

        public static Feature parse(Element featureEl) {
            String name = SnapGene.getAttribute(featureEl, "name", new String[0]);
            String type = SnapGene.getAttribute(featureEl, "type", new String[0]);
            Directionality directionality = Directionality.fromInt(SnapGene.parseInt(SnapGene.getAttribute(featureEl, "directionality", new String[0])));
            String geneticCode = SnapGene.getAttribute(featureEl, "geneticCode", new String[0]);
            Boolean translateFirstCodonAsMet = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "translateFirstCodonAsMet", new String[0]));
            Boolean allowSegmentOverlaps = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "allowSegmentOverlaps", new String[0]));
            Boolean consecutiveTranslationNumbering = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "consecutiveTranslationNumbering", new String[0]));
            Boolean swappedSegmentNumbering = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "swappedSegmentNumbering", new String[0]));
            Boolean hitsStopCodon = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "hitsStopCodon", new String[0]));
            Double translationMW = SnapGene.parseDouble(SnapGene.getAttribute(featureEl, "translationMW", new String[0]));
            String cleavageArrowsStr = SnapGene.getAttribute(featureEl, "cleavageArrows", new String[0]);
            List<Integer> cleavageArrows = Collections.emptyList();
            if (cleavageArrowsStr != null) {
                cleavageArrows = Arrays.stream(cleavageArrowsStr.split(",")).map(x$0 -> SnapGene.parseInt(x$0)).collect(Collectors.toList());
            }
            Integer readingFrame = SnapGene.parseInt(SnapGene.getAttribute(featureEl, "readingFrame", new String[0]));
            Boolean visible = SnapGene.parseBool(SnapGene.getAttribute(featureEl, "visible", new String[0]));
            Set<String> unsupportedAttribute = SnapGene.getOtherAttributeNames(featureEl, knownAttrs);
            if (!unsupportedAttribute.isEmpty()) {
                throw new IllegalArgumentException("Unsupported attributes: " + unsupportedAttribute.stream().collect(Collectors.joining(", ")) + "\n" + SnapGene.toXMLString(featureEl));
            }
            ArrayList<Seg> segments = new ArrayList<Seg>(4);
            for (Element segmentEl : SnapGene.getElementsByTagName(featureEl, "Segment")) {
                segments.add(Seg.parse(segmentEl));
            }
            ArrayList qualifiers = new ArrayList(10);
            for (Element qualifierEl : SnapGene.getElementsByTagName(featureEl, "Q")) {
                Object value;
                String key = SnapGene.getAttribute(qualifierEl, "name", new String[0]);
                Element vEl = SnapGene.getElementByTagName(qualifierEl, "V");
                if (vEl == null) {
                    throw new IllegalArgumentException("Expected value element");
                }
                if (!vEl.hasAttributes()) {
                    value = null;
                } else if (vEl.hasAttribute("int")) {
                    value = SnapGene.parseInt(SnapGene.getAttribute(vEl, "int", new String[0]));
                } else if (vEl.hasAttribute("bool")) {
                    value = SnapGene.parseBool(SnapGene.getAttribute(vEl, "bool", new String[0]));
                } else if (vEl.hasAttribute("text")) {
                    value = SnapGene.getAttribute(vEl, "text", new String[0]);
                } else if (vEl.hasAttribute("predef")) {
                    value = SnapGene.getAttribute(vEl, "predef", new String[0]);
                } else {
                    throw new IllegalArgumentException("Unsupported value type for '" + key + "':" + SnapGene.toXMLString(vEl));
                }
                qualifiers.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            }
            return new Feature(name, directionality, geneticCode, translateFirstCodonAsMet, allowSegmentOverlaps, consecutiveTranslationNumbering, swappedSegmentNumbering, hitsStopCodon, translationMW, type, cleavageArrows, readingFrame, visible, segments, qualifiers);
        }

        static {
            knownAttrs.addAll(parsedAttrs);
            knownAttrs.addAll(ignoredAttrs);
        }
    }

    static class Seg {
        public final String name;
        public final String range;
        public final Integer start;
        public final Integer end;
        public final String color;
        public final String type;
        public final Boolean translated;
        public final Integer translationNumberingStartsFrom;
        private static Set<String> knownAttrs = new HashSet<String>(Arrays.asList("name", "range", "color", "type", "translated", "translationNumberingStartsFrom"));

        public Seg(String name, String range, Integer start, Integer end, String color, String type, Boolean translated, Integer translationNumberingStartsFrom) {
            this.name = name;
            this.range = range;
            this.start = start;
            this.end = end;
            this.color = color;
            this.type = type;
            this.translated = translated;
            this.translationNumberingStartsFrom = translationNumberingStartsFrom;
        }

        public static Seg parse(Element segmentEl) {
            String[] parts;
            String name = SnapGene.getAttribute(segmentEl, "name", new String[0]);
            Integer start = null;
            Integer end = null;
            String range = SnapGene.getAttribute(segmentEl, "range", new String[0]);
            if (range != null && (parts = range.split("-", 2)).length == 2) {
                start = SnapGene.parseInt(parts[0]);
                end = SnapGene.parseInt(parts[1]);
            }
            String color = SnapGene.getAttribute(segmentEl, "color", new String[0]);
            String type = SnapGene.getAttribute(segmentEl, "type", new String[0]);
            Boolean translated = SnapGene.parseBool(SnapGene.getAttribute(segmentEl, "translated", new String[0]));
            Integer translationNumberingStartsFrom = SnapGene.parseInt(SnapGene.getAttribute(segmentEl, "translationNumberingStartsFrom", new String[0]));
            Set<String> unsupportedAttribute = SnapGene.getOtherAttributeNames(segmentEl, knownAttrs);
            if (!unsupportedAttribute.isEmpty()) {
                throw new IllegalArgumentException("Unsupported attributes: " + unsupportedAttribute.stream().collect(Collectors.joining(", ")) + "\n" + SnapGene.toXMLString(segmentEl));
            }
            return new Seg(name, range, start, end, color, type, translated, translationNumberingStartsFrom);
        }
    }

    static enum Directionality {
        NonDirectional,
        Forward,
        ReverseDirectional,
        BiDirectional;


        public static Directionality fromInt(Integer ordinal) {
            if (ordinal == null) {
                return null;
            }
            switch (ordinal) {
                case 0: {
                    return NonDirectional;
                }
                case 1: {
                    return Forward;
                }
                case 2: {
                    return ReverseDirectional;
                }
                case 3: {
                    return BiDirectional;
                }
            }
            throw new IllegalArgumentException("Directionality ordinal out of range: " + ordinal);
        }
    }

    static class Reference {
        public final String title;
        public final String pubMedID;
        public final String journal;
        public final String authors;

        public Reference(String title, String pubMedID, String journal, String authors) {
            this.title = title;
            this.pubMedID = pubMedID;
            this.journal = journal;
            this.authors = authors;
        }
    }

    static abstract class Segment {
        Segment() {
        }
    }
}

