/*
 * Decompiled with CFR 0.152.
 */
package Sequences;

import java.io.Serializable;
import java.util.Arrays;

public abstract class Sequence
implements Serializable {
    protected String name;
    protected String sequence = "";
    protected boolean locked = false;
    protected boolean circular = false;

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) {
        this.circular = circular;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static String replace(String SrcSeq, int RepStart, int RepStop, String NewSeq) {
        String pre = Sequence.getSequence(SrcSeq, 1, RepStart - 1);
        String post = Sequence.getSequence(SrcSeq, RepStop + 1, SrcSeq.length());
        return (pre != null ? pre : "") + NewSeq + (post != null ? post : "");
    }

    public static String getSequence(String SrcString, int Start2, int Stop) {
        if (Start2 < 1 || Stop > SrcString.length() || Stop < 1 || Start2 > SrcString.length()) {
            return null;
        }
        if (Start2 <= Stop) {
            return SrcString.substring(Start2 - 1, Stop);
        }
        return SrcString.substring(Start2 - 1) + SrcString.substring(0, Stop);
    }

    public static String compareSequences(String reference, String query) {
        return Sequence.compareSequences(reference, query, false, CompareDirection.LEFT_TO_RIGHT);
    }

    public static String compareSequences(String reference, String query, boolean caseSensitive) {
        return Sequence.compareSequences(reference, query, caseSensitive, CompareDirection.LEFT_TO_RIGHT);
    }

    public static String compareSequences(String reference, String query, CompareDirection direction) {
        return Sequence.compareSequences(reference, query, false, CompareDirection.LEFT_TO_RIGHT);
    }

    public static String compareSequences(String reference, String query, boolean caseSensitive, CompareDirection direction) {
        char[] qry;
        char[] ref;
        if (reference == null || reference.length() == 0 || query == null || query.length() == 0) {
            return "";
        }
        if (caseSensitive) {
            ref = reference.toCharArray();
            qry = query.toCharArray();
        } else {
            ref = reference.toUpperCase().toCharArray();
            qry = query.toUpperCase().toCharArray();
        }
        int maxLen = Math.min(reference.length(), query.length());
        char[] out = new char[maxLen];
        if (direction.equals((Object)CompareDirection.LEFT_TO_RIGHT)) {
            for (int x = 0; x < maxLen; ++x) {
                out[x] = qry[x] == ref[x] ? 46 : qry[x];
            }
        } else {
            if (ref.length > qry.length) {
                for (int x = 0; x < ref.length - qry.length; ++x) {
                    out[x] = 32;
                }
            }
            int qIndex = qry.length - maxLen;
            int rIndex = ref.length - maxLen;
            for (int x = 0; x < maxLen; ++x) {
                out[x] = qry[qIndex] == ref[rIndex] ? 46 : qry[qIndex];
                ++rIndex;
                ++qIndex;
            }
        }
        return String.valueOf(out);
    }

    private static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public Sequence() {
    }

    public Sequence(String sequence) {
        this.sequence = this.filterSeq(sequence);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public int length() {
        return this.sequence.length();
    }

    public void toUppercase() {
        this.sequence = this.sequence.toUpperCase();
    }

    public void toUppercase(int start, int end) {
        if (this.sequence.isEmpty()) {
            return;
        }
        this.sequence = Sequence.changeCase(this.sequence, start, end, 97, 122, -32);
    }

    public void toLowercase() {
        this.sequence = this.sequence.toLowerCase();
    }

    public void toLowercase(int start, int end) {
        if (this.sequence.isEmpty()) {
            return;
        }
        this.sequence = Sequence.changeCase(this.sequence, start, end, 65, 90, 32);
    }

    private static String changeCase(String seq, int start, int end, int lowestChar, int highestChar, int modNum) {
        char[] strChars = seq.toCharArray();
        if (start > end) {
            int x;
            for (x = start - 1; x < strChars.length; ++x) {
                if (strChars[x] < lowestChar || strChars[x] > highestChar) continue;
                int n = x;
                strChars[n] = (char)(strChars[n] + modNum);
            }
            for (x = 0; x < end; ++x) {
                if (strChars[x] < lowestChar || strChars[x] > highestChar) continue;
                int n = x;
                strChars[n] = (char)(strChars[n] + modNum);
            }
        } else {
            for (int x = start - 1; x < end; ++x) {
                if (strChars[x] < lowestChar || strChars[x] > highestChar) continue;
                int n = x;
                strChars[n] = (char)(strChars[n] + modNum);
            }
        }
        return new String(strChars);
    }

    public void append(String seq) {
        String fSeq = this.filterSeq(seq);
        if (fSeq.length() > 0) {
            this.sequence = this.sequence + fSeq;
            this.resetStoredVariables();
        }
    }

    public abstract String filterSeq(String var1);

    public abstract void resetStoredVariables();

    public void setSequence(String sequence) {
        this.sequence = this.filterSeq(sequence);
        this.resetStoredVariables();
    }

    public void setSequence(Sequence sequence) {
        this.setSequence(sequence.sequence);
        this.resetStoredVariables();
    }

    public void setSequence(Sequence sequence, int Start2, int Stop) {
        this.resetStoredVariables();
        this.sequence = sequence.getSequence(Start2, Stop);
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getSequence(int start, int stop) {
        return Sequence.getSequence(this.sequence, start, stop);
    }

    public void replace(int start, int stop, String newSeq) {
        this.sequence = Sequence.replace(this.sequence, start, stop, this.filterSeq(newSeq));
        this.resetStoredVariables();
    }

    public void replace(int start, int stop, char newSeq) {
        this.sequence = Sequence.replace(this.sequence, start, stop, this.filterSeq(String.valueOf(newSeq)));
        this.resetStoredVariables();
    }

    public void insertAt(int position, String seq) {
        this.insertFilteredAt(position, this.filterSeq(seq));
    }

    public void insertAt(int position, Sequence seq) {
        this.insertFilteredAt(position, seq.sequence);
    }

    private void insertFilteredAt(int position, String filteredSeq) {
        if (filteredSeq.length() > 0) {
            this.sequence = this.length() == 0 ? filteredSeq : (position == 0 ? filteredSeq + this.sequence : (position == this.length() ? this.sequence + filteredSeq : this.getSequence(1, position) + filteredSeq + this.getSequence(position + 1, this.sequence.length())));
            this.resetStoredVariables();
        }
    }

    public void delSeq(int start, int stop) {
        this.sequence = start <= stop ? this.getSequence(1, start - 1) + this.getSequence(stop + 1, this.sequence.length()) : this.getSequence(stop + 1, start - 1);
        this.resetStoredVariables();
    }

    public static enum CompareDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

