/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import GenbankFileReader.Annotation;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;
import java.awt.Color;
import java.util.Random;

public class ROI
extends Annotation {
    private static final long serialVersionUID = 1L;
    static final int iconAlpha = 100;
    protected Color color = null;
    Color colorTrans = null;
    private static final int BASEQUALNUM = 1;
    private static final int LABEL_NAME = 4;
    private static final int GENE_NAME = 3;
    private static final int ORGANISM_NAME = 2;
    private static final int PRODUCT_NAME = 1;

    public ROI(String name, int start, int end, Color color, Object obj) {
        this.setName(name);
        this.setColor(color);
        this.set(start, end, false);
    }

    public ROI() {
        this.setName("New Feature");
        this.setColor(Color.cyan);
        this.set(1, 1, false);
    }

    public ROI(String name, int start, int end, Color color) {
        this.setName(name);
        this.setColor(color);
        this.set(start, end, false);
    }

    public ROI(String name, int start, boolean antisense, int end, Color color) {
        this.setName(name);
        this.setColor(color);
        this.set(start, end, false);
    }

    public ROI(String name, int start, int end, boolean antisense, Color color, Object obj) {
        this.setName(name);
        this.setColor(color);
        this.set(start, end, antisense);
    }

    public ROI(String name, int start, int end, boolean antisense, Color color) {
        this.setName(name);
        this.set(start, end, antisense);
        this.setColor(color);
    }

    public Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.colorTrans = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
        } else {
            this.color = null;
            this.colorTrans = null;
        }
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    boolean hasSequence() {
        return this.start > -1 && this.stop > -1;
    }

    public void cloneFrom(ROI roi) {
        this.name = roi.name;
        this.gbType = roi.gbType;
        this.color = roi.color;
        this.colorTrans = roi.colorTrans;
        this.start = roi.start;
        this.stop = roi.stop;
        this.antisense = roi.antisense;
        if (roi.qualifiers != null && roi.qualifiers.length > 0) {
            this.qualifiers = new Qualifier[roi.qualifiers.length];
            for (int x = 0; x < roi.qualifiers.length; ++x) {
                this.qualifiers[x] = roi.qualifiers[x].clone();
            }
        }
    }

    @Override
    public ROI clone() {
        ROI outROI = new ROI();
        outROI.cloneFrom(this);
        return outROI;
    }

    @Override
    public String toString() {
        return super.toString() + " name=" + this.name + ", locus=" + super.toString();
    }

    @Override
    public String toGBString() {
        return super.toGBString() + "\n" + "                     " + "/label=" + this.name + "\n" + "                     " + "/color=" + ROI.colorToInt(this.color);
    }

    public static Annotation toAnnotation(ROI roi) {
        Annotation newAnnotation = new Annotation();
        int qnum = roi.qualifiers != null && roi.qualifiers.length > 0 ? 1 + roi.qualifiers.length + 1 : 2;
        newAnnotation.setName(roi.getName());
        newAnnotation.set(roi);
        newAnnotation.setGBType(roi.getGBType());
        newAnnotation.qualifiers = new Qualifier[qnum];
        newAnnotation.qualifiers[0] = new Qualifier("plot_color", "" + ROI.colorToInt(roi.color));
        if (roi.qualifiers != null && roi.qualifiers.length > 0) {
            for (int y = 0; y < roi.qualifiers.length; ++y) {
                newAnnotation.qualifiers[1 + y] = roi.qualifiers[y].clone();
            }
        }
        return newAnnotation;
    }

    public static Color intToColor(String col) {
        try {
            int val = Integer.parseInt(col);
            return ROI.intToColor(val, 255);
        }
        catch (NumberFormatException ex) {
            return Color.black;
        }
    }

    public static Color intToColor(int col) {
        return ROI.intToColor(col, 255);
    }

    public static Color intToColor(int col, int Alpha) {
        int R = col & 0xFF;
        int G = (col & 0xFF00) / 256;
        int B = (col & 0xFF0000) / 65536;
        return new Color(R, G, B, Alpha);
    }

    static int colorToInt(Color color) {
        return color.getRed() + color.getGreen() * 256 + color.getBlue() * 65536;
    }

    public static ROI fromAnnotation(Annotation annotation) {
        ROI roi = new ROI();
        roi.set(annotation);
        String name = roi.gbType = annotation.getGBType();
        int nameSrc = 0;
        Color color = null;
        if (annotation.hasQualifiers()) {
            ExtensibleArray<Qualifier> qualifiers = new ExtensibleArray<Qualifier>(Qualifier.class);
            for (Qualifier qual : annotation.qualifiers) {
                if (qual != null) {
                    switch (qual.key.toLowerCase()) {
                        case "label": {
                            if (name.length() != 0 && nameSrc >= 4) break;
                            name = qual.value;
                            nameSrc = 4;
                            break;
                        }
                        case "gene": {
                            if (name.length() != 0 && nameSrc >= 3) break;
                            name = qual.value;
                            nameSrc = 3;
                            break;
                        }
                        case "organism": {
                            if (name.length() != 0 && nameSrc >= 2) break;
                            name = qual.value;
                            nameSrc = 2;
                            break;
                        }
                        case "product": {
                            if (name.length() != 0 && nameSrc >= 1) break;
                            name = qual.value;
                            nameSrc = 1;
                            break;
                        }
                        case "color": 
                        case "backcolor": 
                        case "plot_color": {
                            color = ROI.intToColor(qual.value);
                            break;
                        }
                        default: {
                            qualifiers.add(qual);
                        }
                    }
                }
                if (color != null) continue;
                Random rand = new Random();
                color = new Color(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
            }
            if (!qualifiers.isEmpty()) {
                roi.qualifiers = qualifiers.toArray();
            }
        }
        roi.name = name;
        roi.setColor(color);
        return roi;
    }
}

