/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import GenbankFileReader.Annotation;
import SequenceEditorPanels.AnnotationEditor;
import SequenceEditorPanels.ROI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FrmROIEditor
extends JDialog
implements AnnotationEditor {
    int sequenceLength = 1;
    int start = 1;
    int stop = 1;
    ROI roi = null;
    private JComboBox<String> cmbGBType;
    private JComboBox<String> cmbOrientation;
    private JButton cmdCancel;
    private JButton cmdColor;
    private JButton cmdSave;
    private ButtonGroup grpOrientation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    public JTextField txtEnd;
    private JTextField txtName;
    public JTextField txtStart;

    FrmROIEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        FrmROIEditor.populateGenbankTypes(this.cmbGBType);
        this.txtStart.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                FrmROIEditor.this.start = FrmROIEditor.FilterStringToInt(FrmROIEditor.this.txtStart.getText(), 1, FrmROIEditor.this.sequenceLength, 1);
                FrmROIEditor.this.txtStart.setText("" + FrmROIEditor.this.start);
                FrmROIEditor.this.stop = FrmROIEditor.FilterStringToInt(FrmROIEditor.this.txtEnd.getText(), 1, FrmROIEditor.this.sequenceLength, 1);
            }
        });
        this.txtEnd.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                FrmROIEditor.this.stop = FrmROIEditor.FilterStringToInt(FrmROIEditor.this.txtEnd.getText(), 1, FrmROIEditor.this.sequenceLength, 1);
                FrmROIEditor.this.txtEnd.setText("" + FrmROIEditor.this.stop);
            }
        });
        String cancelName = "cancel";
        String enterName = "enter";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), enterName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    return;
                }
                FrmROIEditor.this.setVisible(false);
            }
        });
        actionMap.put(enterName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    return;
                }
                FrmROIEditor.this.save();
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public static void populateGenbankTypes(JComboBox cmb) {
        cmb.removeAllItems();
        for (String type : Annotation.GBTYPES) {
            cmb.addItem(type);
        }
    }

    private void save() {
        String name = this.txtName.getText().length() > 0 ? this.txtName.getText() : "New Feature";
        boolean antisense = this.cmbOrientation.getSelectedIndex() == 1;
        this.roi = new ROI(name, this.start, this.stop, antisense, this.cmdColor.getBackground(), null);
        this.setVisible(false);
    }

    private void initComponents() {
        this.grpOrientation = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.txtName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtStart = new JTextField();
        this.txtEnd = new JTextField();
        this.cmdSave = new JButton();
        this.cmdCancel = new JButton();
        this.jLabel4 = new JLabel();
        this.cmdColor = new JButton(){

            @Override
            public void paint(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setColor(Color.black);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        this.cmbGBType = new JComboBox();
        this.jLabel5 = new JLabel();
        this.cmbOrientation = new JComboBox();
        this.jLabel6 = new JLabel();
        this.setTitle("Add ROI");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jLabel1.setText("Name");
        this.txtName.setText("New Feature");
        this.txtName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmROIEditor.this.txtNameFocusGained(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Start");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Stop");
        this.txtStart.setHorizontalAlignment(0);
        this.txtStart.setText("1");
        this.txtStart.setMaximumSize(new Dimension(64, 22));
        this.txtStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmROIEditor.this.txtStartFocusGained(evt);
            }
        });
        this.txtEnd.setHorizontalAlignment(0);
        this.txtEnd.setText("1");
        this.txtEnd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmROIEditor.this.txtEndFocusGained(evt);
            }
        });
        this.cmdSave.setText("Save");
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmROIEditor.this.cmdSaveActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmROIEditor.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Color");
        this.cmdColor.setBackground(new Color(204, 204, 255));
        this.cmdColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmROIEditor.this.cmdColorActionPerformed(evt);
            }
        });
        this.cmbGBType.setEditable(true);
        this.cmbGBType.setFont(new Font("Segoe UI", 0, 14));
        this.cmbGBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmROIEditor.this.cmbGBTypeActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Genbank Type");
        this.cmbOrientation.setModel(new DefaultComboBoxModel<String>(new String[]{"Sense", "Antisense"}));
        this.jLabel6.setText("Orientation");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cmdSave).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtName, -1, 184, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel5, -2, 128, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.txtStart, -2, 64, -2))).addComponent(this.cmbGBType, 0, -1, Short.MAX_VALUE)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtEnd, -2, 64, -2).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.cmdColor, -2, 23, -2))).addComponent(this.cmbOrientation, -2, 93, -2).addComponent(this.jLabel6, -2, 93, -2)).addGap(46, 46, 46)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtName, -2, -1, -2).addComponent(this.txtStart, -2, -1, -2).addComponent(this.txtEnd, -2, -1, -2)).addComponent(this.cmdColor, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbGBType, -2, 24, -2).addComponent(this.cmbOrientation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdSave, GroupLayout.Alignment.TRAILING).addComponent(this.cmdCancel, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    private void cmdColorActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Select ROI Color", this.cmdColor.getBackground());
        if (newColor != null) {
            this.cmdColor.setBackground(newColor);
        }
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void txtStartFocusGained(FocusEvent evt) {
        this.txtStart.selectAll();
    }

    private void txtEndFocusGained(FocusEvent evt) {
        this.txtEnd.selectAll();
    }

    private void txtNameFocusGained(FocusEvent evt) {
        this.txtName.selectAll();
    }

    private void cmbGBTypeActionPerformed(ActionEvent evt) {
        String newItem = (String)this.cmbGBType.getEditor().getItem();
        if (this.roi != null) {
            this.roi.setGBType(newItem);
        }
    }

    public static int FilterStringToInt(String number, int minVal, int maxVal, int defaultErrNum) {
        String fString = number.replaceAll("[^-0123456789]", "");
        if (fString.length() == 0) {
            return defaultErrNum;
        }
        int outInt = Integer.valueOf(fString);
        return outInt >= minVal && outInt <= maxVal ? outInt : defaultErrNum;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmROIEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmROIEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmROIEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmROIEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmROIEditor dialog = new FrmROIEditor((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public void setROI(ROI roi) {
        if (roi != null) {
            this.start = roi.getStart();
            this.stop = roi.getStop();
            this.txtName.setText(roi.getName().length() > 0 ? roi.getName() : "New Feature");
            this.txtStart.setText("" + this.start);
            this.txtEnd.setText("" + this.stop);
            this.cmbOrientation.setSelectedIndex(roi.isAntisense() ? 1 : 0);
            this.cmdColor.setBackground(roi.color);
        } else {
            this.txtName.setText("New Feature");
            this.txtStart.setText("1");
            this.txtEnd.setText("1");
            this.cmbOrientation.setSelectedIndex(roi.isAntisense() ? 1 : 0);
            this.cmdColor.setBackground(Color.cyan);
        }
    }

    @Override
    public void setLength(int length) {
        this.sequenceLength = length;
    }
}

