/*
 * Decompiled with CFR 0.152.
 */
package SequenceBuilders;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class ObjectChain<T>
implements Iterable<T> {
    Node<T> iteratorNode = null;
    Node<T> lastIteratorRet = null;
    boolean circular = false;
    final Node<T> root = new Node();
    int count = 0;
    private Node<T> currentNode = null;

    public ObjectChain() {
        this.root.next = null;
        this.root.previous = null;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        Node item = this.root.next;
        this.root.previous.next = null;
        while (item != null) {
            item.object = null;
            if (item.previous != null) {
                item.previous.next = null;
            }
            item.previous = null;
            item = item.next;
        }
        this.root.next = null;
        this.root.previous = null;
        this.count = 0;
        this.currentNode = null;
    }

    public T get(int index) {
        Node<T> node = this.getNode(index);
        if (node == null) {
            return null;
        }
        return node.object;
    }

    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        this.currentNode = this.root.next;
        return this.root.next.object;
    }

    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        this.currentNode = this.root.previous;
        return this.root.previous.object;
    }

    public T getNext() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.currentNode != null) {
            if (this.currentNode.next == null || this.currentNode.next == this.root.next) {
                this.currentNode = null;
                return null;
            }
            this.currentNode = this.currentNode.next;
            return this.currentNode.object;
        }
        if (this.currentNode == null) {
            return this.getFirst();
        }
        return null;
    }

    public T getPrevious() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.currentNode != null) {
            if (this.currentNode.previous == null || this.currentNode.previous == this.root) {
                this.currentNode = null;
                return null;
            }
            this.currentNode = this.currentNode.previous;
            return this.currentNode.object;
        }
        if (this.currentNode == null) {
            return this.getLast();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.root.next == null || this.root.previous == null;
    }

    public boolean hasNext() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.currentNode == null) {
            this.currentNode = this.root.next;
        }
        return this.currentNode != null && this.currentNode.next != null && this.currentNode.next != this.root.next;
    }

    public boolean hasPrevious() {
        if (this.isEmpty()) {
            return false;
        }
        return this.currentNode != null && this.currentNode.previous != null && this.currentNode.next != this.root.previous;
    }

    public boolean contains(T obj) {
        return this.indexOf(obj) != -1;
    }

    public int indexOf(T obj) {
        if (this.isEmpty() || obj == null) {
            return -1;
        }
        if (this.root.previous.object == obj) {
            return this.count - 1;
        }
        Node item = this.root.next;
        int index = 0;
        while (item != null && item != this.root.previous) {
            if (item.object == obj) {
                return index;
            }
            item = item.next;
            ++index;
        }
        return -1;
    }

    public void addBefore(T newObject, T targetObject) {
        Node<T> dst = this.get(targetObject);
        if (dst == null) {
            return;
        }
        Node<T> newNode = new Node<T>(newObject);
        this.addBefore(newNode, dst);
    }

    public void addBefore(T newObject, int targetIndex) {
        Node<T> dst = this.getNode(targetIndex);
        if (dst == null) {
            return;
        }
        Node<T> newNode = new Node<T>(newObject);
        this.addBefore(newNode, dst);
    }

    public void addAfter(T newObject, T targetObject) {
        Node<T> dst = this.get(targetObject);
        if (dst == null) {
            return;
        }
        Node<T> newNode = new Node<T>(newObject);
        this.addAfter(newNode, dst);
    }

    public void addAfter(T newObject, int targetIndex) {
        Node<T> dst = this.getNode(targetIndex);
        if (dst == null) {
            return;
        }
        Node<T> newNode = new Node<T>(newObject);
        this.addAfter(newNode, dst);
    }

    Node<T> getNode(int index) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return null;
        }
        if (index == this.count - 1) {
            return this.root.previous;
        }
        if (index == this.count - 0) {
            return this.root.next;
        }
        Node item = this.root.next;
        int index2 = 0;
        while (item != null && item != this.root.previous) {
            if (index2 == index) {
                return item;
            }
            ++index2;
            item = item.next;
        }
        return null;
    }

    private Node<T> get(T obj) {
        if (this.isEmpty() || obj == null) {
            return null;
        }
        if (this.root.previous.object == obj) {
            return this.root.previous;
        }
        Node item = this.root.next;
        int index = 0;
        while (item != null && item != this.root.previous) {
            if (item.object == obj) {
                return item;
            }
            item = item.next;
            ++index;
        }
        return null;
    }

    public void add(T obj) {
        if (obj == null) {
            return;
        }
        Node<T> node = new Node<T>(obj);
        if (this.count == 0) {
            this.setFirstNode(node);
            return;
        }
        node.previous = this.root.previous;
        if (this.root.previous != null) {
            this.root.previous.next = node;
        }
        if (this.circular) {
            node.next = this.root.next;
            this.root.next.previous = node;
        } else {
            node.next = null;
        }
        this.root.previous = node;
        ++this.count;
    }

    public void append(ObjectChain<T> donor) {
        ObjectChain.merge(this, donor);
    }

    public void appendTo(ObjectChain<T> receiver) {
        ObjectChain.merge(receiver, this);
    }

    private static void link(Node n1, Node n2) {
        if (n1.next != null) {
            n1.next.previous = null;
        }
        if (n2.previous != null) {
            n2.previous.next = null;
        }
        n1.next = n2;
        n2.previous = n1;
    }

    public void degrade() {
        if (this.root.next == null) {
            return;
        }
        Node cNode = this.root.next;
        while (cNode != null) {
            if (cNode.previous != null) {
                cNode.previous.next = null;
                cNode.previous = null;
            }
            cNode = cNode.next;
        }
        this.root.next = null;
        this.root.previous = null;
    }

    private static void merge(ObjectChain receiver, ObjectChain donor) {
        if (donor.root.next != null) {
            if (receiver.root.next == null) {
                receiver.root.next = donor.root.next;
                receiver.root.previous = donor.root.previous;
            } else {
                donor.root.next.previous = receiver.root.previous;
                receiver.root.previous.next = donor.root.next;
                receiver.root.previous = donor.root.previous;
            }
            donor.root.next = null;
            donor.root.previous = null;
        }
    }

    public void setCircular(boolean circular) {
        if (this.circular == circular) {
            return;
        }
        this.circular = circular;
        if (this.count == 0) {
            return;
        }
        if (circular) {
            if (this.root.next != null) {
                this.root.next.previous = this.root.previous;
            }
            if (this.root.previous != null) {
                this.root.previous.next = this.root.next;
            }
        } else {
            if (this.root.next != null) {
                this.root.next.previous = null;
            }
            if (this.root.previous != null) {
                this.root.previous.next = null;
            }
        }
    }

    public void addToFront(T obj) {
        if (obj == null) {
            return;
        }
        Node<T> node = new Node<T>(obj);
        node.next = this.root.next;
        if (this.count == 0) {
            this.setFirstNode(node);
            return;
        }
        if (this.root.next != null) {
            this.root.next.previous = node;
        }
        this.root.next = node;
        if (this.count == 0) {
            this.root.previous = node;
        }
        if (this.circular) {
            node.previous = this.root.previous;
            this.root.previous.next = node;
        }
        ++this.count;
    }

    public void sort(Comparator c) {
        int x;
        if (this.count < 2) {
            return;
        }
        Node[] nodes = new Node[this.count];
        Node<T> node = this.root;
        for (x = 0; x < this.count; ++x) {
            nodes[x] = node.next;
            node = node.next;
        }
        for (x = 0; x < this.count - 1; ++x) {
            Node node2;
            int highIndex = x;
            for (int y = x + 1; y < this.count; ++y) {
                if (c.compare(nodes[highIndex].object, nodes[y].object) <= 0) continue;
                highIndex = y;
            }
            if (highIndex == x) continue;
            Node node1 = nodes[x];
            nodes[x] = node2 = nodes[highIndex];
            nodes[highIndex] = node1;
        }
        this.root.next = nodes[0];
        this.root.previous = nodes[this.count - 1];
        if (this.circular) {
            nodes[0].previous = nodes[this.count - 1];
            nodes[this.count - 1].next = nodes[0];
        } else {
            nodes[0].previous = null;
            nodes[this.count - 1].next = null;
        }
        for (x = 0; x < this.count - 1; ++x) {
            nodes[x].next = nodes[x + 1];
            nodes[x + 1].previous = nodes[x];
        }
        nodes[this.count - 1].previous = nodes[this.count - 2];
        this.currentNode = null;
    }

    private void addBefore(Node node, Node dstNode) {
        if (node == null || dstNode == null) {
            return;
        }
        node.previous = dstNode.previous;
        node.next = dstNode;
        if (dstNode.previous != null) {
            dstNode.previous.next = node;
        }
        dstNode.previous = node;
    }

    private void addAfter(Node node, Node dstNode) {
        if (node == null || dstNode == null) {
            return;
        }
        node.previous = dstNode;
        node.next = dstNode.next;
        if (dstNode.next != null) {
            dstNode.next.previous = node;
        }
        dstNode.next = node;
    }

    private void setFirstNode(Node node) {
        this.root.next = node;
        this.root.previous = node;
        if (this.circular) {
            node.next = node;
            node.previous = node;
        }
        this.count = 1;
    }

    private void removeNode(Node<T> node) {
        if (this.isEmpty() || node == null) {
            return;
        }
        this.cut(node);
    }

    public void remove(T obj) {
        if (this.isEmpty() || obj == null) {
            return;
        }
        if (this.root.previous.object == obj) {
            this.cut(this.root.previous);
            return;
        }
        Node item = this.root.next;
        while (item != null && item != this.root.previous) {
            if (item.object == obj) {
                this.cut(item);
                return;
            }
            item = item.next;
        }
    }

    private Node<T> cut(Node node) {
        if (this.iteratorNode != null && node == this.iteratorNode) {
            if (this.iteratorNode == this.root.next) {
                this.iteratorNode = this.root;
                this.lastIteratorRet = null;
            } else {
                this.iteratorNode = this.lastIteratorRet;
                this.lastIteratorRet = this.iteratorNode.previous;
            }
        }
        if (node.next == node) {
            this.root.next = null;
            this.root.previous = null;
        } else {
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            if (this.root.previous == node) {
                this.root.previous = node.previous;
            }
            if (this.root.next == node) {
                this.root.next = node.next;
            }
        }
        node.next = null;
        node.previous = null;
        if (node == this.currentNode) {
            this.currentNode = null;
        }
        --this.count;
        return node;
    }

    public T popLast() {
        if (this.root.previous == null) {
            return null;
        }
        Node<T> item = this.cut(this.root.previous);
        Object obj = item.object;
        item.object = null;
        return obj;
    }

    public T popFirst() {
        if (this.root.next == null) {
            return null;
        }
        Node<T> item = this.cut(this.root.next);
        Object obj = item.object;
        item.object = null;
        return obj;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    static class Node<T> {
        public Node<T> previous;
        public Node<T> next;
        public T object;

        public Node() {
        }

        public Node(T obj) {
            this.object = obj;
        }
    }

    private class Itr
    implements Iterator<T> {
        public Itr() {
            ObjectChain.this.iteratorNode = ObjectChain.this.root;
        }

        @Override
        public boolean hasNext() {
            return ObjectChain.this.iteratorNode != null && ObjectChain.this.iteratorNode.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                return null;
            }
            ObjectChain.this.lastIteratorRet = ObjectChain.this.iteratorNode;
            ObjectChain.this.iteratorNode = ObjectChain.this.iteratorNode.next;
            return ObjectChain.this.iteratorNode.object;
        }

        @Override
        public void remove() {
            if (ObjectChain.this.iteratorNode != null && ObjectChain.this.iteratorNode != ObjectChain.this.root) {
                Node next = ObjectChain.this.iteratorNode.next;
                ObjectChain.this.removeNode(ObjectChain.this.iteratorNode);
                ObjectChain.this.iteratorNode = next;
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Node cursor = ObjectChain.this.iteratorNode;
            Objects.requireNonNull(action);
            if (cursor != null) {
                ObjectChain.this.lastIteratorRet = cursor;
                while (cursor.next != null) {
                    cursor = cursor.next;
                    action.accept(cursor.object);
                }
            }
            ObjectChain.this.iteratorNode = null;
            ObjectChain.this.lastIteratorRet = null;
        }
    }
}

