/*
 * Decompiled with CFR 0.152.
 */
package SequenceBuilders;

import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import SequenceBuilders.Nt;
import SequenceBuilders.ObjectChain;
import SequenceBuilders.ProteinBuilder;

public class DNABuilder
extends ObjectChain<Nt> {
    CodonTable codonTable = new CodonTable();

    public DNABuilder() {
    }

    public DNABuilder(String sequence) {
        this(sequence.toCharArray(), false);
    }

    public DNABuilder(String sequence, boolean circular) {
        this(sequence.toCharArray(), circular);
    }

    public DNABuilder(char[] sequence) {
        this(sequence, false);
    }

    public DNABuilder(char[] sequence, boolean circular) {
        this.circular = circular;
        if (sequence == null || sequence.length == 0) {
            return;
        }
        for (int x = 0; x < sequence.length; ++x) {
            this.add(new Nt(sequence[x]));
        }
    }

    public ProteinBuilder translationToFirstStop() {
        return this.translateToFirstStop(this.root.next);
    }

    public ProteinBuilder translationToFirstStop(int startBase) {
        ObjectChain.Node<Nt> node = this.getNode(startBase);
        if (node == null) {
            return null;
        }
        return this.translateToFirstStop(node);
    }

    private ProteinBuilder translateToFirstStop(ObjectChain.Node<Nt> node) {
        ObjectChain.Node<Nt> startNode = node;
        if (!DNABuilder.validToTranslate(node)) {
            return null;
        }
        ProteinBuilder builder = new ProteinBuilder();
        while (DNABuilder.validToTranslate(node)) {
            AminoAcid aa = this.codonTable.translateCodon(((Nt)node.object).character, ((Nt)node.next.object).character, ((Nt)node.next.next.object).character);
            if (aa == null) {
                return null;
            }
            if (aa.getAbbr1() == '*') {
                builder.add(aa);
                return builder;
            }
            node = node.next.next.next;
            if (startNode != node) continue;
            return builder;
        }
        return null;
    }

    public String toString() {
        char[] chars = new char[this.count];
        ObjectChain.Node node = this.root.next;
        for (int x = 0; x < this.count; ++x) {
            chars[x] = ((Nt)node.next.object).character;
            node = node.next;
        }
        return new String(chars);
    }

    private static boolean validToTranslate(ObjectChain.Node<Nt> node) {
        return node != null && ((Nt)node.object).character > '\u0000' && node.next != null && ((Nt)node.next.object).character > '\u0000' && node.next.next != null && ((Nt)node.next.next.object).character > '\u0000';
    }
}

