/*
 * Decompiled with CFR 0.152.
 */
package ScrollPanels;

import BaseClasses.JMRenderedComponent;
import JMConstants.Constants;
import Renderers.GelRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.BeanProperty;
import java.beans.Transient;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class StatusLabel
extends JMRenderedComponent
implements SwingConstants,
Constants {
    static Renderer defaultRenderer = new GelRenderer();
    private Renderer renderer = null;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    protected int displayTime = 0;
    Timer labelTimer = null;
    private int insetLeft = 0;
    private int insetTop = 0;
    private int insetBottom = 0;
    private int insetRight = 0;
    String text = "";
    Icon defaultIcon;
    Icon disabledIcon;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 10;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int iconTextGap = 4;
    private boolean disabledIconSet = false;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    @Override
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.updateRenderer();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    public StatusLabel() {
        Color foreColor;
        this.setPreferredSize(new Dimension(50, 20));
        Color backColor = UIManager.getColor("StatusLabel.background");
        if (backColor == null) {
            backColor = UIManager.getColor("Label.background");
        }
        if ((foreColor = UIManager.getColor("StatusLabel.foreground")) == null) {
            foreColor = UIManager.getColor("Label.foreground");
        }
        if (backColor != null) {
            this.setBackground(backColor);
        }
        if (foreColor != null) {
            this.setForeground(foreColor);
        }
        this.displayTime = 0;
    }

    public StatusLabel(int displayTime) {
        this();
        this.displayTime = displayTime;
    }

    public StatusLabel(String text, int displayTime) {
        this();
        this.displayTime = displayTime;
    }

    @BeanProperty(preferred=true, description="Sets the label text. If a default display time > 0 is set, text will be blanked after the timer expires.")
    public void setText(String text) {
        this.setText(text, this.displayTime);
    }

    public void setText(String text, int milliSeconds) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        if (this.labelTimer != null) {
            this.labelTimer.stop();
            this.labelTimer = null;
        }
        if (milliSeconds > 0 && text.length() > 0) {
            this.labelTimer = new Timer(milliSeconds, arg0 -> this.setText(""));
            this.labelTimer.start();
        }
        this.repaint();
    }

    public void setInsetBottom(int insetBottom) {
        this.insetBottom = insetBottom;
        this.repaint();
    }

    public void setInsetLeft(int insetLeft) {
        this.insetLeft = insetLeft;
        this.repaint();
    }

    public void setInsetRight(int insetRight) {
        this.insetRight = insetRight;
        this.repaint();
    }

    public void setInsetTop(int insetTop) {
        this.insetTop = insetTop;
        this.repaint();
    }

    public int getInsetTop() {
        return this.insetTop;
    }

    public int getInsetBottom() {
        return this.insetBottom;
    }

    public int getInsetLeft() {
        return this.insetLeft;
    }

    public int getInsetRight() {
        return this.insetRight;
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected void updateRenderer() {
        if (this.renderer != null) {
            super.updateRenderer();
            this.repaint();
        }
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColors(Color colorNormal, Color colorRollOver, Color colorPressed, Color colorBorder) {
        super.setColors(colorNormal, colorRollOver, colorPressed, colorBorder);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setColors(Color color) {
        super.setColors(color);
    }

    @Override
    @BeanProperty(hidden=true)
    public void setTextColors(Color colorNormal, Color colorRollOver, Color colorPressed) {
        super.setTextColors(colorNormal, colorRollOver, colorPressed);
    }

    @Override
    public void paint(Graphics g) {
        Icon icon;
        boolean opaque = this.isOpaque();
        boolean enabled = this.isEnabled();
        Renderer renderer = this.getActiveRenderer();
        if (opaque && renderer != null) {
            renderer.paintBackground(g, this, null, enabled ? 0 : 2);
        } else {
            super.paint(g);
        }
        boolean haveText = this.text != null && this.text.length() > 0;
        Icon icon2 = icon = enabled ? this.defaultIcon : this.disabledIcon;
        if (icon != null || haveText) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            String clippedText = this.layout(this, fm, this.getWidth(), this.getHeight());
            if (icon != null) {
                icon.paintIcon(this, g, this.paintIconR.x, this.paintIconR.y);
            }
            if (haveText) {
                View v = (View)this.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.paintTextR);
                } else {
                    int textX = this.paintTextR.x;
                    int textY = this.paintTextR.y + fm.getAscent();
                    if (enabled) {
                        this.paintEnabledText(this, g, clippedText, textX, textY);
                    } else {
                        this.paintDisabledText(this, g, clippedText, textX, textY);
                    }
                }
            }
        }
        if (opaque && renderer != null && renderer.isPaintBorder()) {
            renderer.paintBorder(g, this);
        }
    }

    private String layout(JComponent label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(null);
        Icon icon = this.isEnabled() ? this.defaultIcon : this.disabledIcon;
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, this.text, icon, paintViewR, this.paintIconR, this.paintTextR);
    }

    protected String layoutCL(JComponent label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, viewR, iconR, textR, this.iconTextGap);
    }

    protected void paintEnabledText(JComponent l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getForeground());
        g.drawString(s, textX, textY);
    }

    protected void paintDisabledText(JComponent l, Graphics g, String s, int textX, int textY) {
        Color background = l.getBackground();
        g.setColor(background.darker());
        g.drawString(s, textX, textY);
    }

    @Override
    @BeanProperty(hidden=true, visualUpdate=true, description="The UI object that implements the Component's LookAndFeel.")
    public void setUI(ComponentUI ui) {
        super.setUI(ui);
        if (!this.disabledIconSet && this.disabledIcon != null) {
            this.setDisabledIcon(null);
        }
    }

    @Transient
    public Icon getDisabledIcon() {
        if (!this.disabledIconSet && this.disabledIcon == null && this.defaultIcon != null) {
            this.disabledIcon = UIManager.getLookAndFeel().getDisabledIcon(this, this.defaultIcon);
            if (this.disabledIcon != null) {
                this.firePropertyChange("disabledIcon", null, this.disabledIcon);
            }
        }
        return this.disabledIcon;
    }

    @BeanProperty(visualUpdate=true, description="The icon to display if the label is disabled.")
    public void setDisabledIcon(Icon disabledIcon) {
        Icon oldValue = this.disabledIcon;
        this.disabledIcon = disabledIcon;
        this.disabledIconSet = disabledIcon != null;
        this.firePropertyChange("disabledIcon", oldValue, disabledIcon);
        if (disabledIcon != oldValue) {
            if (disabledIcon == null || oldValue == null || disabledIcon.getIconWidth() != oldValue.getIconWidth() || disabledIcon.getIconHeight() != oldValue.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled()) {
                this.repaint();
            }
        }
    }

    public int getDisplayTime() {
        return this.displayTime;
    }

    @BeanProperty(preferred=true, description="Sets the time in milliseconds that a message will be displayed before being cleared.  If 0, text is not removed.")
    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
    }

    @BeanProperty(preferred=true, description="Sets the position of the text relative to the icon.")
    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    @BeanProperty(expert=true, visualUpdate=true, enumerationValues={"SwingConstants.LEFT", "SwingConstants.CENTER", "SwingConstants.RIGHT", "SwingConstants.LEADING", "SwingConstants.TRAILING"}, description="The horizontal position of the label's text, relative to its image.")
    public void setHorizontalTextPosition(int textPosition) {
        int old = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(textPosition, "horizontalTextPosition");
        this.firePropertyChange("horizontalTextPosition", old, this.horizontalTextPosition);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    @BeanProperty(expert=true, visualUpdate=true, enumerationValues={"SwingConstants.TOP", "SwingConstants.CENTER", "SwingConstants.BOTTOM"}, description="The vertical position of the text relative to it's image.")
    public void setVerticalTextPosition(int textPosition) {
        if (textPosition == this.verticalTextPosition) {
            return;
        }
        int old = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(textPosition, "verticalTextPosition");
        this.firePropertyChange("verticalTextPosition", old, this.verticalTextPosition);
        this.revalidate();
        this.repaint();
    }

    @BeanProperty(visualUpdate=true, enumerationValues={"SwingConstants.LEFT", "SwingConstants.CENTER", "SwingConstants.RIGHT", "SwingConstants.LEADING", "SwingConstants.TRAILING"}, description="The alignment of the label's content along the X axis.")
    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(alignment, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @BeanProperty(visualUpdate=true, enumerationValues={"SwingConstants.TOP", "SwingConstants.CENTER", "SwingConstants.BOTTOM"}, description="The alignment of the label's contents along the Y axis.")
    public void setVerticalAlignment(int alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(alignment, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", oldValue, this.verticalAlignment);
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The icon this component will display.")
    public void setIcon(Icon icon) {
        Icon oldValue = this.defaultIcon;
        this.defaultIcon = icon;
        if (this.defaultIcon != oldValue && !this.disabledIconSet) {
            this.disabledIcon = null;
        }
        this.firePropertyChange("icon", oldValue, this.defaultIcon);
        if (this.defaultIcon != oldValue) {
            if (this.defaultIcon == null || oldValue == null || this.defaultIcon.getIconWidth() != oldValue.getIconWidth() || this.defaultIcon.getIconHeight() != oldValue.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    @BeanProperty(preferred=true, description="Sets the gap between the text and the icon.")
    public void setIconTextGap(int value) {
        if (value >= 0) {
            this.iconTextGap = value;
        }
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    protected int checkHorizontalKey(int key, String message) {
        if (key == 2 || key == 0 || key == 4 || key == 10 || key == 11) {
            return key;
        }
        throw new IllegalArgumentException(message);
    }

    protected int checkVerticalKey(int key, String message) {
        if (key == 1 || key == 0 || key == 3) {
            return key;
        }
        return 0;
    }
}

