/*
 * Decompiled with CFR 0.152.
 */
package ScrollPanels;

import JMConstants.Constants;
import JMScrollBars.JMScrollBar;
import Renderers.BasicRenderer;
import Renderers.GelRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import Renderers.MetallicRenderer;
import ScrollPanels.StatusLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ExtendedScrollPanel
extends JComponent
implements Constants {
    private Font mFont;
    public JPanel displayPanel;
    public JMScrollBar hScroll;
    public StatusLabel statusLabel;
    public JMScrollBar vScroll;

    public int fontHeight() {
        return this.displayPanel.getGraphics().getFontMetrics().getHeight();
    }

    public int fontWidth() {
        return this.displayPanel.getGraphics().getFontMetrics().charWidth(' ');
    }

    public StatusLabel getTopLabel() {
        return this.statusLabel;
    }

    @BeanProperty(preferred=true, description="Sets the style of the track.")
    public void setScrollbarTrackStyle(Constants.DEFAULTRENDERERS style) {
        this.hScroll.setTrackStyle(style);
        this.vScroll.setTrackStyle(style);
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getScrollbarTrackStyle() {
        return this.hScroll.getTrackStyle();
    }

    @BeanProperty(preferred=true, description="Sets the style of the thumb.")
    public void setScrollbarThumbStyle(Constants.DEFAULTRENDERERS style) {
        this.hScroll.setThumbStyle(style);
        this.vScroll.setThumbStyle(style);
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getScrollbarThumbStyle() {
        return this.hScroll.getThumbStyle();
    }

    public void setTopLabelText(String text) {
        this.statusLabel.setText(text);
    }

    public String getTopLabelText() {
        return this.statusLabel.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.mFont = font;
        if (this.statusLabel != null) {
            this.statusLabel.setFont(this.mFont);
        }
    }

    public Color getScrollbarTrackColor() {
        return this.hScroll.getTrackColor();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars.")
    public void setScrollbarTrackColor(Color color) {
        this.hScroll.setTrackColor(color);
        this.vScroll.setTrackColor(color);
        this.repaint();
    }

    public Color getScrollbarTrackColorRollover() {
        return this.hScroll.getTrackColorRollOver();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars when the mouse is over.")
    public void setScrollbarTrackColorRollover(Color color) {
        this.hScroll.setTrackColorRollOver(color);
        this.vScroll.setTrackColorRollOver(color);
        this.repaint();
    }

    public Color getScrollbarTrackColorPressed() {
        return this.hScroll.getTrackColorPressed();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars when mouse is pressed.")
    public void setScrollbarTrackColorPressed(Color color) {
        this.hScroll.setTrackColorPressed(color);
        this.vScroll.setTrackColorPressed(color);
        this.repaint();
    }

    public Color getScrollbarTrackBorderColor() {
        return this.hScroll.getBorderColor();
    }

    @BeanProperty(preferred=true, description="Sets the border color of scrollbar.")
    public void setScrollbarTrackBorderColor(Color color) {
        this.hScroll.setBorderColor(color);
        this.vScroll.setBorderColor(color);
        this.repaint();
    }

    public Color getScrollbarThumbBorderColor() {
        return this.hScroll.getThumbBorderColor();
    }

    @BeanProperty(preferred=true, description="Sets the border color of scrollbar.")
    public void setScrollBarThumbBorderColor(Color color) {
        this.hScroll.setThumbBorderColor(color);
        this.vScroll.setThumbBorderColor(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorRollOver() {
        return this.hScroll.getThumbColorOver();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs.")
    public void setScrollbarThumbColorRollOver(Color color) {
        this.hScroll.setThumbColorOver(color);
        this.vScroll.setThumbColorOver(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorPressed() {
        return this.hScroll.getThumbColorPressed();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs when the mouse is down.")
    public void setScrollbarThumbColorPressed(Color color) {
        this.hScroll.setThumbColorPressed(color);
        this.vScroll.setThumbColorPressed(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorOut() {
        return this.hScroll.getThumbColor();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs when mouse is not over the scrollbar.")
    public void setScrollbarThumbColorOut(Color color) {
        this.hScroll.setThumbColor(color);
        this.vScroll.setThumbColor(color);
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets the style of the track.", enumerationValues={"DEFAULT", "SOLID", "METAL", "METALLIC", "JAVT"})
    public void setScrollbarTrackStyle(int style) {
        switch (style) {
            case 6: {
                this.hScroll.setTrackRenderer(new MetallicRenderer(this.hScroll));
                this.vScroll.setTrackRenderer(new MetallicRenderer(this.vScroll));
                break;
            }
            case 7: {
                this.hScroll.setTrackRenderer(new JavTRenderer(this.hScroll));
                this.vScroll.setTrackRenderer(new JavTRenderer(this.vScroll));
                break;
            }
            case 9: {
                this.hScroll.setThumbRenderer(new MetalRenderer(this.hScroll));
                this.vScroll.setThumbRenderer(new MetalRenderer(this.vScroll));
                break;
            }
            case 1: {
                this.hScroll.setTrackRenderer(new BasicRenderer(this.hScroll));
                this.vScroll.setTrackRenderer(new BasicRenderer(this.vScroll));
                break;
            }
            default: {
                this.hScroll.setTrackRenderer(null);
                this.vScroll.setTrackRenderer(null);
            }
        }
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets which scrollbars if any are visible by default.", enumerationValues={"NONE", "HORIZONTAL", "VERTICAL", "BOTH"})
    public void setScrollBars(int bar) {
        this.hScroll.setVisible(bar == 0 || bar == 2);
        this.vScroll.setVisible(bar == 1 || bar == 2);
    }

    public int getScrollBars() {
        if (this.hScroll.isVisible() && this.vScroll.isVisible()) {
            return 2;
        }
        if (this.hScroll.isVisible()) {
            return 0;
        }
        if (this.vScroll.isVisible()) {
            return 1;
        }
        return -1;
    }

    public ExtendedScrollPanel() {
        this.initComponents();
        this.displayPanel.setFocusable(true);
        this.displayPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ExtendedScrollPanel.this.displayPanel.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLabel.setVerticalAlignment(1);
        this.statusLabel.setOpaque(false);
        this.mFont = this.getFont();
        this.statusLabel.setFont(this.mFont);
        this.displayPanel.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                ExtendedScrollPanel.this.displayPanelResized(ExtendedScrollPanel.this.displayPanel.getWidth(), ExtendedScrollPanel.this.displayPanel.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
    }

    public void hScrollValueChanged(long newValue) {
    }

    public void vScrollValueChanged(long newValue) {
    }

    public void DisplayPanelClicked(MouseEvent arg0) {
    }

    public void DisplayPanelMouseMoved(MouseEvent arg0) {
    }

    public void DisplayPanelMouseDragged(MouseEvent arg0) {
    }

    public void DisplayPanelMouseClicked(MouseEvent arg0) {
    }

    public void DisplayPanelMousePressed(MouseEvent arg0) {
    }

    public void DisplayPanelMouseReleased(MouseEvent arg0) {
    }

    public void DisplayPanelMouseEntered(MouseEvent arg0) {
    }

    public void DisplayPanelMouseExited(MouseEvent arg0) {
    }

    public void displayPanelResized(int Width, int Height) {
    }

    public boolean DisplayPanelKeyTyped(KeyEvent arg0) {
        return false;
    }

    public boolean DisplayPanelKeyPressed(KeyEvent arg0) {
        return false;
    }

    public boolean DisplayPanelKeyReleased(KeyEvent arg0) {
        return false;
    }

    public void customDisplayPaint(Graphics g, int Width, int Height) {
    }

    private void initComponents() {
        this.vScroll = new JMScrollBar(){

            @Override
            public void valueChanged(long value) {
                ExtendedScrollPanel.this.vScrollValueChanged(value);
            }
        };
        this.hScroll = new JMScrollBar(){

            @Override
            public void valueChanged(long value) {
                ExtendedScrollPanel.this.hScrollValueChanged(value);
            }
        };
        this.displayPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics g2 = img.getGraphics();
                super.paint(g2);
                g2.setFont(ExtendedScrollPanel.this.mFont);
                ExtendedScrollPanel.this.customDisplayPaint(g2, ExtendedScrollPanel.this.displayPanel.getWidth(), ExtendedScrollPanel.this.displayPanel.getHeight());
                g.drawImage(img, 0, 0, this);
                g2.dispose();
            }
        };
        this.statusLabel = new StatusLabel();
        GelRenderer renderer = new GelRenderer();
        renderer.setOrientation(1);
        this.statusLabel.setRenderer(renderer);
        this.statusLabel.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setFont(new Font("Segoe UI", 0, 18));
        this.vScroll.setMaximum(0L, false);
        this.vScroll.setOrientation(1);
        this.vScroll.setInvertDirection(true);
        this.hScroll.setOrientation(0);
        this.displayPanel.setBackground(new Color(255, 255, 255));
        this.displayPanel.setCursor(new Cursor(0));
        this.displayPanel.setFont(new Font("DialogInput", 0, 14));
        this.displayPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ExtendedScrollPanel.this.displayPanelComponentResized(evt);
            }
        });
        GroupLayout displayPanelLayout = new GroupLayout(this.displayPanel);
        this.displayPanel.setLayout(displayPanelLayout);
        displayPanelLayout.setHorizontalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        displayPanelLayout.setVerticalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout topLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(topLabelLayout);
        topLabelLayout.setHorizontalGroup(topLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        topLabelLayout.setVerticalGroup(topLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 29, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hScroll, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.vScroll, -2, 15, -2)).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel, -2, 29, -2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vScroll, -1, 267, Short.MAX_VALUE).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.hScroll, -2, 16, -2).addGap(0, 0, 0)));
    }

    private void displayPanelComponentResized(ComponentEvent evt) {
        this.displayPanelResized(this.displayPanel.getWidth(), this.displayPanel.getHeight());
    }
}

