/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class MetallicRenderer
extends GradientRenderer {
    public MetallicRenderer(Component parent) {
        super(parent);
    }

    public MetallicRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public MetallicRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public MetallicRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public MetallicRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public MetallicRenderer() {
    }

    public MetallicRenderer(boolean rounded) {
        super(rounded);
    }

    public MetallicRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public MetallicRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public MetallicRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        Color baseColor3;
        Color baseColor2;
        Color baseColor;
        int wd;
        int ht;
        int left;
        int top;
        Shape main;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape oldClip = g2d.getClip();
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            main = bounds;
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height;
            wd = bounds.width;
        } else {
            main = this.getShape(c);
            top = 0;
            left = 0;
            ht = c.getHeight();
            wd = c.getWidth();
        }
        g2d.clip(main);
        Color baseColor4 = Color.WHITE;
        if (state == 2 || state == 4) {
            baseColor = Color.GRAY;
            baseColor2 = baseColor.brighter();
            baseColor3 = Color.LIGHT_GRAY;
        } else {
            switch (state) {
                case 5: {
                    baseColor = this.getOverColor(c);
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    baseColor = this.getDownColor(c);
                    break;
                }
                default: {
                    baseColor = this.getNormalColor(c);
                }
            }
            baseColor2 = baseColor.brighter();
            baseColor3 = baseColor2.brighter();
        }
        if (this.orientation == 1) {
            int halfWd = wd / 2;
            g2d.setPaint(new GradientPaint(left, top, baseColor4, halfWd, top, baseColor2, false));
            g2d.fillRect(left, top, halfWd, ht);
            g2d.setPaint(new GradientPaint(halfWd, top, baseColor, wd, top, baseColor3, false));
            g2d.fillRect(halfWd, top, halfWd, ht);
            g2d.setClip(null);
        } else {
            int halfHt = ht / 2;
            g2d.setPaint(new GradientPaint(left, top, baseColor4, left, halfHt, baseColor2, false));
            g2d.fillRect(left, top, wd, halfHt);
            g2d.setPaint(new GradientPaint(left, halfHt, baseColor, left, ht, baseColor3, false));
            g2d.fillRect(left, halfHt, wd, halfHt);
            g2d.setClip(null);
        }
        g2d.setClip(oldClip);
        g2d.dispose();
    }
}

