/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class MetalRenderer
extends Renderer {
    boolean paintLines = false;
    int LINECOUNT = 4;
    int LINEHEIGHT = 6;
    int LINEHALF = this.LINEHEIGHT / 2;
    Color bumpColor;

    public MetalRenderer(Component parent) {
        super(parent);
    }

    public MetalRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public MetalRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public MetalRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public MetalRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public MetalRenderer() {
    }

    public MetalRenderer(boolean rounded) {
        super(rounded);
    }

    public MetalRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public MetalRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public MetalRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    public void setBumpColor(Color color) {
        this.bumpColor = color;
    }

    public Color getBumpColor() {
        return this.bumpColor;
    }

    public void setShowBumps(boolean paint) {
        this.paintLines = paint;
    }

    public boolean isShowBumps() {
        return this.paintLines;
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        int wd;
        int ht;
        int left;
        int top;
        Shape clipShape;
        Color colorStart1 = this.colors.getColor(1, state);
        if (colorStart1 == null) {
            return;
        }
        Color colorEnd1 = colorStart1.darker();
        Color colorStart2 = colorEnd1.darker();
        Color colorEnd2 = colorStart2.darker();
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            clipShape = bounds;
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height;
            wd = bounds.width;
        } else {
            clipShape = this.getShape(c);
            top = 0;
            left = 0;
            ht = c.getHeight();
            wd = c.getWidth();
        }
        int wdHalf = wd / 2;
        int htHalf = ht / 2;
        Graphics2D g2d = (Graphics2D)g.create();
        Shape oldClip = g2d.getClip();
        g2d.clip(clipShape);
        if (this.getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(left, top, colorStart1, left, htHalf, colorEnd1, false));
            g2d.fillRect(left, top, wd, htHalf);
            g2d.setPaint(new GradientPaint(left, htHalf + 1, colorStart2, left, ht, colorEnd2, false));
            g2d.fillRect(left, htHalf, wd, htHalf + 1);
            if (this.paintLines) {
                int x = left + wdHalf - this.LINEHALF;
                int y = top + htHalf - this.LINEHALF;
                int count = 0;
                g2d.setColor(this.bumpColor != null ? this.bumpColor : colorStart1);
                for (int x2 = 0; x2 < this.LINECOUNT; ++x2) {
                    g2d.drawLine(x + count, y, x + count, y + this.LINEHEIGHT);
                    count += 2;
                }
            }
        } else {
            g2d.setPaint(new GradientPaint(left, top, colorStart1, wdHalf, top, colorEnd1, false));
            g2d.fillRect(left, top, wdHalf, ht);
            g2d.setPaint(new GradientPaint(wdHalf + 1, top, colorStart2, wd, top, colorEnd2, false));
            g2d.fillRect(wdHalf, top, wd, ht);
            if (this.paintLines) {
                int x = left + wdHalf - this.LINEHALF;
                int y = top + htHalf - this.LINEHALF;
                int count = 0;
                g2d.setColor(this.bumpColor != null ? this.bumpColor : colorStart1);
                for (int y2 = 0; y2 < this.LINECOUNT; ++y2) {
                    g2d.drawLine(x, y + count, x + this.LINEHEIGHT, y + count);
                    count += 2;
                }
            }
        }
        g2d.setClip(oldClip);
        g2d.dispose();
    }
}

