/*
 * Decompiled with CFR 0.152.
 */
package RegExpressions;

public class DNARegExpressions {
    public static final String SEQUENCE_GAP_FILTER = "[^atgcnATGCN-]";
    public static final String SEQUENCE_FILTER = "[^atgcnATGCN]";
    public static final String ASF_SF2_CONSENSUS = "(?<seq>(?:C|G)(?:A|G)(?:C|G)A(?:C|G)GA)";
    public static final String SRSF1_CONSENSUS = "(?<seq>(?:(?:(?:AGGAC)(?:(?:AG)|(?:GA))(?:AGC)))|(?:A|G)(?:GAAGAAC))";
    public static final String BINDING_SITE_STAF = "YY(A|T)CCC(A|G)N(A|C)AT(G|C)C(A|C)YY-RCR";
    public static final String BINDING_SITE_OCTAMER = "ATGCAAAT";
    public static final String BINDING_SITE_CREB = "TGACG";
    public static final String BINDING_SITE_CEBP = "TKNNGMAAK";
    public static final String BINDING_SITE_TP53 = "RRRCATGYCCGGGCATGT";
    public static final String SPLICE_DONOR = "(?:A|C)AG(?<seq>GT(?:A|G)AGT)";
    public static final String SPLICE_ACCEPTOR = "(?<seq>(?:T|C){11}(?:A|T|G|C)(?:T|C)AG)G";

    public static String DNASequenceToRegex(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return "";
        }
        StringBuilder outVal = new StringBuilder();
        char[] inString = sequence.toUpperCase().toCharArray();
        int charIndex = 0;
        while (charIndex < inString.length) {
            int charCount = 0;
            char curChar = inString[charIndex];
            while (charIndex < inString.length && inString[charIndex] == curChar) {
                ++charCount;
                ++charIndex;
            }
            if (charCount > 1) {
                outVal.append(DNARegExpressions.degenToRegEx(curChar)).append("{").append(charCount).append("}");
                continue;
            }
            if (charCount != 1) continue;
            outVal.append(DNARegExpressions.degenToRegEx(curChar));
        }
        return outVal.toString();
    }

    public static String DNASequenceToRegexOfAntisense(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return "";
        }
        StringBuilder outVal = new StringBuilder();
        char[] inString = sequence.toUpperCase().toCharArray();
        int charIndex = 0;
        while (charIndex < inString.length) {
            int charCount = 0;
            char curChar = inString[charIndex];
            while (charIndex < inString.length && inString[charIndex] == curChar) {
                ++charCount;
                ++charIndex;
            }
            if (charCount > 1) {
                outVal.append(DNARegExpressions.degenToRegEx(curChar)).append("{").append(charCount).append("}");
                continue;
            }
            if (charCount != 1) continue;
            outVal.append(DNARegExpressions.degenToRegEx(curChar));
        }
        return outVal.toString();
    }

    private static String degenToRegEx(char nucleotide) {
        switch (nucleotide) {
            case 'A': {
                return "A";
            }
            case 'C': {
                return "C";
            }
            case 'G': {
                return "G";
            }
            case 'T': {
                return "T";
            }
            case 'R': {
                return "[AG]";
            }
            case 'Y': {
                return "[CT]";
            }
            case 'S': {
                return "[GC]";
            }
            case 'W': {
                return "[AT]";
            }
            case 'K': {
                return "[GT]";
            }
            case 'M': {
                return "[AC]";
            }
            case 'B': {
                return "[^A]";
            }
            case 'D': {
                return "[^C]";
            }
            case 'H': {
                return "[^G]";
            }
            case 'V': {
                return "[^T]";
            }
        }
        return ".";
    }
}

