/*
 * Decompiled with CFR 0.152.
 */
package ProteinTools;

import ProteinTools.AminoAcid;
import java.awt.Color;

public class AminoAcids {
    private static AminoAcids defaultAminoAcids;
    private final AminoAcid[] aminoAcids = new AminoAcid[27];
    AminoAcid nullAA = new AminoAcid();

    public static AminoAcids getDefaultAminoAcids() {
        if (defaultAminoAcids == null) {
            defaultAminoAcids = new AminoAcids();
        }
        return defaultAminoAcids;
    }

    public AminoAcids() {
        for (int x = 0; x < AminoAcid.NAMES.length; ++x) {
            AminoAcid aa = new AminoAcid();
            aa.name = AminoAcid.NAMES[x];
            aa.abbr1 = AminoAcid.Abbr1[x];
            aa.abbr3 = AminoAcid.Abbr3[x];
            aa.molecular_formula = AminoAcid.Molecular_Formula[x];
            aa.residue_formula = AminoAcid.Residue_Formula[x];
            aa.polarity_of_r_group = AminoAcid.Polarity_of_R_group[x];
            aa.mwt = AminoAcid.Mwt[x];
            aa.residue_weight = AminoAcid.Residue_Weight[x];
            aa.pkaC = AminoAcid.PKa[x];
            aa.pkbN = AminoAcid.PKb[x];
            aa.pkxR = AminoAcid.PKx[x];
            aa.pI = AminoAcid.PI[x];
            aa.surface = AminoAcid.Surface[x];
            aa.volume = AminoAcid.Volume[x];
            aa.solubility = AminoAcid.Solubility[x];
            aa.density = AminoAcid.Density[x];
            aa.r_group_charge = AminoAcid.R_group_charge[x];
            aa.r_group_polarity = AminoAcid.R_group_polarity[x];
            aa.essential = AminoAcid.Essential[x];
            aa.sulfur_containing = AminoAcid.Sulfur_Containing[x];
            aa.amidic = AminoAcid.Amidic[x];
            aa.hydroxylic = AminoAcid.Hydroxylic[x];
            aa.hydrophobic = AminoAcid.Hydrophobic[x];
            aa.aliphatic = AminoAcid.Aliphatic[x];
            aa.aromatic = AminoAcid.Aromatic[x];
            aa.polar_uncharged = AminoAcid.Polar_uncharged[x];
            aa.acidic = AminoAcid.Acidic[x];
            aa.basic = AminoAcid.Basic[x];
            this.aminoAcids[aa.getAbbr1() - 65] = aa;
        }
        this.aminoAcids[26] = new AminoAcid();
        this.aminoAcids[26].name = "Stop";
        this.aminoAcids[26].abbr1 = (char)42;
        this.aminoAcids[26].abbr3 = " * ";
        this.nullAA.name = "Unknown";
        this.nullAA.abbr1 = (char)88;
        this.nullAA.abbr3 = "Xxx";
    }

    public void colorBy(char aa, Color color) {
        for (int x = 0; x < this.aminoAcids.length; ++x) {
            if (this.aminoAcids[x] == null) continue;
            this.aminoAcids[x].color = this.aminoAcids[x].abbr1 == aa ? color : null;
        }
    }

    public void colorBy(AminoAcid.Properties property, Color colorHigh, Color colorLow) {
        switch (property) {
            case None: {
                this.colorClear();
                break;
            }
            case Mwt: {
                this.colorBy(AminoAcid.Mwt, colorHigh, colorLow);
                break;
            }
            case Residue_Weight: {
                this.colorBy(AminoAcid.Residue_Weight, colorHigh, colorLow);
                break;
            }
            case PKa: {
                this.colorBy(AminoAcid.PKa, colorHigh, colorLow);
                break;
            }
            case PKb: {
                this.colorBy(AminoAcid.PKb, colorHigh, colorLow);
                break;
            }
            case PKx: {
                this.colorBy(AminoAcid.PKx, colorHigh, colorLow);
                break;
            }
            case PI: {
                this.colorBy(AminoAcid.PI, colorHigh, colorLow);
                break;
            }
            case Surface: {
                this.colorBy(AminoAcid.Surface, colorHigh, colorLow);
                break;
            }
            case Volume: {
                this.colorBy(AminoAcid.Volume, colorHigh, colorLow);
                break;
            }
            case Solubility: {
                this.colorBy(AminoAcid.Solubility, colorHigh, colorLow);
                break;
            }
            case Density: {
                this.colorBy(AminoAcid.Density, colorHigh, colorLow);
                break;
            }
            case R_group_charge: {
                this.colorBy(AminoAcid.R_group_charge, colorHigh, colorLow);
                break;
            }
            case R_group_polarity: {
                this.colorBy(AminoAcid.R_group_polarity, colorHigh, colorLow);
                break;
            }
            case Essential: {
                this.colorBy(AminoAcid.Essential, colorHigh);
                break;
            }
            case Sulfur_Containing: {
                this.colorBy(AminoAcid.Sulfur_Containing, colorHigh);
                break;
            }
            case Amidic: {
                this.colorBy(AminoAcid.Amidic, colorHigh);
                break;
            }
            case Hydroxylic: {
                this.colorBy(AminoAcid.Hydroxylic, colorHigh);
                break;
            }
            case Hydrophobic: {
                this.colorBy(AminoAcid.Hydrophobic, colorHigh);
                break;
            }
            case Aliphatic: {
                this.colorBy(AminoAcid.Aliphatic, colorHigh);
                break;
            }
            case Aromatic: {
                this.colorBy(AminoAcid.Aromatic, colorHigh);
                break;
            }
            case Polar_uncharged: {
                this.colorBy(AminoAcid.Polar_uncharged, colorHigh);
                break;
            }
            case Acidic: {
                this.colorBy(AminoAcid.Acidic, colorHigh);
                break;
            }
            case Basic: {
                this.colorBy(AminoAcid.Basic, colorHigh);
            }
        }
    }

    private float scale(float Value, float InputMin, float InputMax, float OutputMin, float OutputMax) {
        return (Value - InputMin) / (InputMax - InputMin) * (OutputMax - OutputMin) + OutputMin;
    }

    private float scale(int Value, int InputMin, int InputMax, int OutputMin, int OutputMax) {
        return (float)(Value - InputMin) / (float)(InputMax - InputMin) * (float)(OutputMax - OutputMin) + (float)OutputMin;
    }

    private void colorClear() {
        for (int x = 0; x < this.aminoAcids.length; ++x) {
            if (this.aminoAcids[x] == null) continue;
            this.aminoAcids[x].color = null;
        }
    }

    private void colorBy(float[] values, Color colorHigh, Color colorLow) {
        int x;
        int rh = colorHigh.getRed();
        int gh = colorHigh.getGreen();
        int bh = colorHigh.getBlue();
        float lowest = 0.0f;
        float highest = 0.0f;
        for (x = 0; x < values.length; ++x) {
            if (values[x] < lowest) {
                lowest = values[x];
                continue;
            }
            if (!(values[x] > highest)) continue;
            highest = values[x];
        }
        for (x = 0; x < values.length; ++x) {
            if (this.aminoAcids[x] == null) continue;
            this.aminoAcids[x].color = new Color(rh, gh, bh, (int)this.scale(values[x], lowest, highest, 20.0f, 255.0f));
        }
    }

    private void colorBy(int[] values, Color colorHigh, Color colorLow) {
        int x;
        int rh = colorHigh.getRed();
        int gh = colorHigh.getGreen();
        int bh = colorHigh.getBlue();
        int rl = colorLow.getRed();
        int gl = colorLow.getGreen();
        int bl = colorLow.getBlue();
        float lowest = 0.0f;
        float highest = 0.0f;
        for (x = 0; x < values.length; ++x) {
            if ((float)values[x] < lowest) {
                lowest = values[x];
                continue;
            }
            if (!((float)values[x] > highest)) continue;
            highest = values[x];
        }
        for (x = 0; x < values.length; ++x) {
            int r = (int)this.scale((float)values[x], lowest, highest, (float)rl, (float)rh);
            int g = (int)this.scale((float)values[x], lowest, highest, (float)gl, (float)gh);
            int b = (int)this.scale((float)values[x], lowest, highest, (float)bl, (float)bh);
            int aaIndex = AminoAcid.Abbr1[x] - 65;
            if (this.aminoAcids[aaIndex] == null) continue;
            this.aminoAcids[aaIndex].color = new Color(r, g, b);
        }
    }

    private void colorBy(boolean[] values, Color color) {
        for (int x = 0; x < values.length; ++x) {
            int aaIndex = AminoAcid.Abbr1[x] - 65;
            if (this.aminoAcids[aaIndex] == null) continue;
            this.aminoAcids[aaIndex].color = values[x] ? color : null;
        }
    }

    private void colorByNot(boolean[] values, Color colorHigh, Color color) {
        for (int x = 0; x < values.length; ++x) {
            int aaIndex = AminoAcid.Abbr1[x] - 65;
            if (this.aminoAcids[aaIndex] == null) continue;
            this.aminoAcids[aaIndex].color = !values[x] ? color : null;
        }
    }

    public AminoAcid get(int index) {
        if (index >= 0 && index < this.aminoAcids.length) {
            return this.aminoAcids[index];
        }
        return this.nullAA;
    }

    public AminoAcid getAA(int aa) {
        if (aa == 42) {
            return this.aminoAcids[26];
        }
        if (aa < 65 || aa > 90) {
            return this.nullAA;
        }
        return this.aminoAcids[aa - 65];
    }

    public AminoAcid getAA(char aa) {
        return this.getAA((int)aa);
    }
}

