/*
 * Decompiled with CFR 0.152.
 */
package ProteinTools;

import java.awt.Color;

public class AminoAcid {
    public static final int AA_ALANINE = 65;
    public static final int AA_ARGININE = 82;
    public static final int AA_ASPARAGINE = 78;
    public static final int AA_ASPARTICACID = 68;
    public static final int AA_CYSTEINE = 67;
    public static final int AA_GLUTAMICACID = 69;
    public static final int AA_GLUTAMINE = 81;
    public static final int AA_GLYCINE = 71;
    public static final int AA_HISTIDINE = 72;
    public static final int AA_ISOLEUCINE = 73;
    public static final int AA_LEUCINE = 76;
    public static final int AA_LYSINE = 75;
    public static final int AA_METHIONINE = 77;
    public static final int AA_PHENYLALANINE = 70;
    public static final int AA_PROLINE = 80;
    public static final int AA_SERINE = 83;
    public static final int AA_THREONINE = 84;
    public static final int AA_TRYPTOPHAN = 87;
    public static final int AA_TYROSINE = 89;
    public static final int AA_VALINE = 86;
    public static final int NEUTRAL = 0;
    public static final int NON_POLAR = 0;
    public static final int POLAR_UNCHARGED = 0;
    public static final int POLAR_NEGATIVE = -1;
    public static final int POLAR_POSITIVE = 1;
    public static final int HYDROPHOBIC_ALIPHATIC = 0;
    public static final int HYDROPHOBIC_AROMATIC = 1;
    public static final int HYDROPHILLIC_ACIDIC = 2;
    public static final int HYDROPHILLIC_BASIC = 3;
    public static final int HYDROPHILLIC_NEUTRAL = 4;
    public static final String[] NAMES = new String[]{"Alanine", "Arginine", "Asparagine", "Aspartic acid", "Cysteine", "Glutamic acid", "Glutamine", "Glycine", "Histidine", "Isoleucine", "Leucine", "Lysine", "Methionine", "Phenylalanine", "Proline", "Serine", "Threonine", "Tryptophan", "Tyrosine", "Valine"};
    public static final char[] Abbr1 = new char[]{'A', 'R', 'N', 'D', 'C', 'E', 'Q', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    public static final String[] Abbr3 = new String[]{"Ala", "Arg", "Asn", "Asp", "Cys", "Glu", "Gln", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val"};
    static final String[] Molecular_Formula = new String[]{"C3H7NO2", "C6H14N4O2", "C4H8N2O3", "C4H7NO4", "C3H7NO2S", "C5H9NO4", "C5H10N2O3", "C2H5NO2", "C6H9N3O2", "C6H13NO2", "C6H13NO2", "C6H14N2O2", "C5H11NO2S", "C9H11NO2", "C5H9NO2", "C3H7NO3", "C4H9NO3", "C11H12N2O2", "C9H11NO3", "C5H11NO2"};
    static final String[] Residue_Formula = new String[]{"C3H5NO", "C6H12N4O", "C4H6N2O2", "C4H5NO3", "C3H5NOS", "C5H7NO3", "C5H8N2O2", "C2H3NO", "C6H7N3O", "C6H11NO", "C6H11NO", "C6H12N2O", "C5H9NOS", "C9H9NO", "C5H7NO", "C3H5NO2", "C4H7NO2", "C11H10N2O", "C9H9NO2", "C5H9NO"};
    static final String[] Polarity_of_R_group = new String[]{"Non-polar", "Positive polar", "Uncharged polar", "Negative polar", "Uncharged polar", "Negative polar", "Uncharged polar", "Uncharged polar", "Positive polar", "Non-polar", "Non-polar", "Positive polar", "Non-polar", "Non-polar", "Non-polar", "Uncharged polar", "Uncharged polar", "Non-polar", "Uncharged polar", "Non-polar"};
    static final float[] Mwt = new float[]{89.1f, 174.2f, 132.12f, 133.11f, 121.16f, 147.13f, 146.15f, 75.07f, 155.16f, 131.18f, 131.18f, 146.19f, 149.21f, 165.19f, 115.13f, 105.09f, 119.12f, 204.23f, 181.19f, 117.15f};
    static final float[] Residue_Weight = new float[]{71.08f, 156.19f, 114.11f, 115.09f, 103.15f, 129.12f, 128.13f, 57.05f, 137.14f, 113.16f, 113.16f, 128.18f, 131.2f, 147.18f, 97.12f, 87.08f, 101.11f, 186.22f, 163.18f, 99.13f};
    static final float[] PKa = new float[]{2.34f, 2.17f, 2.02f, 1.88f, 1.96f, 2.19f, 2.17f, 2.34f, 1.82f, 2.36f, 2.36f, 2.18f, 2.28f, 1.83f, 1.99f, 2.21f, 2.09f, 2.83f, 2.2f, 2.32f};
    static final float[] PKb = new float[]{9.69f, 9.04f, 8.8f, 9.6f, 10.28f, 9.67f, 9.13f, 9.6f, 9.17f, 9.6f, 9.6f, 8.95f, 9.21f, 9.13f, 10.6f, 9.15f, 9.1f, 9.39f, 9.11f, 9.62f};
    static final float[] PKx = new float[]{0.0f, 12.48f, 0.0f, 3.65f, 8.18f, 4.25f, 0.0f, 0.0f, 6.0f, 0.0f, 0.0f, 10.53f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 10.07f, 0.0f};
    static final float[] PI = new float[]{6.0f, 10.76f, 5.41f, 2.77f, 5.07f, 3.22f, 5.65f, 5.97f, 7.59f, 6.02f, 5.98f, 9.74f, 5.74f, 5.48f, 6.3f, 5.68f, 5.6f, 5.89f, 5.66f, 5.96f};
    static final float[] Surface = new float[]{115.0f, 225.0f, 160.0f, 150.0f, 135.0f, 190.0f, 180.0f, 75.0f, 195.0f, 175.0f, 170.0f, 200.0f, 185.0f, 210.0f, 145.0f, 115.0f, 140.0f, 255.0f, 230.0f, 155.0f};
    static final float[] Volume = new float[]{88.6f, 173.4f, 114.1f, 111.1f, 108.5f, 138.4f, 143.8f, 60.1f, 153.2f, 166.7f, 166.7f, 168.6f, 162.9f, 189.9f, 112.7f, 89.0f, 116.1f, 227.8f, 193.6f, 140.0f};
    static final float[] Solubility = new float[]{16.65f, 15.0f, 3.53f, 0.778f, 99.0f, 0.864f, 2.5f, 24.99f, 4.19f, 4.117f, 2.426f, 99.0f, 3.381f, 2.965f, 162.3f, 5.023f, 99.0f, 1.136f, 0.0453f, 8.85f};
    static final float[] Density = new float[]{1.401f, 1.1f, 1.54f, 1.66f, 0.0f, 1.46f, 0.0f, 1.607f, 0.0f, 0.0f, 1.191f, 0.0f, 1.34f, 0.0f, 0.0f, 1.537f, 0.0f, 0.0f, 1.456f, 1.23f};
    static final int[] R_group_charge = new int[]{0, 1, 0, -1, 0, -1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] R_group_polarity = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0};
    static final int[] Polarity_of_R_group_Int = new int[]{0, 1, 0, -1, 0, -1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    static final boolean[] Essential = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, true, true, true, true};
    static final boolean[] Sulfur_Containing = new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false};
    static final boolean[] Amidic = new boolean[]{false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final boolean[] Hydroxylic = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false};
    static final boolean[] Hydrophobic = new boolean[]{true, false, false, false, false, false, false, true, false, true, true, false, true, true, true, false, false, true, true, true};
    static final boolean[] Aliphatic = new boolean[]{true, false, false, false, false, false, false, true, false, true, true, false, true, false, true, false, false, false, false, true};
    static final boolean[] Aromatic = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, false};
    static final boolean[] Polar_uncharged = new boolean[]{false, false, true, false, true, false, true, false, false, false, false, false, false, false, false, true, true, false, false, false};
    static final boolean[] Acidic = new boolean[]{false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final boolean[] Basic = new boolean[]{false, true, false, false, false, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false};
    public Color color = null;
    protected String name;
    protected String abbr3;
    public char abbr1;
    protected String molecular_formula;
    protected String residue_formula;
    protected String polarity_of_r_group;
    protected float mwt;
    protected float residue_weight;
    protected float pkaC;
    protected float pkbN;
    protected float pkxR;
    protected float pI;
    protected float surface;
    protected float volume;
    protected float solubility;
    protected float density;
    protected int r_group_charge;
    protected int r_group_polarity;
    protected boolean essential;
    protected boolean sulfur_containing;
    protected boolean amidic;
    protected boolean hydroxylic;
    protected boolean hydrophobic;
    protected boolean aliphatic;
    protected boolean aromatic;
    protected boolean polar_uncharged;
    protected boolean acidic;
    protected boolean basic;

    public AminoAcid() {
    }

    public AminoAcid(char aa, String AAA) {
        this.abbr1 = aa;
        this.abbr3 = AAA;
    }

    public static String AAtoRegex(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return "";
        }
        char[] seq = sequence.toUpperCase().toCharArray();
        StringBuilder outString = new StringBuilder();
        block4: for (int x = 0; x < seq.length; ++x) {
            switch (seq[x]) {
                case '-': {
                    outString.append(".*");
                    continue block4;
                }
                case 'X': {
                    outString.append(".");
                    continue block4;
                }
                default: {
                    outString.append(seq[x]);
                }
            }
        }
        return outString.toString();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbr3() {
        return this.abbr3;
    }

    public char getAbbr1() {
        return this.abbr1;
    }

    public String getMolecular_formula() {
        return this.molecular_formula;
    }

    public String getResidue_formula() {
        return this.residue_formula;
    }

    public String getPolarity_of_r_group() {
        return this.polarity_of_r_group;
    }

    public float getMwt() {
        return this.mwt;
    }

    public float getResidue_weight() {
        return this.residue_weight;
    }

    public float getPkaC() {
        return this.pkaC;
    }

    public float getPkbN() {
        return this.pkbN;
    }

    public float getPkxR() {
        return this.pkxR;
    }

    public float getpI() {
        return this.pI;
    }

    public float getSurface() {
        return this.surface;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getSolubility() {
        return this.solubility;
    }

    public float getDensity() {
        return this.density;
    }

    public int getR_group_charge() {
        return this.r_group_charge;
    }

    public int getR_group_polarity() {
        return this.r_group_polarity;
    }

    public boolean isEssential() {
        return this.essential;
    }

    public boolean isSulfur_containing() {
        return this.sulfur_containing;
    }

    public boolean isAmidic() {
        return this.amidic;
    }

    public boolean isHydroxylic() {
        return this.hydroxylic;
    }

    public boolean isHydrophobic() {
        return this.hydrophobic;
    }

    public boolean isAliphatic() {
        return this.aliphatic;
    }

    public boolean isAromatic() {
        return this.aromatic;
    }

    public boolean isHydrophillic() {
        return !this.hydrophobic;
    }

    public boolean isPolar_uncharged() {
        return this.polar_uncharged;
    }

    public boolean isAcidic() {
        return this.acidic;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public static enum Properties {
        None,
        Mwt,
        Residue_Weight,
        PKa,
        PKb,
        PKx,
        PI,
        Surface,
        Volume,
        Solubility,
        Density,
        R_group_charge,
        R_group_polarity,
        Essential,
        Sulfur_Containing,
        Amidic,
        Hydroxylic,
        Hydrophobic,
        Aliphatic,
        Aromatic,
        Polar_uncharged,
        Acidic,
        Basic;

    }
}

