/*
 * Decompiled with CFR 0.152.
 */
package Plugins;

import Plugins.PluginConstants;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class PluginsObject
implements PluginConstants {
    private String name;
    private String description;
    private String version;
    private String author;
    private ImageIcon icon;
    private final HashMap<String, Object> properties = new HashMap();
    public static final ImageIcon defaultIcon = new ImageIcon(PluginsObject.class.getResource("/icons/plugin.png"));

    protected String getDefaultName() {
        return "Generic Name";
    }

    protected String getDefaultVersion() {
        return "1.0.0";
    }

    protected String getDefaultAuthor() {
        return "Unknown";
    }

    public final String getName() {
        return this.name != null && this.name.length() > 0 ? this.name : this.getDefaultName();
    }

    public final String getDescription() {
        return this.description != null ? this.description : "";
    }

    public final String getVersion() {
        return this.version != null && this.version.length() > 0 ? this.version : this.getDefaultVersion();
    }

    public final String getAuthor() {
        return this.author != null && this.author.length() > 0 ? this.author : this.getDefaultAuthor();
    }

    public final ImageIcon getIcon() {
        return this.icon;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public final void setDescription(String description) {
        if (description != null) {
            this.description = description.trim();
        }
    }

    public final void setVersion(String version) {
        if (version != null) {
            this.version = version.trim();
        }
    }

    public void setAuthor(String author) {
        if (author != null) {
            this.author = author.trim();
        }
    }

    public final void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public final void setIcon(String iconPath) {
        if (iconPath != null && iconPath.length() > 0) {
            this.icon = this.loadIcon(iconPath, defaultIcon);
        }
    }

    protected final ImageIcon loadIcon(String iconPath) {
        return this.loadIcon(iconPath, null);
    }

    protected final ImageIcon loadIcon(String iconPath, ImageIcon defaultIcon) {
        if (iconPath == null || iconPath.length() == 0) {
            return defaultIcon;
        }
        try {
            ImageIcon newIcon = new ImageIcon(this.getClass().getResource(iconPath));
            return newIcon;
        }
        catch (Exception ex) {
            return defaultIcon;
        }
    }

    public final Object getProperty(String key) {
        return key != null && key.length() > 0 ? this.properties.get(key.toLowerCase()) : null;
    }

    public final String getProperty(String key, String defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof String) {
            return (String)o;
        }
        return String.valueOf(o);
    }

    public final boolean getProperty(String key, boolean defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    public final int getProperty(String key, int defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return defaultValue;
    }

    public final float getProperty(String key, float defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return defaultValue;
    }

    public final long getProperty(String key, long defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof Long) {
            return (Long)o;
        }
        return defaultValue;
    }

    public final Icon getProperty(String key, Icon defaultValue) {
        if (key == null || key.length() == 0) {
            return defaultValue;
        }
        Object o = this.properties.get(key.toLowerCase());
        if (o instanceof Icon) {
            return (Icon)o;
        }
        return defaultValue;
    }

    public final void setProperty(String key, Object value) {
        if (key == null || key.length() == 0 || value == null) {
            return;
        }
        this.properties.put(key.toLowerCase(), value);
    }

    public final Object removeProperty(String key) {
        return key != null && key.length() > 0 ? this.properties.remove(key.toLowerCase()) : null;
    }

    public final void clearProperties() {
        this.properties.clear();
    }
}

