/*
 * Decompiled with CFR 0.152.
 */
package Plugins;

import Plugins.Plugin;
import Plugins.PluginCollection;
import Plugins.PluginLoader;
import Plugins.PluginMenu;
import Plugins.PluginsObject;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class PluginPackage
extends PluginCollection {
    public static ImageIcon defaultIcon = new ImageIcon(PluginPackage.class.getResource("/icons/plugin.png"));
    private static final String DEFAULT_NAME = "Plugins Collection";
    Vector<PluginCollection> collections = new Vector();

    @Override
    protected String getDefaultName() {
        return DEFAULT_NAME;
    }

    public PluginPackage() {
    }

    public PluginPackage(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    public PluginPackage(String name, String author) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
    }

    public PluginPackage(String name, String author, String version) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
    }

    public PluginPackage(String name, String author, String version, String description) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public PluginPackage(String name, String author, String version, String description, ImageIcon icon) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    @Override
    public final JMenu getMenu() {
        return this.getMenu(null);
    }

    @Override
    public final JMenu getMenu(MouseListener l) {
        PluginMenu m = new PluginMenu(this);
        if (l != null) {
            m.addMouseListener(l);
        }
        for (PluginsObject item : this.collections) {
            m.add(item.getMenu(l));
        }
        for (PluginsObject item : this.plugins) {
            m.add(PluginLoader.menuItemFor((Plugin)item, l));
        }
        return m;
    }

    public void addCollection(PluginCollection item) {
        this.collections.add(item);
    }

    public void removeCollection(PluginCollection item) {
        this.collections.remove(item);
    }

    public int getAllPluginCount() {
        int count = this.plugins.size();
        for (PluginCollection c : this.collections) {
            count += c.plugins.size();
        }
        return count;
    }

    public ArrayList<Plugin> getAllPlugins() {
        ArrayList<Plugin> outArray = new ArrayList<Plugin>();
        this.getAllPlugins(outArray);
        return outArray;
    }

    private void getAllPlugins(ArrayList<Plugin> outArray) {
        for (Plugin p : this.plugins) {
            outArray.add(p);
        }
        for (PluginCollection c : this.collections) {
            c.getPlugins(outArray);
        }
    }

    public int getCollectionCount() {
        return this.collections.size();
    }

    public final PluginCollection[] getCollections() {
        if (this.collections.isEmpty()) {
            return null;
        }
        PluginCollection[] outArray = new PluginCollection[this.collections.size()];
        return this.collections.toArray(outArray);
    }
}

