/*
 * Decompiled with CFR 0.152.
 */
package Plugins;

import Plugins.Plugin;
import Plugins.PluginLoader;
import Plugins.PluginMenu;
import Plugins.PluginsObject;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class PluginCollection
extends PluginsObject {
    private static final String DEFAULT_NAME = "Plugins";
    public static final ImageIcon defaultPackageIcon = new ImageIcon(Plugin.class.getResource("/icons/plugin.png"));
    Vector<Plugin> plugins = new Vector();

    public void addPlugin(Plugin item) {
        this.plugins.add(item);
    }

    public void removePlugin(Plugin item) {
        this.plugins.remove(item);
    }

    public int getPluginCount() {
        return this.plugins.size();
    }

    public boolean isEmpty() {
        return this.getPluginCount() == 0;
    }

    public JMenu getMenu() {
        return this.getMenu(null);
    }

    public JMenu getMenu(MouseListener l) {
        PluginMenu m = new PluginMenu(this);
        if (l != null) {
            m.addMouseListener(l);
        }
        for (Plugin item : this.plugins) {
            m.add(PluginLoader.menuItemFor(item, l));
        }
        return m;
    }

    public final Plugin[] getPlugins() {
        if (this.plugins.isEmpty()) {
            return null;
        }
        Plugin[] outArray = new Plugin[this.plugins.size()];
        return this.plugins.toArray(outArray);
    }

    void getPlugins(ArrayList<Plugin> outArray) {
        for (Plugin p : this.plugins) {
            outArray.add(p);
        }
    }

    public final Plugin[] getPluginsWith(String propertyKey, Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        Vector<Plugin> found = new Vector<Plugin>();
        for (Plugin item : this.plugins) {
            Object val = item.getProperty(propertyKey);
            if (val == null || !propertyValue.equals(val)) continue;
            found.add(item);
        }
        Plugin[] outArray = new Plugin[found.size()];
        return found.toArray(outArray);
    }

    @Override
    protected String getDefaultName() {
        return DEFAULT_NAME;
    }

    public PluginCollection() {
    }

    public PluginCollection(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    public PluginCollection(String name, String author) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
    }

    public PluginCollection(String name, String author, String version) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
    }

    public PluginCollection(String name, String author, String version, String description) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public PluginCollection(String name, String author, String version, String description, ImageIcon icon) {
        if (name != null) {
            this.setName(name);
        }
        if (author != null) {
            this.setAuthor(author);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public String toString() {
        return this.getName() + " version " + this.getVersion();
    }
}

