/*
 * Decompiled with CFR 0.152.
 */
package MouseMenuListeners;

import ScrollPanels.StatusLabel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class Listeners {
    public static boolean setMenuItemListeners(JMenu parentMenu, MouseListener listener) {
        Component[] items;
        if (parentMenu == null) {
            return false;
        }
        for (Component item : items = parentMenu.getMenuComponents()) {
            try {
                if (item instanceof JMenu) {
                    item.addMouseListener(listener);
                    Listeners.setMenuItemListeners((JMenu)item, listener);
                    continue;
                }
                if (item instanceof JMenuItem || item instanceof JSeparator) {
                    item.addMouseListener(listener);
                    continue;
                }
                if (!(item instanceof JComponent)) continue;
                item.addMouseListener(listener);
            }
            catch (Exception e) {
                System.out.println("Error: " + e.toString());
            }
        }
        return true;
    }

    public static boolean setMenuItemListeners(JPopupMenu menu, MouseListener listener) {
        for (int x = 0; x < menu.getComponentCount(); ++x) {
            Component item = menu.getComponent(x);
            if (item instanceof JMenu) {
                item.addMouseListener(listener);
                Listeners.setMenuItemListeners((JMenu)item, listener);
                continue;
            }
            if (item instanceof JMenuItem) {
                item.addMouseListener(listener);
                continue;
            }
            if (!(item instanceof JSeparator)) continue;
            item.addMouseListener(listener);
        }
        return true;
    }

    public static boolean setMenuBarListeners(JMenuBar menuBar, MouseListener listener) {
        for (int x = menuBar.getMenuCount() - 1; x >= 0; --x) {
            JMenu item = menuBar.getMenu(x);
            item.addMouseListener(listener);
            Listeners.setMenuItemListeners(item, listener);
        }
        return true;
    }

    public static boolean setToolbarListeners(JToolBar toolBar, MouseListener listener) {
        for (int x = toolBar.getComponentCount() - 1; x >= 0; --x) {
            Component item = toolBar.getComponent(x);
            if (!(item instanceof JButton) && !(item instanceof JToggleButton)) continue;
            item.addMouseListener(listener);
        }
        return true;
    }

    public static boolean setJComponentListeners(JComponent component, MouseListener listener) {
        for (int x = component.getComponentCount() - 1; x >= 0; --x) {
            if (!(component.getComponent(x) instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component.getComponent(x);
            if (jComponent.getToolTipText() != null && jComponent.getToolTipText().length() > 0) {
                jComponent.addMouseListener(listener);
            }
            Listeners.setJComponentListeners(jComponent, listener);
        }
        return true;
    }

    public static MouseListener genMouseListener(JLabel outputLabel) {
        return Listeners.genMouseListener(outputLabel, 3000, true, "");
    }

    public static MouseListener genMouseListener(StatusLabel outputLabel) {
        return Listeners.genMouseListener(outputLabel, 3000, true, "");
    }

    public static MouseListener genMouseListener(JLabel outputLabel, boolean hideToolTipPopup) {
        return Listeners.genMouseListener(outputLabel, 3000, hideToolTipPopup, "");
    }

    public static MouseListener genMouseListener(JLabel outputLabel, boolean hideToolTipPopup, String defaultOutText) {
        return Listeners.genMouseListener(outputLabel, 3000, hideToolTipPopup, defaultOutText);
    }

    public static MouseListener genMouseListener(final JLabel outputLabel, final int timeMS, final boolean hideToolTipPopup, final String defaultOutText) {
        MouseListener menuMouseListener = new MouseListener(){
            int time;
            String defaultText;
            String cText;
            boolean disableToolTips;
            JLabel targetLabel;
            Timer labelTimer;
            {
                this.time = timeMS;
                this.defaultText = defaultOutText;
                this.disableToolTips = hideToolTipPopup;
                this.targetLabel = outputLabel;
                this.labelTimer = null;
            }

            private void setStatusMessage() {
                if (this.labelTimer != null) {
                    this.labelTimer.stop();
                    this.labelTimer = null;
                }
                if (this.cText != null && this.cText.length() > 0) {
                    this.targetLabel.setText(this.cText);
                    this.labelTimer = new Timer(this.time, e -> this.removeStatusMessage());
                    this.labelTimer.start();
                } else {
                    this.removeStatusMessage();
                }
            }

            private void removeStatusMessage() {
                if (this.labelTimer != null) {
                    this.labelTimer.stop();
                    this.labelTimer = null;
                }
                String targetLabelText = this.targetLabel.getText();
                if (this.cText != null && targetLabelText != null && this.cText.equals(targetLabelText)) {
                    this.cText = null;
                    if (this.defaultText != null) {
                        this.targetLabel.setText(this.defaultText);
                    } else {
                        this.targetLabel.setText("");
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolTipManager.sharedInstance().setEnabled(false);
                Component g = arg0.getComponent();
                if (g instanceof JComponent) {
                    this.cText = ((JComponent)g).getToolTipText();
                    if (this.cText != null && this.cText.length() > 0) {
                        this.setStatusMessage();
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                this.removeStatusMessage();
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        };
        return menuMouseListener;
    }

    public static MouseListener genMouseListener(final StatusLabel outputLabel, final int timeMS, final boolean hideToolTipPopup, String defaultOutText) {
        MouseListener menuMouseListener = new MouseListener(){
            boolean disableToolTips;
            StatusLabel targetLabel;
            {
                this.disableToolTips = hideToolTipPopup;
                this.targetLabel = outputLabel;
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolTipManager.sharedInstance().setEnabled(false);
                Component g = arg0.getComponent();
                if (g instanceof JComponent) {
                    String cText = ((JComponent)g).getToolTipText();
                    if (cText != null && cText.length() > 0) {
                        this.targetLabel.setText(cText, timeMS);
                    } else {
                        this.targetLabel.setText("");
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                this.targetLabel.setText("");
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        };
        return menuMouseListener;
    }
}

