/*
 * Decompiled with CFR 0.152.
 */
package MiscTools;

import Encoders.Ascii85;
import Encoders.mHuffman;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTools {
    public static final int RTF = 1;
    public static final int HUFFMAN = 2;
    public static final int HUFFMAN85 = 3;
    public static final int RTF85 = 4;
    public static final int ASCII85 = 5;
    public static final int UNDEFINED = 6;
    public static final int EMPTYSTRING = 7;
    public static final int NULL = 99;
    public static String error = "";
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter dateFormat2 = DateTimeFormatter.ofPattern("yyyyMMdd");
    static Pattern NotePattern = Pattern.compile("(?<first>(-{0,1}\\d+))\\s*-\\s*(?<last>(-{0,1}\\d+))");

    public static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public static String repeat(String string, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return string;
        }
        byte[] value = string.getBytes();
        int coder = 0;
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, coder);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, coder);
    }

    public static String getDecodedData(String encodedData) {
        int dataType = StringTools.getStringType(encodedData);
        switch (dataType) {
            case 5: {
                return Ascii85.decode(encodedData);
            }
            case 4: {
                return Ascii85.decode(encodedData);
            }
            case 3: {
                return mHuffman.decodeToString(Ascii85.decodeToBytes(encodedData));
            }
            case 2: {
                return mHuffman.decodeToString(Ascii85.decode(encodedData));
            }
            case 99: {
                return null;
            }
        }
        return encodedData;
    }

    public static int getStringType(String string) {
        if (string == null) {
            return 99;
        }
        if (string.length() == 0) {
            return 7;
        }
        if (string.startsWith("{\\rtf")) {
            return 1;
        }
        if (string.startsWith("HE3")) {
            return 2;
        }
        if (string.startsWith("<~84>") || string.startsWith("84>")) {
            return 3;
        }
        if (string.startsWith("HX(T5A") || string.startsWith("<~HX(T5A")) {
            return 4;
        }
        if (string.startsWith("<~") && string.endsWith("~>")) {
            return 5;
        }
        return 6;
    }

    public static String bytesToStringUTFCustom(byte[] bytes) {
        return new String(StringTools.bytesToCharUTFCustom(bytes));
    }

    public static char[] bytesToCharUTFCustom(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
        }
        return buffer;
    }

    public static char[] bytesToCharASCII(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (char)(bytes[i << 1] & 0xFF);
        }
        return buffer;
    }

    public static byte[] stringToBytesUTFNIO(String str) {
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length << 1];
        CharBuffer cBuffer = ByteBuffer.wrap(b).asCharBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            cBuffer.put(buffer[i]);
        }
        return b;
    }

    public static String bytesToStringUTFNIO(byte[] bytes) {
        CharBuffer cBuffer = ByteBuffer.wrap(bytes).asCharBuffer();
        return cBuffer.toString();
    }

    public static byte[] stringToBytesUTFCustom(String str) {
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length << 1];
        for (int i = 0; i < buffer.length; ++i) {
            int bpos = i << 1;
            b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(buffer[i] & 0xFF);
        }
        return b;
    }

    public static byte[] stringToBytesASCII(String str) {
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)buffer[i];
        }
        return b;
    }

    public static byte[] LoadFileBytes(File file) {
        error = "";
        if (!file.isFile() || !file.exists()) {
            error = "Invalid file selected";
            return null;
        }
        try {
            RandomAccessFile inStream = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)file.length()];
            inStream.seek(0L);
            inStream.read(bytes);
            inStream.close();
            return bytes;
        }
        catch (FileNotFoundException ex) {
            error = "Error opening file stream.";
            return null;
        }
        catch (IOException ex) {
            error = ex.getLocalizedMessage();
            return null;
        }
    }

    public static String loadFileAsString(File file) {
        error = "";
        if (!file.isFile() || !file.exists()) {
            error = "Invalid file selected";
            return null;
        }
        try {
            RandomAccessFile inStream = new RandomAccessFile(file, "r");
            inStream.seek(0L);
            String outString = inStream.readUTF();
            inStream.close();
            return outString;
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
    }

    public static String loadFileAsUTF8(File file) {
        error = "";
        if (!file.exists()) {
            error = "File does not exist";
            return null;
        }
        if (!file.isFile()) {
            error = "Specified path is not a file";
            return null;
        }
        if (!file.canRead()) {
            error = "Specified file does not have read access";
            return null;
        }
        try {
            String string = Files.readString(file.toPath(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException ex) {
            error = ex.getLocalizedMessage();
            return null;
        }
    }

    public static String RTrim(String inputString) {
        return inputString.replaceFirst("\\s+$", "");
    }

    public static String RTrim2(String inputString) {
        return inputString.replaceFirst("[\\s\\t\\n\\r]+$", "");
    }

    public static String getFormattedDate() {
        return dateFormat.format(LocalDate.now());
    }

    public static String getFormattedTime() {
        return timeFormat.format(LocalTime.now());
    }

    public static String getFormattedDateTimeTag() {
        return dateFormat2.format(LocalDate.now()) + StringTools.getFormattedTime().replaceAll(":", "");
    }

    public static String ColorToHex(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static int filterStringToInt(String number) {
        return StringTools.filterStringToInt(number, 0);
    }

    public static int filterStringToInt(String number, int defaultErrNum) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        try {
            int outInt = Integer.parseInt(number);
            return outInt;
        }
        catch (NumberFormatException e) {
            return defaultErrNum;
        }
    }

    public static int filterStringToInt(String number, int minVal, int maxVal, int defaultErrNum) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        try {
            int outInt = Integer.parseInt(number);
            return outInt >= minVal && outInt <= maxVal ? outInt : defaultErrNum;
        }
        catch (NumberFormatException e) {
            return defaultErrNum;
        }
    }

    public static int filterStringToInt(String number, int minVal, int maxVal, int defaultErrNum, int defaultMinVal, int defaultMaxVal) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        try {
            int outInt = Integer.parseInt(number);
            if (outInt < minVal) {
                outInt = defaultMinVal;
            } else if (outInt > maxVal) {
                outInt = defaultMaxVal;
            }
            return outInt;
        }
        catch (NumberFormatException e) {
            return defaultErrNum;
        }
    }

    public static float filterStringToFloat(String number, float defaultErrNum) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        try {
            float val = Float.parseFloat(number);
            return val;
        }
        catch (NumberFormatException e) {
            return defaultErrNum;
        }
    }

    public static double filterStringToDouble(String number, double defaultErrNum) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        try {
            double val = Double.parseDouble(number);
            return val;
        }
        catch (NumberFormatException e) {
            return defaultErrNum;
        }
    }

    public static Integer[] parseRange(String rangeString) {
        String[] ranges;
        ArrayList<Integer> outInts = new ArrayList<Integer>();
        if (rangeString == null || rangeString.length() == 0) {
            return null;
        }
        for (String string : ranges = rangeString.split(",")) {
            Matcher matcher = NotePattern.matcher(string);
            if (matcher.find()) {
                int first = Integer.parseInt(matcher.group("first"));
                int last = Integer.parseInt(matcher.group("last"));
                int firstPos = Math.min(first, last);
                int lastPos = Math.max(first, last);
                for (int x = firstPos; x <= lastPos; ++x) {
                    outInts.add(x);
                }
                continue;
            }
            int pos = StringTools.filterStringToInt(string, 0);
            if (pos == 0) continue;
            outInts.add(pos);
        }
        Integer[] outArray = new Integer[outInts.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = (Integer)outInts.get(x);
        }
        return outArray;
    }

    public static String getBetween(String src, String borderL, String borderR) {
        return StringTools.getBetween(src, borderL, borderR, 0, false);
    }

    public static String getBetween(String src, String borderL, String borderR, int start) {
        return StringTools.getBetween(src, borderL, borderR, start, false);
    }

    public static String getBetween(String src, String borderL, String borderR, int start, boolean includeBorders) {
        int lStart = src.indexOf(borderL, start);
        if (lStart == -1) {
            return null;
        }
        int rStop = src.indexOf(borderR, lStart + borderL.length());
        if (rStop == -1) {
            return null;
        }
        if (includeBorders) {
            rStop += borderR.length();
        } else {
            lStart += borderL.length();
        }
        return src.substring(lStart, rStop);
    }

    public static boolean stringToBoolean(String val) {
        return val.toLowerCase().equals("true") || val.equals("1");
    }
}

