/*
 * Decompiled with CFR 0.152.
 */
package MiscTools;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Random;

public class ColorEx
extends Color {
    public ColorEx(int r, int g, int b) {
        super(r, g, b);
    }

    public ColorEx(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    public ColorEx(float r, float g, float b) {
        super(r, g, b);
    }

    public ColorEx(float r, float g, float b, float a) {
        super(r, g, b, a);
    }

    public ColorEx(int rgb) {
        super(rgb);
    }

    public ColorEx(int rgba, boolean hasalpha) {
        super(rgba, hasalpha);
    }

    public ColorEx(ColorSpace cspace, float[] components, float alpha) {
        super(cspace, components, alpha);
    }

    public int toInt() {
        return ColorEx.colorToInt(this);
    }

    public static Color fromInt(int col) {
        return ColorEx.fromInt(col, 255);
    }

    public static Color fromInt(int col, int alpha) {
        int r = col & 0xFF;
        int g = (col & 0xFF00) / 256;
        int b = (col & 0xFF0000) / 65536;
        return new Color(r, g, b, alpha);
    }

    public static int colorToInt(Color color) {
        return color.getRed() + color.getGreen() * 256 + color.getBlue() * 65536;
    }

    public static Color getForecolor(Color backcolor) {
        double r = (double)backcolor.getRed() / 255.0;
        double g = (double)backcolor.getGreen() / 255.0;
        double b = (double)backcolor.getBlue() / 255.0;
        r = r <= 0.03928 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b > 0.179 ? Color.black : Color.white;
    }

    public static Color random() {
        Random rand = new Random();
        return new Color(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
    }
}

