/*
 * Decompiled with CFR 0.152.
 */
package ListModels;

import BinaryTrees.BinaryChain;
import java.io.Serializable;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class UniqueComboModel<T>
extends AbstractListModel<T>
implements MutableComboBoxModel<T>,
Serializable {
    Object selectedObject;
    public final BinaryChain<T> items = new BinaryChain();

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.items.get(index);
    }

    public void add(T item, String key) {
        this.add(item, key, true);
    }

    public void add(T item, String key, boolean update) {
        if (!this.items.containsKey(key)) {
            this.items.add(item, key);
            int index = this.items.indexOf(item);
            if (update) {
                this.fireIntervalAdded(this, index, index);
            }
        }
    }

    public void add(T item) {
        this.add(item, item.toString(), true);
    }

    public void add(T item, boolean update) {
        this.add(item, item.toString(), update);
    }

    public boolean contains(String key) {
        return this.items.containsKey(key);
    }

    public void removeAllElements() {
        int size = this.items.size();
        if (size > 0) {
            this.items.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, 0, size - 1);
        } else {
            this.selectedObject = null;
        }
    }

    public void remove(String key) {
        T obj = this.items.get(key);
        if (obj != null) {
            int index = this.items.indexOf(obj);
            this.items.remove(key);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void sort(Comparator c) {
        this.sort(c, true);
    }

    public void sort(Comparator c, boolean update) {
        if (this.items.size() > 1) {
            this.items.sort(c);
            if (update) {
                this.fireContentsChanged(this, 0, this.items.size());
            }
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void addElement(T item) {
        if (this.items.add(item)) {
            int index = this.items.indexOf(item);
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElement(Object item) {
        this.removeElementAt(this.items.indexOf(item));
    }

    @Override
    public void insertElementAt(T item, int index) {
        if (this.items.insert(item, index)) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        if (this.items.remove(index)) {
            this.fireIntervalRemoved(this, index, index);
        }
    }
}

