/*
 * Decompiled with CFR 0.152.
 */
package LinkedArray;

public class LinkedArray {
    private static final int BUFFERSIZE = 100;
    private int bufferSize = 100;
    private int lastSIndex = this.bufferSize - 1;
    private int lastPIndex = this.bufferSize - 1;
    private int primaryIndex = 0;
    private int secondaryIndex = 0;
    private Storage[] primaryArray;

    public LinkedArray() {
        this.init();
    }

    public LinkedArray(int bufferSize) {
        this.bufferSize = bufferSize;
        this.init();
    }

    private void init() {
        this.primaryArray = new Storage[this.bufferSize];
        this.primaryArray[0] = new Storage(this.bufferSize);
        this.lastPIndex = this.lastSIndex = this.bufferSize - 1;
    }

    public void add(Object object) {
        this.incArray();
        this.primaryArray[this.primaryIndex].items[this.secondaryIndex] = object;
    }

    private void incArray() {
        ++this.secondaryIndex;
        if (this.secondaryIndex > this.lastSIndex) {
            this.incPrimary();
        }
    }

    private void incPrimary() {
        ++this.primaryIndex;
        this.secondaryIndex = 0;
        if (this.primaryIndex > this.lastPIndex) {
            int oldSize = this.primaryArray.length;
            int newSize = this.primaryArray.length + this.bufferSize;
            Object[][] newArray = new Object[newSize][this.bufferSize];
            System.arraycopy(this.primaryArray, 0, newArray, 0, oldSize);
        }
        this.primaryArray[this.primaryIndex] = new Storage(this.bufferSize);
    }

    public int size() {
        return this.primaryIndex * this.bufferSize + this.secondaryIndex + 1;
    }

    private class Storage {
        Object[] items;

        public Storage(int bufferSize) {
            this.items = new Object[bufferSize];
        }
    }
}

