/*
 * Decompiled with CFR 0.152.
 */
package JXTableEditorsAndRenderers;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class TextAreaCellEditor
implements TableCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    private final JScrollPane scrollPane;
    private JTextArea textArea = new JTextArea();

    public TextAreaCellEditor() {
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.textArea.setLineWrap(true);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textArea.setFont(table.getFont());
        this.textArea.setText(value != null ? value.toString() : "");
        if (isSelected) {
            this.textArea.setBackground(table.getSelectionBackground());
            this.textArea.setForeground(table.getSelectionForeground());
        } else {
            this.textArea.setBackground(table.getBackground());
            this.textArea.setForeground(table.getForeground());
        }
        return this.scrollPane;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners;
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof CellEditorListener)) continue;
            ((CellEditorListener)listener).editingStopped(new ChangeEvent(this));
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners;
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof CellEditorListener)) continue;
            ((CellEditorListener)listener).editingCanceled(new ChangeEvent(this));
        }
    }
}

