/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.DocumentWikiModel;
import JMWiki.JWikiPane;
import JMWiki.WikiDocument;
import JMWiki.WikiEvent;
import JMWiki.WikiPage;
import JMWiki.WikiPaneListener;
import JMWiki.XMLDocument;
import JMWiki.XMLElement;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class WikiEditor
extends JFrame
implements ActionListener,
WikiPaneListener {
    private WikiDocument wikiDoc = new WikiDocument();
    private HTMLDocument document;
    private boolean debug = false;
    private File currentFile;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final Action cutAction = new DefaultEditorKit.CutAction();
    private final Action copyAction = new DefaultEditorKit.CopyAction();
    private final Action pasteAction = new DefaultEditorKit.PasteAction();
    private final Action boldAction = new StyledEditorKit.BoldAction();
    private final Action underlineAction = new StyledEditorKit.UnderlineAction();
    private final Action italicAction = new StyledEditorKit.ItalicAction();
    private final Action insertBreakAction = new DefaultEditorKit.InsertBreakAction();
    private final HTMLEditorKit.InsertHTMLTextAction unorderedListAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<ul><li> </li></ul>", HTML.Tag.P, HTML.Tag.UL);
    private final HTMLEditorKit.InsertHTMLTextAction bulletAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<li> </li>", HTML.Tag.UL, HTML.Tag.LI);
    WikiPageListModel listModel;
    private WikiPage activePage = null;
    private JMenu alignMenu;
    private JMenuItem blackTextItem;
    private JMenuItem blueTextItem;
    private JMenuItem boldMenuItem;
    private JMenuItem bulletItem;
    private JMenuItem centerMenuItem;
    private JMenuItem clearItem;
    private JButton cmdBack;
    private JButton cmdFwd;
    private JButton cmdHome;
    private JMenu colorMenu;
    private JMenuItem copyItem;
    private JMenuItem cutItem;
    private JMenuItem cyanTextItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fontMenu;
    private JMenuItem greenTextItem;
    private JMenuItem insertBreaKItem;
    private JMenuItem italicMenuItem;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JSplitPane jSplitPane1;
    private JMenuItem leftAlignMenuItem;
    private JList<WikiPage> lstPages;
    private JMenuItem magentaTextItem;
    private JMenuItem mnuDialog;
    private JMenuItem mnuDialogInput;
    private JMenu mnuFontSize;
    private JMenu mnuFontType;
    private JMenu mnuHelp;
    private JMenuItem mnuLink;
    private JMenuItem mnuMonospaced;
    private JCheckBoxMenuItem mnuPreview;
    private JMenuItem mnuSansSerif;
    private JMenuItem mnuSerif;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem orangeTextItem;
    private JMenuItem pasteItem;
    private JMenuItem redTextItem;
    private JMenuItem redoItem;
    private JMenuItem rightAlignMenuItem;
    private JMenuItem saveAsItem;
    private JMenuItem saveItem;
    private JMenuItem selectAllItem;
    private JMenuItem strikeThroughMenuItem;
    private JMenu styleMenu;
    private JMenuItem subscriptMenuItem;
    private JMenuItem superscriptMenuItem;
    private JToolBar toolbarMain;
    private JMenuItem underlineMenuItem;
    private JMenuItem undoItem;
    private JMenuItem unorderedListItem;
    private JWikiPane wikiPane;
    private JMenuItem yellowTextItem;

    public WikiEditor() {
        this.initComponents();
        this.toolbarMain.setFloatable(false);
        this.wikiPane.setEditable(true);
        this.wikiPane.setListener(this);
        this.listModel = new WikiPageListModel();
        this.lstPages.setModel(this.listModel);
        this.setTitle("Wiki Document Editor");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.document = (HTMLDocument)editorKit.createDefaultDocument();
        this.initMenus();
        this.document.addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
        this.wikiPane.setContentType("text/html");
        this.setLocationRelativeTo(null);
        this.startNewWiki();
    }

    private void initMenus() {
        this.newItem.addActionListener(this);
        this.openItem.addActionListener(this);
        this.saveItem.addActionListener(this);
        this.saveAsItem.addActionListener(this);
        this.exitItem.addActionListener(this);
        this.undoItem.addActionListener(this.undoAction);
        this.redoItem.addActionListener(this.redoAction);
        this.cutItem.addActionListener(this.cutAction);
        this.copyItem.addActionListener(this.copyAction);
        this.pasteItem.addActionListener(this.pasteAction);
        this.insertBreaKItem.addActionListener(this.insertBreakAction);
        this.unorderedListItem.addActionListener(this.unorderedListAction);
        this.bulletItem.addActionListener(this.bulletAction);
        this.clearItem.addActionListener(this);
        this.selectAllItem.addActionListener(this);
        this.redTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Red", Color.red));
        this.orangeTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Orange", Color.orange));
        this.yellowTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Yellow", Color.yellow));
        this.greenTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Green", Color.green));
        this.blueTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Blue", Color.blue));
        this.cyanTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Cyan", Color.cyan));
        this.magentaTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Magenta", Color.magenta));
        this.blackTextItem.addActionListener(new StyledEditorKit.ForegroundAction("Black", Color.black));
        this.setAction(this.mnuSansSerif, new StyledEditorKit.FontFamilyAction("SansSerif", "SansSerif"));
        this.setAction(this.mnuSerif, new StyledEditorKit.FontFamilyAction("Serif", "Serif"));
        this.setAction(this.mnuMonospaced, new StyledEditorKit.FontFamilyAction("Monospaced", "Monospaced"));
        this.setAction(this.mnuDialog, new StyledEditorKit.FontFamilyAction("Dialog", "Dialog"));
        this.setAction(this.mnuDialogInput, new StyledEditorKit.FontFamilyAction("DialogInput", "DialogInput"));
        int[] fontSizes = new int[]{6, 8, 10, 12, 14, 16, 20, 24, 32, 36, 48, 72};
        for (int i = 0; i < fontSizes.length; ++i) {
            if (this.debug) {
                System.out.println(fontSizes[i]);
            }
            JMenuItem nextSizeItem = new JMenuItem(String.valueOf(fontSizes[i]));
            nextSizeItem.setAction(new StyledEditorKit.FontSizeAction(String.valueOf(fontSizes[i]), fontSizes[i]));
            this.mnuFontSize.add(nextSizeItem);
        }
        this.setAction(this.boldMenuItem, this.boldAction);
        this.setAction(this.underlineMenuItem, this.underlineAction);
        this.setAction(this.italicMenuItem, this.italicAction);
        this.setAction(this.subscriptMenuItem, new SubscriptAction());
        this.setAction(this.superscriptMenuItem, new SuperscriptAction());
        this.setAction(this.strikeThroughMenuItem, new StrikeThroughAction());
        this.setAction(this.leftAlignMenuItem, new StyledEditorKit.AlignmentAction("Left Align", 0));
        this.setAction(this.centerMenuItem, new StyledEditorKit.AlignmentAction("Center", 1));
        this.setAction(this.rightAlignMenuItem, new StyledEditorKit.AlignmentAction("Right Align", 2));
        JMenuItem helpItem = new JMenuItem("Help");
        helpItem.addActionListener(this);
        this.mnuHelp.add(helpItem);
        JMenuItem shortcutsItem = new JMenuItem("Keyboard Shortcuts");
        shortcutsItem.addActionListener(this);
        this.mnuHelp.add(shortcutsItem);
        JMenuItem aboutItem = new JMenuItem("About QuantumHyperSpace");
        aboutItem.addActionListener(this);
        this.mnuHelp.add(aboutItem);
    }

    private void setAction(JMenuItem item, Action action) {
        String caption = item.getText();
        KeyStroke accel = item.getAccelerator();
        item.setAction(action);
        item.setText(caption);
        item.setAccelerator(accel);
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public void startNewWiki() {
        Document oldDoc = this.wikiPane.getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.document = (HTMLDocument)editorKit.createDefaultDocument();
        this.wikiPane.setDocument(this.document);
        WikiPage startPage = new WikiPage("home", "Home Page", this.wikiPane.getText());
        this.listModel.clear();
        this.listModel.addElement(startPage);
        this.setActivePage(startPage);
        this.currentFile = null;
        this.wikiPane.getDocument().addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
    }

    public void openDocument() {
        File current = new File(".");
        JFileChooser chooser = new JFileChooser(current);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new WikiFileFilter(this));
        int approval = chooser.showSaveDialog(this);
        if (approval == 0) {
            XMLDocument doc = XMLDocument.loadXML(chooser.getSelectedFile());
            if (doc == null) {
                System.out.println("doc == null");
                return;
            }
            XMLElement root = doc.getRoot();
            XMLElement xmlDoc = root.getElement("Document");
            if (xmlDoc == null) {
                System.out.println("Document Element == null");
                return;
            }
            this.listModel.clear();
            this.wikiDoc = new WikiDocument();
            this.wikiDoc.title = xmlDoc.getAttribute("title", "");
            DocumentWikiModel wikiModel = this.wikiPane.getModel();
            wikiModel.setDocument(this.wikiDoc);
            for (XMLElement elem : xmlDoc.elements) {
                if (elem.name.equalsIgnoreCase("description")) {
                    this.wikiDoc.description = elem.body;
                    continue;
                }
                if (!elem.name.equalsIgnoreCase("page")) continue;
                String id = elem.getAttribute("id", "default");
                String title = elem.getAttribute("title", "default");
                WikiPage newPage = new WikiPage(id, title, elem.body);
                this.listModel.addElement(newPage);
                if (elem.getAttribute("homepage", "").length() > 0) {
                    wikiModel.setHomePage(newPage);
                }
                if (elem.getAttribute("errorpage", "").length() <= 0) continue;
                wikiModel.setErrorPage(newPage);
            }
            this.currentFile = chooser.getSelectedFile();
            this.setTitle(this.currentFile.getName());
            Document oldDoc = this.wikiPane.getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(this.undoHandler);
            }
            HTMLEditorKit editorKit = new HTMLEditorKit();
            this.document = (HTMLDocument)editorKit.createDefaultDocument();
            this.document.addUndoableEditListener(this.undoHandler);
            this.wikiPane.setDocument(this.document);
            this.goHome();
            this.resetUndoManager();
        }
    }

    public void saveDocument() {
        if (this.currentFile != null) {
            this.saveFile(this.currentFile);
        } else {
            this.saveDocumentAs();
        }
    }

    private void saveFile(File file) {
        if (this.activePage != null) {
            this.activePage.contents = this.wikiPane.getText();
        }
        this.wikiDoc.write(file);
    }

    public void saveDocumentAs() {
        File current = new File(".");
        JFileChooser chooser = new JFileChooser(current);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new WikiFileFilter(this));
        int approval = chooser.showSaveDialog(this);
        if (approval == 0) {
            File newFile = chooser.getSelectedFile();
            if (newFile.exists()) {
                String message = newFile.getAbsolutePath() + " already exists. \nDo you want to replace it?";
                if (JOptionPane.showConfirmDialog(this, message) == 0) {
                    this.currentFile = newFile;
                    this.saveFile(this.currentFile);
                    this.setTitle(this.currentFile.getName());
                    if (this.debug) {
                        System.out.println("Saved " + this.currentFile.getAbsolutePath());
                    }
                }
            } else {
                this.currentFile = new File(newFile.getAbsolutePath());
                this.saveFile(this.currentFile);
                this.setTitle(this.currentFile.getName());
                if (this.debug) {
                    System.out.println("Saved " + this.currentFile.getAbsolutePath());
                }
            }
        }
    }

    public void exit() {
        String exitMessage = "Are you sure you want to exit?";
        if (JOptionPane.showConfirmDialog(this, exitMessage) == 0) {
            System.exit(0);
        }
    }

    public void clear() {
        this.startNewWiki();
    }

    public void selectAll() {
        this.wikiPane.selectAll();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, "DocumentEditor.java\nAuthor: Charles Bell\nVersion: May 25, 2002\nhttp://www.quantumhyperspace.com\nQuantumHyperSpace Programming Services");
    }

    public void showShortcuts() {
        String shortcuts = "Navigate in    |  Tab\nNavigate out   |  Ctrl+Tab\nNavigate out backwards    |  Shift+Ctrl+Tab\nMove up/down a line    |  Up/Down Arrown\nMove left/right a component or char    |  Left/Right Arrow\nMove up/down one vertical block    |  PgUp/PgDn\nMove to start/end of line    |  Home/End\nMove to previous/next word    |  Ctrl+Left/Right Arrow\nMove to start/end of data    |  Ctrl+Home/End\nMove left/right one block    |  Ctrl+PgUp/PgDn\nSelect All    |  Ctrl+A\nExtend selection up one line    |  Shift+Up Arrow\nExtend selection down one line    |  Shift+Down Arrow\nExtend selection to beginning of line    |  Shift+Home\nExtend selection to end of line    |  Shift+End\nExtend selection to beginning of data    |  Ctrl+Shift+Home\nExtend selection to end of data    |  Ctrl+Shift+End\nExtend selection left    |  Shift+Right Arrow\nExtend selection right    |  Shift+Right Arrow\nExtend selection up one vertical block    |  Shift+PgUp\nExtend selection down one vertical block    |  Shift+PgDn\nExtend selection left one block    |  Ctrl+Shift+PgUp\nExtend selection right one block    |  Ctrl+Shift+PgDn\nExtend selection left one word    |  Ctrl+Shift+Left Arrow\nExtend selection right one word    |  Ctrl+Shift+Right Arrow\n";
        JOptionPane.showMessageDialog(this, shortcuts);
    }

    public void aboutQuantumHyperSpace() {
        JOptionPane.showMessageDialog(this, "QuantumHyperSpace Programming Services\nhttp://www.quantumhyperspace.com\nemail: support@quantumhyperspace.com\n                     or \nemail: charles@quantumhyperspace.com\n", "QuantumHyperSpace", 1, new ImageIcon("quantumhyperspace.gif"));
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.lstPages = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.wikiPane = new JWikiPane();
        this.toolbarMain = new JToolBar();
        this.cmdHome = new JButton();
        this.cmdBack = new JButton();
        this.cmdFwd = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.saveItem = new JMenuItem();
        this.saveAsItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoItem = new JMenuItem();
        this.redoItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.cutItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.clearItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.selectAllItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnuLink = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.insertBreaKItem = new JMenuItem();
        this.unorderedListItem = new JMenuItem();
        this.bulletItem = new JMenuItem();
        this.colorMenu = new JMenu();
        this.redTextItem = new JMenuItem();
        this.orangeTextItem = new JMenuItem();
        this.yellowTextItem = new JMenuItem();
        this.greenTextItem = new JMenuItem();
        this.blueTextItem = new JMenuItem();
        this.cyanTextItem = new JMenuItem();
        this.magentaTextItem = new JMenuItem();
        this.blackTextItem = new JMenuItem();
        this.fontMenu = new JMenu();
        this.mnuFontType = new JMenu();
        this.mnuSansSerif = new JMenuItem();
        this.mnuSerif = new JMenuItem();
        this.mnuMonospaced = new JMenuItem();
        this.mnuDialog = new JMenuItem();
        this.mnuDialogInput = new JMenuItem();
        this.mnuFontSize = new JMenu();
        this.styleMenu = new JMenu();
        this.boldMenuItem = new JMenuItem();
        this.underlineMenuItem = new JMenuItem();
        this.italicMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.subscriptMenuItem = new JMenuItem();
        this.superscriptMenuItem = new JMenuItem();
        this.strikeThroughMenuItem = new JMenuItem();
        this.alignMenu = new JMenu();
        this.leftAlignMenuItem = new JMenuItem();
        this.centerMenuItem = new JMenuItem();
        this.rightAlignMenuItem = new JMenuItem();
        this.mnuHelp = new JMenu();
        this.mnuPreview = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(3);
        this.jSplitPane1.setDividerLocation(125);
        this.lstPages.setModel(new WikiPageListModel());
        this.lstPages.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WikiEditor.this.lstPagesMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WikiEditor.this.lstPagesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                WikiEditor.this.lstPagesMouseReleased(evt);
            }
        });
        this.lstPages.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WikiEditor.this.lstPagesValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstPages);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jScrollPane3.setViewportView(this.wikiPane);
        this.jSplitPane1.setRightComponent(this.jScrollPane3);
        this.toolbarMain.setRollover(true);
        this.cmdHome.setIcon(new ImageIcon(this.getClass().getResource("/images24/home.png")));
        this.cmdHome.setEnabled(false);
        this.cmdHome.setFocusable(false);
        this.cmdHome.setHorizontalTextPosition(0);
        this.cmdHome.setVerticalTextPosition(3);
        this.cmdHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.cmdHomeActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdHome);
        this.cmdBack.setIcon(new ImageIcon(this.getClass().getResource("/images24/back.png")));
        this.cmdBack.setEnabled(false);
        this.cmdBack.setFocusable(false);
        this.cmdBack.setHorizontalTextPosition(0);
        this.cmdBack.setVerticalTextPosition(3);
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.cmdBackActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdBack);
        this.cmdFwd.setIcon(new ImageIcon(this.getClass().getResource("/images24/forward.png")));
        this.cmdFwd.setEnabled(false);
        this.cmdFwd.setFocusable(false);
        this.cmdFwd.setHorizontalTextPosition(0);
        this.cmdFwd.setVerticalTextPosition(3);
        this.cmdFwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.cmdFwdActionPerformed(evt);
            }
        });
        this.toolbarMain.add(this.cmdFwd);
        this.jMenu1.setText("File");
        this.newItem.setText("New");
        this.jMenu1.add(this.newItem);
        this.openItem.setText("Open");
        this.jMenu1.add(this.openItem);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveItem.setText("Save");
        this.jMenu1.add(this.saveItem);
        this.saveAsItem.setText("Save as");
        this.jMenu1.add(this.saveAsItem);
        this.exitItem.setText("Exit");
        this.jMenu1.add(this.exitItem);
        this.jMenuBar1.add(this.jMenu1);
        this.editMenu.setText("Edit");
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.undoItem.setText("Undo");
        this.editMenu.add(this.undoItem);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.redoItem.setText("Redo");
        this.editMenu.add(this.redoItem);
        this.editMenu.add(this.jSeparator2);
        this.cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.cutItem.setText("Cut");
        this.editMenu.add(this.cutItem);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.copyItem.setText("Copy");
        this.editMenu.add(this.copyItem);
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.pasteItem.setText("Paste");
        this.editMenu.add(this.pasteItem);
        this.clearItem.setText("Clear");
        this.editMenu.add(this.clearItem);
        this.editMenu.add(this.jSeparator3);
        this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.selectAllItem.setText("Select All");
        this.editMenu.add(this.selectAllItem);
        this.jMenuBar1.add(this.editMenu);
        this.jMenu3.setText("Insert");
        this.jMenuItem2.setText("New page");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenu3.add(this.jSeparator1);
        this.mnuLink.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.mnuLink.setText("Link");
        this.mnuLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.mnuLinkActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.mnuLink);
        this.jMenu3.add(this.jSeparator4);
        this.insertBreaKItem.setText("Break");
        this.jMenu3.add(this.insertBreaKItem);
        this.unorderedListItem.setText("Unordered List Item");
        this.jMenu3.add(this.unorderedListItem);
        this.bulletItem.setText("Bullets");
        this.jMenu3.add(this.bulletItem);
        this.jMenuBar1.add(this.jMenu3);
        this.colorMenu.setText("Color");
        this.redTextItem.setText("Red");
        this.colorMenu.add(this.redTextItem);
        this.orangeTextItem.setText("Orange");
        this.colorMenu.add(this.orangeTextItem);
        this.yellowTextItem.setText("Yellow");
        this.colorMenu.add(this.yellowTextItem);
        this.greenTextItem.setText("Green");
        this.colorMenu.add(this.greenTextItem);
        this.blueTextItem.setText("Blue");
        this.colorMenu.add(this.blueTextItem);
        this.cyanTextItem.setText("Cyan");
        this.colorMenu.add(this.cyanTextItem);
        this.magentaTextItem.setText("Magenta");
        this.colorMenu.add(this.magentaTextItem);
        this.blackTextItem.setText("Black");
        this.colorMenu.add(this.blackTextItem);
        this.jMenuBar1.add(this.colorMenu);
        this.fontMenu.setText("Font");
        this.mnuFontType.setText("Font Type");
        this.mnuSansSerif.setText("SansSerif");
        this.mnuFontType.add(this.mnuSansSerif);
        this.mnuSerif.setText("Serif");
        this.mnuFontType.add(this.mnuSerif);
        this.mnuMonospaced.setText("Monospaced");
        this.mnuFontType.add(this.mnuMonospaced);
        this.mnuDialog.setText("Dialog");
        this.mnuFontType.add(this.mnuDialog);
        this.mnuDialogInput.setText("DialogInput");
        this.mnuFontType.add(this.mnuDialogInput);
        this.fontMenu.add(this.mnuFontType);
        this.mnuFontSize.setText("Font Size");
        this.fontMenu.add(this.mnuFontSize);
        this.jMenuBar1.add(this.fontMenu);
        this.styleMenu.setText("Style");
        this.boldMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.boldMenuItem.setText("Bold");
        this.styleMenu.add(this.boldMenuItem);
        this.underlineMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.underlineMenuItem.setText("Underlined");
        this.styleMenu.add(this.underlineMenuItem);
        this.italicMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        this.italicMenuItem.setText("Italics");
        this.styleMenu.add(this.italicMenuItem);
        this.styleMenu.add(this.jSeparator5);
        this.subscriptMenuItem.setText("Subscript");
        this.styleMenu.add(this.subscriptMenuItem);
        this.superscriptMenuItem.setText("Superscript");
        this.styleMenu.add(this.superscriptMenuItem);
        this.strikeThroughMenuItem.setText("Strikethrough");
        this.styleMenu.add(this.strikeThroughMenuItem);
        this.jMenuBar1.add(this.styleMenu);
        this.alignMenu.setText("Align");
        this.leftAlignMenuItem.setText("Align left");
        this.alignMenu.add(this.leftAlignMenuItem);
        this.centerMenuItem.setText("Align Center");
        this.alignMenu.add(this.centerMenuItem);
        this.rightAlignMenuItem.setText("Align right");
        this.alignMenu.add(this.rightAlignMenuItem);
        this.jMenuBar1.add(this.alignMenu);
        this.mnuHelp.setText("Help");
        this.mnuHelp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WikiEditor.this.mnuHelpStateChanged(evt);
            }
        });
        this.mnuPreview.setSelected(true);
        this.mnuPreview.setText("Preview");
        this.mnuPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditor.this.mnuPreviewActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuPreview);
        this.jMenuBar1.add(this.mnuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jSplitPane1).addGap(3, 3, 3)).addComponent(this.toolbarMain, -1, 759, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolbarMain, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 335, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void mnuLinkActionPerformed(ActionEvent evt) {
        String linkID = JOptionPane.showInputDialog(this.wikiPane, "Enter new page ID", "newPage");
        if (linkID == null || linkID.length() == 0) {
            return;
        }
        String defVal = this.wikiPane.getSelectedText();
        String linkText = JOptionPane.showInputDialog(this.wikiPane, "Enter page link text", defVal != null && defVal.length() > 0 ? defVal : "New Page");
        if (linkText == null || linkText.length() == 0) {
            return;
        }
        String text = "<a href=\"" + linkID + "\">" + linkText + "</a>";
        HTMLEditorKit editorKit = new HTMLEditorKit();
        try {
            editorKit.insertHTML(this.document, this.wikiPane.getCaretPosition(), text, 0, 0, HTML.Tag.A);
            if (!this.isExternalURL(linkID) && !this.wikiDoc.contents.containsKey(linkID)) {
                WikiPage element = new WikiPage(linkID, linkText, "Page is not yet available.");
                this.listModel.addElement(element);
            }
        }
        catch (IOException | BadLocationException ex) {
            System.out.println("error, " + ex.getLocalizedMessage());
        }
    }

    private void lstPagesValueChanged(ListSelectionEvent evt) {
    }

    private void lstPagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            WikiPage page;
            if (this.activePage != null) {
                this.activePage.contents = this.wikiPane.getText();
            }
            if ((page = this.lstPages.getSelectedValue()) == null) {
                return;
            }
            this.setActivePage(page);
        }
    }

    public WikiPage getActivePage() {
        return this.activePage;
    }

    public void setActivePage(WikiPage page) {
        this.activePage = page;
        if (this.activePage == null) {
            this.setTitle("Wiki Document Editor");
        } else {
            this.setTitle("Wiki Document Editor - " + page.toString());
        }
        this.wikiPane.displayPage(page);
    }

    private void lstPagesMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.lstPages.setSelectedIndex(this.lstPages.locationToIndex(new Point(evt.getX(), evt.getY())));
            this.showPopup(evt);
        } else if (evt.getClickCount() > 1) {
            WikiPage page;
            if (this.activePage != null) {
                this.activePage.contents = this.wikiPane.getText();
            }
            if ((page = this.lstPages.getSelectedValue()) == null) {
                return;
            }
            this.setActivePage(page);
            this.wikiPane.setText(page.contents);
        }
    }

    private void lstPagesMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopup(evt);
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        String linkID = JOptionPane.showInputDialog(this.wikiPane, "Enter new page ID", "newPage");
        if (linkID == null || linkID.length() == 0) {
            return;
        }
        String defVal = this.wikiPane.getSelectedText();
        String linkText = JOptionPane.showInputDialog(this.wikiPane, "Enter page title", defVal != null && defVal.length() > 0 ? defVal : "New Page");
        if (linkText == null || linkText.length() == 0) {
            return;
        }
        this.listModel.addElement(new WikiPage(linkID, linkText));
    }

    private void mnuPreviewActionPerformed(ActionEvent evt) {
        boolean enabled = !this.wikiPane.isEditable();
        this.wikiPane.setEditable(enabled);
        this.cmdHome.setEnabled(!enabled);
        this.cmdBack.setEnabled(!enabled);
        this.cmdFwd.setEnabled(!enabled);
    }

    private void cmdHomeActionPerformed(ActionEvent evt) {
        this.goHome();
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
        this.goBack();
    }

    private void cmdFwdActionPerformed(ActionEvent evt) {
        this.goFwd();
    }

    private void mnuHelpStateChanged(ChangeEvent evt) {
        this.mnuPreview.setSelected(!this.wikiPane.isEditable());
    }

    private void goBack() {
        this.wikiPane.goBack();
    }

    private void goFwd() {
        this.wikiPane.goForward();
    }

    private void goHome() {
        this.wikiPane.displayPage(this.wikiPane.getModel().getHomePage());
    }

    private void showPopup(MouseEvent evt) {
        if (this.lstPages.getSelectedIndex() == -1) {
            return;
        }
        WikiPage page = this.lstPages.getSelectedValue();
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem("Insert link  to " + page.title));
        menu.add(new JMenuItem("Rename " + page.title));
        menu.addSeparator();
        menu.add(new JMenuItem("Delete " + page.title));
        menu.show(this.lstPages, evt.getX(), evt.getY());
    }

    private boolean isExternalURL(String url) {
        return !url.equals(WikiPage.safeID(url));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(WikiEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new WikiEditor().setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (this.debug) {
            int modifier = ae.getModifiers();
            long when = ae.getWhen();
            String parameter = ae.paramString();
            System.out.println("actionCommand: " + actionCommand);
            System.out.println("modifier: " + modifier);
            System.out.println("when: " + when);
            System.out.println("parameter: " + parameter);
        }
        if (actionCommand.compareTo("New") == 0) {
            this.startNewWiki();
        } else if (actionCommand.compareTo("Open") == 0) {
            this.openDocument();
        } else if (actionCommand.compareTo("Save") == 0) {
            this.saveDocument();
        } else if (actionCommand.compareTo("Save As") == 0) {
            this.saveDocumentAs();
        } else if (actionCommand.compareTo("Exit") == 0) {
            this.exit();
        } else if (actionCommand.compareTo("Clear") == 0) {
            this.clear();
        } else if (actionCommand.compareTo("Select All") == 0) {
            this.selectAll();
        } else if (actionCommand.compareTo("Help") == 0) {
            this.help();
        } else if (actionCommand.compareTo("Keyboard Shortcuts") == 0) {
            this.showShortcuts();
        } else if (actionCommand.compareTo("About QuantumHyperSpace") == 0) {
            this.aboutQuantumHyperSpace();
        }
    }

    private void updateButtons() {
        boolean hasPrev = this.wikiPane.canGoBack();
        boolean hasNext = this.wikiPane.canGoForward();
        this.cmdFwd.setEnabled(hasNext);
        this.cmdBack.setEnabled(hasPrev);
        WikiPage currentPage = this.wikiPane.getCurrentPage();
        if (currentPage != null) {
            this.setTitle(this.wikiPane.getModel().getTitle() + " - " + currentPage.getTitle());
        } else {
            this.setTitle(this.wikiPane.getModel().getTitle());
        }
    }

    @Override
    public void wikiPanelEvent(WikiEvent ... events) {
        for (WikiEvent event : events) {
            switch (event.value) {
                case 0: {
                    this.updateButtons();
                }
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            WikiEditor.this.undo.addEdit(e.getEdit());
            WikiEditor.this.undoAction.update();
            WikiEditor.this.redoAction.update();
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                WikiEditor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + String.valueOf(ex));
                ex.printStackTrace();
            }
            this.update();
            WikiEditor.this.redoAction.update();
        }

        protected void update() {
            if (WikiEditor.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", WikiEditor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                WikiEditor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.err.println("Unable to redo: " + String.valueOf(ex));
                ex.printStackTrace();
            }
            this.update();
            WikiEditor.this.undoAction.update();
        }

        protected void update() {
            if (WikiEditor.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", WikiEditor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    private class WikiPageListModel
    extends DefaultListModel<WikiPage> {
        private WikiPageListModel() {
        }

        @Override
        public int getSize() {
            return WikiEditor.this.wikiDoc.getPageCount();
        }

        @Override
        public WikiPage getElementAt(int i) {
            return WikiEditor.this.wikiDoc.contents.get(i);
        }

        @Override
        public void clear() {
            int index1 = WikiEditor.this.wikiDoc.contents.size() - 1;
            WikiEditor.this.wikiDoc.contents.clear();
            if (index1 >= 0) {
                this.fireIntervalRemoved(this, 0, index1);
            }
        }

        @Override
        public void addElement(WikiPage element) {
            WikiEditor.this.wikiDoc.contents.add(element, element.id);
            this.fireIntervalAdded(this, WikiEditor.this.wikiDoc.contents.size() - 1, WikiEditor.this.wikiDoc.contents.size() - 1);
        }

        @Override
        public void add(int index, WikiPage element) {
            WikiEditor.this.wikiDoc.contents.insert(element, index);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public WikiPage elementAt(int index) {
            return WikiEditor.this.wikiDoc.contents.get(index);
        }

        @Override
        public int indexOf(Object elem) {
            return WikiEditor.this.wikiDoc.contents.indexOf((WikiPage)elem);
        }

        @Override
        public boolean contains(Object elem) {
            return WikiEditor.this.wikiDoc.contents.containsKey(((WikiPage)elem).id);
        }
    }

    class SubscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SubscriptAction() {
            super(StyleConstants.Subscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean subscript = !StyleConstants.isSubscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSubscript(sas, subscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class SuperscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SuperscriptAction() {
            super(StyleConstants.Superscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean superscript = !StyleConstants.isSuperscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSuperscript(sas, superscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class StrikeThroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikeThroughAction() {
            super(StyleConstants.StrikeThrough.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikeThrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikeThrough);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class WikiFileFilter
    extends FileFilter {
        WikiFileFilter(WikiEditor this$0) {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().indexOf(".wiki") > 0;
        }

        @Override
        public String getDescription() {
            return "Wiki Document";
        }
    }

    class FrameListener
    extends WindowAdapter {
        FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            WikiEditor.this.exit();
        }
    }
}

