/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.BinaryChain;
import JMWiki.WikiPage;
import JMWiki.XMLDocument;
import JMWiki.XMLElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public class WikiDocument {
    String title;
    String description;
    boolean isChanged = false;
    private String defHomePageLink = "home";
    private String defHomePageTitle = "Default Main Wiki Home Page";
    private String defHomePageContents = "<html><b><u>Main Wiki Page</u></b></html><br> Welcome to the default wiki page.";
    private String defaultErrorPageLink = "error";
    private String defaultErrorPageTitle = "Default Error Page";
    private String defaultErrorPageContents = "<html><b><u>Wiki Error Page</u></b></html><br> The page you requested was not found.<br> Click <a href =\"" + this.defHomePageLink + "\">here</a> to return home.";
    private WikiPage homePage = new WikiPage(this.defHomePageLink, this.defHomePageTitle, this.defHomePageContents);
    private WikiPage errorPage = new WikiPage(this.defaultErrorPageLink, this.defaultErrorPageTitle, this.defaultErrorPageContents);
    public final BinaryChain<WikiPage> contents = new BinaryChain();
    static final String INDENT_1 = "     ";
    static final String INDENT_2 = "          ";

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    public boolean pageExists(String id) {
        return this.contents.containsKey(id);
    }

    public WikiPage addPage(WikiPage page) {
        this.contents.add(page, page.id);
        return page;
    }

    public WikiPage addPage(String id) {
        WikiPage newPage = new WikiPage(id);
        this.contents.add(newPage, id);
        return newPage;
    }

    public WikiPage addPage(String id, String title) {
        WikiPage newPage = new WikiPage(id, title, "");
        this.contents.add(newPage, id);
        return newPage;
    }

    public WikiPage addPage(String id, String title, String contents) {
        WikiPage newPage = new WikiPage(id, title, contents);
        this.contents.add(newPage, id);
        return newPage;
    }

    public void removePage(String id) {
        this.contents.remove(id);
    }

    public int getPageCount() {
        return this.contents.size();
    }

    public static XMLDocument load(String xmlDataString) {
        return new XMLDocument(xmlDataString);
    }

    public static WikiDocument load(File file) {
        XMLDocument xmldoc = XMLDocument.loadXML(file);
        if (xmldoc == null) {
            return null;
        }
        XMLElement root = xmldoc.getRoot();
        if (!root.getAttribute("type", "").equalsIgnoreCase("JWiki")) {
            return null;
        }
        WikiDocument wikiDoc = new WikiDocument();
        XMLElement pages = root.getElement("pages");
        if (pages != null) {
            for (XMLElement xmlPage : pages.elements) {
                WikiPage wikiPage = WikiPage.fromXMLElement(xmlPage);
                wikiDoc.addPage(wikiPage);
            }
        }
        return wikiDoc;
    }

    public boolean write(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            fw.write("<Document type=\"JWiki\" title=\"" + this.title + "\">\r\n");
            fw.write("     <description>\r\n          " + this.description + "\r\n     </description>\r\n");
            for (WikiPage page : this.contents) {
                fw.write(this.toXMLString(page) + "\r\n");
            }
            fw.write("</Document>");
            fw.close();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException: " + fnfe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
            return false;
        }
    }

    public WikiPage getHomePage() {
        return this.homePage;
    }

    public WikiPage getErrorPage() {
        return this.errorPage;
    }

    public void setHomePage(WikiPage page) {
        if (this.isPageWalid(page)) {
            this.homePage = page;
            this.addPage(page);
        }
    }

    public void setErrorPage(WikiPage page) {
        if (this.isPageWalid(page)) {
            this.errorPage = page;
            this.addPage(page);
        }
    }

    private boolean isPageWalid(WikiPage page) {
        return page != null && page.id != null && page.id.length() > 0;
    }

    private String toXMLString(WikiPage page) {
        Object added = "";
        if (page == this.homePage) {
            added = (String)added + "homepage=\"1\"";
        }
        if (page == this.errorPage) {
            added = (String)added + "errorpage=\"1\"";
        }
        return "     <page id=\"" + page.id + "\" title=\"" + page.title + (String)added + "\"><![CDATA[\r\n" + page.contents + "     ]]></page>";
    }

    private static XMLDocument WikiDocumentToXML(WikiDocument wikiDoc) {
        XMLDocument doc = new XMLDocument();
        XMLElement root = doc.getRoot();
        root.addAttribute("document_type", "JWiki Document");
        root.addAttribute("title", wikiDoc.title);
        root.addAttribute("description", wikiDoc.description);
        XMLElement pages = new XMLElement("pages");
        for (WikiPage wPage : wikiDoc.contents) {
            XMLElement newPage = WikiPage.toXMLElement(wPage);
            pages.addElement(newPage);
        }
        return doc;
    }

    public static boolean isExternalURL(String url) {
        return !url.equals(WikiPage.safeID(url));
    }
}

