/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.UndoableAction;
import java.util.Vector;

abstract class Undoable {
    Vector<Undoable> childEdits = null;
    UndoableAction beforeUndo = null;
    UndoableAction afterUndo = null;
    UndoableAction beforeRedo = null;
    UndoableAction afterRedo = null;
    public String undoName = "Undo last change";
    public String redoName = "Redo last change";

    public void setBeforeUndoAction(UndoableAction action) {
        this.beforeUndo = action;
    }

    public void setAfterUndoAction(UndoableAction action) {
        this.afterUndo = action;
    }

    public void setBeforeRedoAction(UndoableAction action) {
        this.beforeRedo = action;
    }

    public void setAfterRedoAction(UndoableAction action) {
        this.afterRedo = action;
    }

    public void addEdit(Undoable edit) {
        if (edit == null) {
            return;
        }
        if (this.childEdits == null) {
            this.childEdits = new Vector();
        }
        this.childEdits.add(edit);
    }

    public int childCount() {
        return this.childEdits != null ? this.childEdits.size() : 0;
    }

    public boolean hasChildren() {
        return this.childCount() > 0;
    }

    public final boolean runUndo() {
        if (this.beforeUndo != null && !this.beforeUndo.run()) {
            return false;
        }
        if (!this.undo()) {
            return false;
        }
        if (this.childEdits != null && !this.childEdits.isEmpty()) {
            for (int x = this.childEdits.size() - 1; x >= 0; --x) {
                this.childEdits.get(x).runUndo();
            }
        }
        return this.afterUndo != null ? this.afterUndo.run() : true;
    }

    public final boolean runRedo() {
        if (this.beforeRedo != null && !this.beforeRedo.run()) {
            return false;
        }
        if (!this.redo()) {
            return false;
        }
        if (this.childEdits != null && !this.childEdits.isEmpty()) {
            for (Undoable edit : this.childEdits) {
                edit.runRedo();
            }
        }
        return this.afterRedo != null ? this.afterRedo.run() : true;
    }

    public abstract boolean undo();

    public abstract boolean redo();
}

