/*
 * Decompiled with CFR 0.152.
 */
package JMOptionPanes;

import JMOptionPanes.IconPrompt;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public abstract class JMOptionPane
extends JPanel {
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_ONLY_OPTION = 3;
    JDialog parentDialog;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;

    public abstract Object getInputValue();

    public abstract void setSelectionValues(Object[] var1);

    public abstract void setInitialSelectionValue(Object var1);

    public abstract void selectInitialValue();

    public void hideParentDialog() {
        this.parentDialog.setVisible(false);
    }

    public JMOptionPane() {
        this.init();
    }

    public void init() {
    }

    public static Object showInputDialog(Component parent, String title, Icon icon, String initialSelectionValue, int style) {
        return JMOptionPane.showInputDialog(parent, null, title, icon, null, initialSelectionValue, style);
    }

    public static Object showInputDialog(Component parent, String title, Icon icon, Object[] selectionValues, Object initialSelectionValue, int style) {
        return JMOptionPane.showInputDialog(parent, null, title, icon, selectionValues, initialSelectionValue, style);
    }

    public static Object showInputDialog(Component parent, String prompt, String title, Icon icon, Object[] selectionValues, Object initialSelectionValue, int style) {
        JMOptionPane pane;
        JComponent c;
        if (selectionValues != null && selectionValues.length > 1) {
            c = new JComboBox<Object>(selectionValues);
            if (initialSelectionValue != null) {
                ((JComboBox)c).setSelectedItem(initialSelectionValue);
            } else {
                ((JComboBox)c).setSelectedIndex(0);
            }
        } else {
            c = new JTextField();
            if (initialSelectionValue != null) {
                ((JTextComponent)c).setText(initialSelectionValue.toString());
            }
        }
        if (prompt != null && prompt.length() > 0 || icon != null) {
            JLabel label = new JLabel();
            if (prompt != null && prompt.length() > 0) {
                label.setText(prompt);
            }
            if (icon != null) {
                label.setIcon(icon);
            }
            pane = JMOptionPane.createDefaultPane(parent, style, label, c);
        } else {
            pane = JMOptionPane.createDefaultPane(parent, style, c);
        }
        pane.setComponentOrientation((parent == null ? JOptionPane.getRootFrame() : parent).getComponentOrientation());
        JDialog dialog = JMOptionPane.createDialog(parent, title, pane);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        pane.parentDialog = null;
        dialog.dispose();
        int value = (Integer)pane.getInputValue();
        if (value == 0) {
            if (c instanceof JTextField) {
                return ((JTextComponent)c).getText();
            }
            if (c instanceof JComboBox) {
                return ((JComboBox)c).getSelectedItem();
            }
        }
        return null;
    }

    public static Object showInputDialog(Component parent, JMOptionPane pane, String title, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parent == null ? JOptionPane.getRootFrame() : parent).getComponentOrientation());
        JDialog dialog = JMOptionPane.createDialog(parent, title, pane);
        pane.selectInitialValue();
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        pane.parentDialog = null;
        dialog.dispose();
        Object value = pane.getInputValue();
        return value == JOptionPane.UNINITIALIZED_VALUE ? null : value;
    }

    public static Object showInputDialog(Component parent) {
        return JMOptionPane.showConfirmDialog(parent, null, "", null, 2);
    }

    public static Object showInputDialog(Component parent, String prompt) {
        return JMOptionPane.showConfirmDialog(parent, prompt, "", null, 2);
    }

    public static Object showInputDialog(Component parent, String prompt, String title) {
        return JMOptionPane.showConfirmDialog(parent, prompt, "", null, 2);
    }

    public static Object showInputDialog(Component parent, String prompt, String title, int style) {
        return JMOptionPane.showConfirmDialog(parent, prompt, "", null, style);
    }

    public static Object showInputDialog(Component parent, String prompt, String title, Icon icon) {
        return JMOptionPane.showConfirmDialog(parent, prompt, "", null, 2);
    }

    public static int showConfirmDialog(Component parent, String prompt, String title, Icon icon, int style) {
        Object retVal;
        IconPrompt p = new IconPrompt(prompt, icon, style);
        JLabel label = new JLabel();
        if (prompt != null) {
            label.setText(prompt);
        }
        if (icon != null) {
            label.setIcon(icon);
        }
        if ((retVal = JMOptionPane.showInputDialog(parent, title, style, label)) == null) {
            return -1;
        }
        return (Integer)retVal;
    }

    public static int showConfirmDialog(Component parent, String prompt, String title, Icon icon, int style, Component ... components) {
        Object retVal;
        JLabel label = new JLabel();
        Component[] c = Arrays.copyOf(components, components.length + 1);
        for (int x = c.length - 1; x > 0; --x) {
            c[x] = c[x - 1];
        }
        c[0] = label;
        if (prompt != null) {
            label.setText(prompt);
        }
        if (icon != null) {
            label.setIcon(icon);
        }
        if ((retVal = JMOptionPane.showInputDialog(parent, title, style, c)) == null) {
            return -1;
        }
        return (Integer)retVal;
    }

    public static Object showInputDialog(Component parent, String title, int style, Component ... c) {
        return JMOptionPane.showInputDialog(parent, JMOptionPane.createDefaultPane(parent, style, c), title);
    }

    private static JMOptionPane createDefaultPane(Component parent, final int style, final Component ... c) {
        return new JMOptionPane(){
            int value = -1;

            void confirm_Click() {
                this.value = 0;
                this.parentDialog.setVisible(false);
            }

            void cancelClick() {
                this.value = 2;
                this.parentDialog.setVisible(false);
            }

            void refuseClick() {
                this.value = 1;
                this.parentDialog.setVisible(false);
            }

            @Override
            public void init() {
                InputMap inputMap = this.getInputMap(2);
                ActionMap actionMap = this.getActionMap();
                this.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.setLayout(new GridLayout(c.length + 1, 1, 5, 2));
                for (Component c1 : c) {
                    this.add(c1);
                }
                JPanel buttonPanel = new JPanel();
                buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
                buttonPanel.setLayout(new GridLayout(1, 2, 5, 2));
                if (style == -1 || style == 2 || style == 3) {
                    JButton cmdOK = new JButton("OK");
                    buttonPanel.add(cmdOK);
                    cmdOK.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.confirm_Click();
                        }
                    });
                    inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "enter");
                    actionMap.put("enter", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            this.confirm_Click();
                        }
                    });
                }
                if (style == 0 || style == 1) {
                    JButton cmdYes = new JButton("Yes");
                    buttonPanel.add(cmdYes);
                    cmdYes.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.confirm_Click();
                        }
                    });
                    cmdYes.requestFocus();
                    JButton cmdNo = new JButton("No");
                    buttonPanel.add(cmdNo);
                    cmdNo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.refuseClick();
                        }
                    });
                    cmdNo.requestFocus();
                    inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "enter");
                    actionMap.put("enter", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            this.confirm_Click();
                        }
                    });
                    inputMap.put(KeyStroke.getKeyStroke(89, 0, true), "y");
                    actionMap.put("y", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            this.confirm_Click();
                        }
                    });
                    inputMap.put(KeyStroke.getKeyStroke(78, 0, true), "n");
                    actionMap.put("n", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            this.refuseClick();
                        }
                    });
                    if (style == 0) {
                        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "esc");
                        actionMap.put("esc", new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                this.refuseClick();
                            }
                        });
                    }
                }
                if (style == 2 || style == 1) {
                    JButton cmdCancel = new JButton("Cancel");
                    buttonPanel.add(cmdCancel);
                    cmdCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.cancelClick();
                        }
                    });
                    inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "esc");
                    actionMap.put("esc", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            this.cancelClick();
                        }
                    });
                }
                this.add(buttonPanel);
            }

            @Override
            public Object getInputValue() {
                return this.value;
            }

            @Override
            public void setSelectionValues(Object[] values) {
            }

            @Override
            public void setInitialSelectionValue(Object value) {
            }

            @Override
            public void selectInitialValue() {
            }
        };
    }

    public static Object showInputDialog(Component parent, JMOptionPane pane, String title) {
        JDialog d;
        if (title == null) {
            title = "";
        }
        if ((d = JMOptionPane.createDialog(parent, title, pane)) == null) {
            return null;
        }
        d.pack();
        d.setResizable(false);
        d.setLocationRelativeTo(parent);
        d.setVisible(true);
        d.dispose();
        return pane.getInputValue();
    }

    private static JDialog createDialog(Component parent, String title, JMOptionPane pane) throws HeadlessException {
        Window window;
        JDialog dialog = parent != null ? ((window = JMOptionPane.getWindowForComponent(parent)) instanceof Frame ? new JDialog((Frame)window, true) : new JDialog((Dialog)window, true)) : new JDialog(new Frame(), true);
        if (title != null) {
            dialog.setTitle(title);
        }
        dialog.add(pane);
        pane.parentDialog = dialog;
        return dialog;
    }

    private static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JMOptionPane.getWindowForComponent(parentComponent.getParent());
    }
}

