/*
 * Decompiled with CFR 0.152.
 */
package JFileMaker;

import JFileMaker.JFileMakerItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JFileMaker {
    private JFileMakerItem SelectedItem;
    private static final String FILEMMAKERJID = "\u0000FmkJ\u0000";
    public static final int TOCTAG = -1;
    public static final int HEADERSIZE = 22;
    private RandomAccessFile inStream;
    private OutputStream outStream;
    private boolean inOpened = false;
    private boolean outOpened = false;
    private String mFileID = "FMKJ";
    private int FileMakerVer = 0;
    private TOCHeader TOC = new TOCHeader();
    private String mError = "";

    public String getError() {
        return this.mError;
    }

    public void setFileID(String fileID) {
        this.mFileID = fileID;
    }

    public String getFileID() {
        return this.mFileID;
    }

    public int getFileVersion() {
        return this.FileMakerVer;
    }

    public JFileMaker() {
    }

    public JFileMaker(String appHeader) {
        this.mFileID = appHeader;
    }

    private void clear() {
        this.close();
        this.mError = "";
    }

    public boolean LoadFile(File file) {
        this.clear();
        if (!file.isFile() | !file.exists()) {
            this.mError = "Invalid file selected";
            return false;
        }
        try {
            this.inStream = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ex) {
            this.mError = "Error opening file stream.";
            return false;
        }
        try {
            byte[] headerbytes = FILEMMAKERJID.getBytes();
            this.inStream.read(headerbytes);
            String FHeader = new String(headerbytes);
            if (!FILEMMAKERJID.equals(FHeader)) {
                this.mError = "App header not found.  Found: " + FHeader + "(" + headerbytes.length + "), Expected: " + this.mFileID + "(" + this.mFileID.length() + ")";
                return false;
            }
            short fileIDLen = this.inStream.readShort();
            if (fileIDLen != this.mFileID.length() + 1) {
                this.mError = "Unexpected header or invalid file format";
                return false;
            }
            headerbytes = this.mFileID.getBytes();
            this.inStream.read(headerbytes);
            String AppHeader = new String(headerbytes);
            if (!AppHeader.equals(this.mFileID)) {
                this.mError = "Unexpected header or invalid file format";
                return false;
            }
        }
        catch (IOException ex) {
            this.mError = "IOException: " + ex.getMessage();
            this.close();
            return false;
        }
        try {
            this.inStream.readByte();
            this.TOC.TagName = this.inStream.readInt();
            if (this.TOC.TagName != -1) {
                this.mError = "Inconsistent header";
                return false;
            }
            this.TOC.Version = this.inStream.readShort();
            this.TOC.EntrySize = this.inStream.readInt();
            if (this.TOC.EntrySize != 22) {
                this.mError = "Incorrect Table of Contents";
                return false;
            }
            this.TOC.Counts = this.inStream.readInt();
            this.TOC.DataOffset = this.inStream.readInt();
            this.inStream.seek(this.TOC.DataOffset - 1);
            for (int x = 0; x < this.TOC.Counts; ++x) {
                JFileMakerItem newItem = new JFileMakerItem();
                newItem.TagName = this.inStream.readInt();
                newItem.TagNum = this.inStream.readInt();
                newItem.Version = this.inStream.readShort();
                newItem.Counts = this.inStream.readInt();
                newItem.UserDef = this.inStream.readInt();
                newItem.DataOffset = this.inStream.readInt();
                this.TOC.Items.add(newItem);
            }
            ArrayList<String> Strings = new ArrayList<String>();
            for (int x = 0; x < this.TOC.Counts; ++x) {
                JFileMakerItem currentItem = (JFileMakerItem)this.TOC.Items.get(x);
                if (currentItem.Counts <= 0) continue;
                block15: for (int tmpCounts = currentItem.Counts; tmpCounts > 0; --tmpCounts) {
                    long curPos = this.inStream.getFilePointer();
                    int vType = this.inStream.readInt();
                    int byteCount = this.inStream.readInt();
                    switch (vType) {
                        case 1: {
                            if (byteCount <= 0) continue block15;
                            currentItem.Bytes = new byte[byteCount];
                            this.inStream.read(currentItem.Bytes);
                            continue block15;
                        }
                        case 2: {
                            int intCount = byteCount / 2;
                            if (intCount <= -1) continue block15;
                            currentItem.Integers = new int[intCount];
                            for (int intEntry = 0; intEntry < intCount; ++intEntry) {
                                currentItem.Integers[intEntry] = this.inStream.readShort();
                            }
                            continue block15;
                        }
                        case 3: {
                            int longCount = byteCount / 4;
                            if (longCount <= -1) continue block15;
                            currentItem.Longs = new long[longCount];
                            for (int intEntry = 0; intEntry < longCount; ++intEntry) {
                                currentItem.Longs[intEntry] = this.inStream.readInt();
                            }
                            continue block15;
                        }
                        case 4: {
                            int singleCount = byteCount / 4;
                            if (singleCount <= -1) continue block15;
                            currentItem.Floats = new float[singleCount];
                            for (int intEntry = 0; intEntry < singleCount; ++intEntry) {
                                currentItem.Floats[intEntry] = this.inStream.readFloat();
                            }
                            continue block15;
                        }
                        case 5: {
                            if (byteCount <= 0) continue block15;
                            byte[] b = new byte[byteCount];
                            this.inStream.read(b);
                            Strings.add(new String(b));
                            continue block15;
                        }
                        default: {
                            this.mError = "Unrecognized data type: " + vType + " at position " + curPos;
                            System.err.println(this.mError);
                            this.close();
                            return false;
                        }
                    }
                }
                if (Strings.isEmpty()) continue;
                currentItem.Strings = new String[Strings.size()];
                for (int cString = 0; cString < Strings.size(); ++cString) {
                    currentItem.Strings[cString] = (String)Strings.get(cString);
                }
                Strings.clear();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JFileMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.close();
        return true;
    }

    public int EntryCount() {
        return this.TOC.Items.size();
    }

    public JFileMakerItem getEntry(int EntryIndex) {
        if (EntryIndex >= this.TOC.Items.size() | EntryIndex < 0) {
            return null;
        }
        return (JFileMakerItem)this.TOC.Items.get(EntryIndex);
    }

    public void close() {
        if (this.inStream != null && this.inOpened) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inStream = null;
        } else if (this.outStream != null && this.outOpened) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outStream = null;
        }
    }

    public boolean writeFile(String fileName) {
        return true;
    }

    public int addEntry(int TagName) {
        this.SelectedItem = new JFileMakerItem(TagName);
        this.TOC.Items.add(this.SelectedItem);
        return this.TOC.Items.size() - 1;
    }

    public boolean setActiveEntryIndex(int EntryIndex) {
        if (EntryIndex < 0 | EntryIndex >= this.TOC.Items.size()) {
            return false;
        }
        this.SelectedItem = (JFileMakerItem)this.TOC.Items.get(EntryIndex);
        return true;
    }

    public boolean appendData(boolean data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(byte data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(byte[] data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(int data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(int[] data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(String data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(long data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(long[] data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(double data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(double[] data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(float data) {
        return this.SelectedItem != null;
    }

    public boolean appendData(float[] data) {
        return this.SelectedItem != null;
    }

    private class TOCHeader {
        private ArrayList<JFileMakerItem> Items = new ArrayList();
        String FileMakerID = "";
        short FileIDLen = 0;
        String FileID = "";
        int TagName;
        short Version = 0;
        int EntrySize = 0;
        int Counts = 0;
        int DataOffset = 0;
        short HighestLoadVer;
        boolean LoadHigher = false;

        private TOCHeader() {
        }
    }

    private class FileMakerVarTypes {
        public static final int DATABYTES = 1;
        public static final int DATAINTEGERS = 2;
        public static final int DATALONGS = 3;
        public static final int DATAFLOATS = 4;
        public static final int DATASTRING = 5;
        public static final int DATADOUBLE = 6;

        private FileMakerVarTypes() {
        }
    }
}

