/*
 * Decompiled with CFR 0.152.
 */
package ImageCombo;

import ImageCombo.ImageListItem;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ImageComboRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private Color selectionBackColor = null;
    private Color selectionForeColor = null;
    private Color foreColor = null;
    private Color backColor = null;

    public void setSelectionBackColor(Color color) {
        this.selectionBackColor = color;
    }

    public Color getSelectionBackColor() {
        return this.selectionBackColor;
    }

    public void setSelectionForeColor(Color color) {
        this.selectionForeColor = color;
    }

    public Color getSelectionForeColor() {
        return this.selectionForeColor;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setForeColor(Color color) {
        this.foreColor = color;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public ImageComboRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bColor;
        Color fColor;
        if (isSelected) {
            fColor = this.selectionForeColor != null ? this.selectionForeColor : (Color)UIManager.get("ComboBox.selectionForeground");
            Color color = bColor = this.selectionBackColor != null ? this.selectionBackColor : (Color)UIManager.get("ComboBox.selectionBackground");
            if (bColor == null) {
                bColor = list.getSelectionBackground();
            }
            if (fColor == null) {
                fColor = list.getSelectionForeground();
            }
        } else {
            fColor = this.foreColor != null ? this.foreColor : (Color)UIManager.get("ComboBox.foreground");
            Color color = bColor = this.backColor != null ? this.backColor : (Color)UIManager.get("ComboBox.background");
            if (bColor == null) {
                bColor = list.getBackground();
            }
            if (fColor == null) {
                fColor = list.getForeground();
            }
        }
        this.setBackground(bColor != null ? bColor : Color.WHITE);
        this.setForeground(fColor != null ? fColor : Color.BLACK);
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        if (value != null && value instanceof ImageListItem) {
            this.setIcon(((ImageListItem)value).icon);
            this.setText(((ImageListItem)value).text);
        } else {
            this.setText("");
            this.setIcon(null);
        }
        return this;
    }
}

