/*
 * Decompiled with CFR 0.152.
 */
package ImageCombo;

import ImageCombo.ImageComboRenderer;
import ImageCombo.ImageListItem;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class ImageCombo
extends JComboBox {
    private final ImageComboRenderer itemRenderer = new ImageComboRenderer();
    private ArrayList<ImageListItem> listItems = new ArrayList();
    private int lastItemKey;

    public void setSelectionColor(Color color) {
        if (color != null) {
            this.itemRenderer.setSelectionBackColor(color);
        }
    }

    public Color getSelectionColor() {
        return this.itemRenderer.getSelectionBackColor();
    }

    public ImageCombo() {
        this.setRenderer(this.itemRenderer);
        this.clearAll();
    }

    public void clearAll() {
        this.listItems.clear();
        this.lastItemKey = 0;
    }

    public String itemText() {
        return this.getSelectedIndex() > -1 ? this.itemText(this.getSelectedIndex()) : "";
    }

    public String itemText(int index) {
        if (this.isValidIndex(index)) {
            return this.listItems.get((int)index).text;
        }
        return null;
    }

    public void setItemText(String text) {
        if (this.getSelectedIndex() > -1) {
            this.setItemText(this.getSelectedIndex(), text);
        }
    }

    public void setItemText(int index, String text) {
        if (this.isValidIndex(index)) {
            this.listItems.get((int)index).text = text;
        }
    }

    public int getItemData(int index) {
        return this.isValidIndex(index) ? this.listItems.get((int)index).itemData : -1;
    }

    private boolean isValidIndex(int index) {
        return index < this.listItems.size() && index >= 0;
    }

    public int getItemData() {
        return this.getItemData(this.getSelectedIndex());
    }

    public void setItemData(int index, int intItemData) {
        if (this.isValidIndex(index)) {
            this.listItems.get((int)index).itemData = intItemData;
        }
    }

    public void setItemData(int intItemData) {
        if (this.getSelectedIndex() > -1) {
            this.setItemData(this.getSelectedIndex(), intItemData);
        }
    }

    public void setItemDataObject(int index, Object DataObject) {
        if (this.isValidIndex(index)) {
            this.listItems.get((int)index).dataObject = DataObject;
        }
    }

    public void setItemDataObject(Object DataObject) {
        if (this.getSelectedIndex() > -1) {
            this.setItemDataObject(this.getSelectedIndex(), DataObject);
        }
    }

    public Object getItemDataObject(int index) {
        return this.isValidIndex(index) ? this.listItems.get((int)index).dataObject : null;
    }

    public Object getItemDataObject() {
        return this.getSelectedIndex() > -1 ? this.getItemDataObject(this.getSelectedIndex()) : null;
    }

    public ImageIcon getIcon(int index) {
        return this.isValidIndex(index) ? this.listItems.get((int)index).icon : null;
    }

    public ImageIcon getIcon() {
        return this.getIcon(this.getSelectedIndex());
    }

    public String getText(int index) {
        return this.isValidIndex(index) ? this.listItems.get((int)index).text : "";
    }

    public void setIcon(int index, ImageIcon itemIcon) {
        if (this.isValidIndex(index)) {
            this.listItems.get((int)index).icon = itemIcon;
        }
    }

    public void setIcon(ImageIcon itemIcon) {
        if (this.getSelectedIndex() > -1) {
            this.setIcon(this.getSelectedIndex(), itemIcon);
        }
    }

    public void addItem(String itemTitle) {
        this.addItem(itemTitle, null, -1);
    }

    public void addItem(String itemTitle, String iconPath) {
        this.addItem(itemTitle, iconPath, -1);
    }

    public void addItem(String itemTitle, String iconPath, int itemIntData) {
        this.addItem(itemTitle, iconPath, itemIntData, null);
    }

    public void addItem(String itemTitle, String iconPath, int itemIntData, Object itemDataObject) {
        ImageListItem newItem = new ImageListItem();
        newItem.text = itemTitle;
        if (iconPath != null) {
            newItem.icon = new ImageIcon(this.getClass().getResource(iconPath));
        }
        newItem.itemData = itemIntData;
        ++this.lastItemKey;
        newItem.itemKey = String.valueOf(this.lastItemKey);
        if (itemDataObject != null) {
            newItem.dataObject = itemDataObject;
        }
        this.listItems.add(newItem);
        super.addItem(newItem.itemKey);
    }

    public void removeItem(int index) {
        if (this.isValidIndex(index)) {
            super.removeItemAt(index);
            this.listItems.remove(index);
        }
    }

    public void addItems(String[] itemTitles) {
        for (int i = 0; i < itemTitles.length; ++i) {
            this.addItem(itemTitles[i], null, -1);
        }
    }

    public boolean addItems(String[] itemTitles, String[] iconPaths) {
        if (itemTitles.length != iconPaths.length) {
            return false;
        }
        for (int i = 0; i < itemTitles.length; ++i) {
            this.addItem(itemTitles[i], iconPaths[i], i);
        }
        return true;
    }

    public boolean addItems(String[] itemTitles, String[] iconPaths, int[] itemIntData) {
        if (itemTitles.length != iconPaths.length || itemTitles.length != itemIntData.length) {
            return false;
        }
        for (int i = 0; i < itemTitles.length; ++i) {
            this.addItem(itemTitles[i], iconPaths[i], itemIntData[i]);
        }
        return true;
    }

    public boolean addItems(String[] itemTitles, String[] iconPaths, int[] itemIntData, Object[] dataObjects) {
        if (itemTitles.length != iconPaths.length || itemTitles.length != itemIntData.length) {
            return false;
        }
        for (int i = 0; i < itemTitles.length; ++i) {
            this.addItem(itemTitles[i], iconPaths[i], itemIntData[i], dataObjects[i]);
        }
        return true;
    }

    public ImageCombo(String[] itemTitles, String[] iconPaths) {
        this.setOpaque(true);
        this.addItems(itemTitles, iconPaths);
    }

    public ImageCombo(String[] itemTitles, String[] iconPaths, int[] itemIntData) {
        this.setOpaque(true);
        this.addItems(itemTitles, iconPaths, itemIntData);
    }

    public ImageCombo(String[] itemTitles, String[] iconPaths, int[] itemIntData, Object[] dataObjects) {
        this.setOpaque(true);
        this.addItems(itemTitles, iconPaths, itemIntData, dataObjects);
    }
}

