/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import BaseClasses.BasicIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class BasicRadioIcon
extends BasicIcon {
    @Override
    public boolean drawIcon(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setActiveColors(enabled, selected, rollOver, pressed);
        this.paintBackround(g2d, enabled, selected, rollOver, pressed);
        this.paintForeground(g2d, enabled, selected, rollOver, pressed);
        this.paintBorder(g2d, enabled, selected, rollOver, pressed);
        return true;
    }

    @Override
    public void paintForeground(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        if (selected || rollOver || pressed) {
            int midX = (this.width - 1) / 2;
            int midY = (this.height - 1) / 2;
            int dotSizeX = this.width / 4;
            int dotSizeY = this.height / 4;
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.setColor(this.colors.getActiveColor(0));
            g2d.fillArc(midX - dotSizeX + 1, midY - dotSizeY + 1, dotSizeX * 2, dotSizeY * 2, 0, 360);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        g2d.setColor(this.colors.getActiveColor(2));
        g2d.drawArc(0, 0, this.width - 1, this.height - 1, 0, 360);
    }

    @Override
    public void paintBackround(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        Color bColor = this.colors.getActiveColor(1);
        if (bColor != null) {
            g2d.setColor(bColor);
            g2d.fillArc(0, 0, this.width - 1, this.height - 1, 0, 360);
        }
    }

    @Override
    public void paintBorder(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
    }
}

