/*
 * Decompiled with CFR 0.152.
 */
package IconListBoxes;

import IconListBoxes.DefaultIconListItem;
import IconListBoxes.IconListItem;
import IconListBoxes.IconListRenderer;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class IconListBox
extends JList<IconListItem> {
    private IconListModel listModel;
    private final ArrayList<Integer> orderedSelectedIndicies = new ArrayList();

    private boolean isValidIndex(int itemIndex) {
        return itemIndex >= 0 && itemIndex <= this.listModel.getSize();
    }

    public IconListItem getItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            return (IconListItem)this.listModel.getElementAt(itemIndex);
        }
        return null;
    }

    public void refresh() {
        Image bufferimage = this.createImage(this.getWidth(), this.getHeight());
        this.paint(bufferimage.getGraphics());
        Graphics g = this.getGraphics();
        g.drawImage(bufferimage, 0, 0, this);
    }

    public void setModel() {
    }

    public IconListBox(IconListModel newListModel) {
        this.setCellRenderer(new IconListRenderer());
        this.listModel = newListModel;
        this.setModel(this.listModel);
        this.setSelectionModel(new OrderedListSelectionModel());
    }

    public IconListBox() {
        this.setCellRenderer(new IconListRenderer());
        this.listModel = new IconListModel();
        this.listModel.addElement(new DefaultIconListItem("Bold", new ImageIcon(IconListBox.class.getResource("/Icons/Bold.png"))));
        this.listModel.addElement(new DefaultIconListItem("ArrowDown", new ImageIcon(IconListBox.class.getResource("/Icons/ArrowDown.png"))));
        this.listModel.addElement(new DefaultIconListItem("Center", new ImageIcon(IconListBox.class.getResource("/Icons/Center.png"))));
        this.listModel.addElement(new DefaultIconListItem("Font", new ImageIcon(IconListBox.class.getResource("/Icons/Font.png"))));
        this.listModel.addElement(new DefaultIconListItem("Italics", new ImageIcon(IconListBox.class.getResource("/Icons/Italics.png"))));
        this.listModel.addElement(new DefaultIconListItem("Notes", new ImageIcon(IconListBox.class.getResource("/Icons/NOTES.png"))));
        this.setModel(this.listModel);
        this.setSelectionModel(new OrderedListSelectionModel());
    }

    public void clear() {
        this.orderedSelectedIndicies.clear();
        this.listModel.removeAllElements();
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public void removeItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.removeElementAt(itemIndex);
        }
    }

    public void moveItemTo(int itemIndex, int newIndex) {
        if (this.isValidIndex(itemIndex) && this.isValidIndex(newIndex)) {
            IconListItem tmpItem = this.listModel.remove(itemIndex);
            this.listModel.add(newIndex, tmpItem);
        }
    }

    public int addItem(IconListItem item) {
        this.listModel.addElement(item);
        this.refresh();
        return this.listModel.size() - 1;
    }

    public int addItem(IconListItem item, int index) {
        this.listModel.add(index, item);
        this.refresh();
        return this.listModel.size() - 1;
    }

    public int[] getOrderedIndicies() {
        return this.listModel.getOrderedIndicies();
    }

    class IconListModel
    extends DefaultListModel<IconListItem> {
        IconListModel() {
        }

        public int[] getOrderedIndicies() {
            if (IconListBox.this.orderedSelectedIndicies.isEmpty()) {
                return null;
            }
            int[] outInts = new int[IconListBox.this.orderedSelectedIndicies.size()];
            for (int x = 0; x < IconListBox.this.orderedSelectedIndicies.size(); ++x) {
                outInts[x] = (Integer)IconListBox.this.orderedSelectedIndicies.get(x);
            }
            return outInts;
        }

        @Override
        public void removeElementAt(int index) {
            super.removeElementAt(index);
            if (this.getSize() == 0) {
                IconListBox.this.orderedSelectedIndicies.clear();
            }
        }

        @Override
        public boolean removeElement(Object obj) {
            boolean retVal = super.removeElement(obj);
            if (this.getSize() == 0) {
                IconListBox.this.orderedSelectedIndicies.clear();
            }
            return retVal;
        }

        @Override
        public IconListItem remove(int index) {
            IconListItem item = (IconListItem)super.remove(index);
            if (this.getSize() == 0) {
                IconListBox.this.orderedSelectedIndicies.clear();
            }
            return item;
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
            IconListBox.this.orderedSelectedIndicies.clear();
        }
    }

    class OrderedListSelectionModel
    extends DefaultListSelectionModel {
        OrderedListSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(index0, index1);
            IconListBox.this.orderedSelectedIndicies.clear();
            if (index0 < index1) {
                for (int index = index0; index <= index1; ++index) {
                    Integer integer = index;
                    IconListBox.this.orderedSelectedIndicies.add(integer);
                }
            } else {
                for (int index = index0; index >= index1; --index) {
                    Integer integer = index;
                    IconListBox.this.orderedSelectedIndicies.add(integer);
                }
            }
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            super.addSelectionInterval(index0, index1);
            if (index0 < index1) {
                for (int index = index0; index <= index1; ++index) {
                    Integer integer = index;
                    if (IconListBox.this.orderedSelectedIndicies.contains(integer)) continue;
                    IconListBox.this.orderedSelectedIndicies.add(integer);
                }
            } else {
                for (int index = index0; index >= index1; --index) {
                    Integer integer = index;
                    if (IconListBox.this.orderedSelectedIndicies.contains(integer)) continue;
                    IconListBox.this.orderedSelectedIndicies.add(integer);
                }
            }
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            super.removeSelectionInterval(index0, index1);
            if (index0 < index1) {
                for (int index = index0; index <= index1; ++index) {
                    Integer integer = index;
                    if (!IconListBox.this.orderedSelectedIndicies.contains(integer)) continue;
                    IconListBox.this.orderedSelectedIndicies.remove(integer);
                }
            } else {
                for (int index = index0; index >= index1; --index) {
                    Integer integer = index;
                    if (!IconListBox.this.orderedSelectedIndicies.contains(integer)) continue;
                    IconListBox.this.orderedSelectedIndicies.remove(integer);
                }
            }
        }
    }
}

