/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import GraphicTreeClass.GraphicTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class GraphicTreeTransferHandler
extends TransferHandler {
    private GraphicTreeNode[] nodes;
    private int entryCounts = 0;
    private GraphicTreeNode target;
    private DataFlavor[] flavors = new DataFlavor[1];

    public GraphicTreeTransferHandler() {
        this.flavors[0] = GraphicTreeNode.graphicTreeNodeFlavor;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        support.setShowDropLocation(true);
        DataFlavor dropFlavor = support.getDataFlavors()[0];
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath dest = dl.getPath();
        if (dest == null) {
            return false;
        }
        this.target = (GraphicTreeNode)dest.getLastPathComponent();
        if (!this.target.acceptsDrop(support)) {
            return false;
        }
        if (dropFlavor.equals(GraphicTreeNode.graphicTreeNodeFlavor)) {
            JTree tree = (JTree)support.getComponent();
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] != dropRow) continue;
                return false;
            }
            int action = support.getDropAction();
            if (action == 2) {
                return this.haveCompleteNode(tree);
            }
            TreePath path = tree.getPathForRow(selRows[0]);
            GraphicTreeNode firstNode = (GraphicTreeNode)path.getLastPathComponent();
            if (!this.target.acceptsDrop(support)) {
                return false;
            }
            return firstNode.getChildCount() <= 0 || this.target.getLevel() >= firstNode.getLevel();
        }
        return dropFlavor.equals(DataFlavor.javaFileListFlavor);
    }

    private boolean haveCompleteNode(JTree tree) {
        int[] selRows = tree.getSelectionRows();
        TreePath path = tree.getPathForRow(selRows[0]);
        GraphicTreeNode first = (GraphicTreeNode)path.getLastPathComponent();
        int childCount = first.getChildCount();
        if (childCount > 0 && selRows.length == 1) {
            return false;
        }
        for (int i = 1; i < selRows.length; ++i) {
            path = tree.getPathForRow(selRows[i]);
            GraphicTreeNode next = (GraphicTreeNode)path.getLastPathComponent();
            if (!first.isNodeChild(next) || childCount <= selRows.length - 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            NodesTransferable tn = new NodesTransferable();
            tn.nodes = new GraphicTreeNode[paths.length];
            this.nodes = new GraphicTreeNode[paths.length];
            this.entryCounts = 0;
            for (int i = 0; i < paths.length; ++i) {
                GraphicTreeNode next = (GraphicTreeNode)paths[i].getLastPathComponent();
                if (!next.mMovable) continue;
                this.nodes[this.entryCounts] = next;
                ++this.entryCounts;
                tn.nodes[tn.EntryCounts] = next;
                ++tn.EntryCounts;
            }
            if (tn.EntryCounts > 0) {
                return tn;
            }
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DataFlavor[] df = support.getTransferable().getTransferDataFlavors();
        if (df[0].equals(GraphicTreeNode.graphicTreeNodeFlavor)) {
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            TreePath dest = dl.getPath();
            GraphicTreeNode parent = (GraphicTreeNode)dest.getLastPathComponent();
            this.nodesNodeDrop(parent, this.nodes);
            return true;
        }
        if (df[0].equals(DataFlavor.javaFileListFlavor)) {
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.filesNodeDrop(this.target, fileList);
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void filesNodeDrop(GraphicTreeNode target, List fileList) {
    }

    public void nodesNodeDrop(GraphicTreeNode parent, GraphicTreeNode[] nodes) {
    }

    private class NodesTransferable
    implements Transferable {
        GraphicTreeNode[] nodes;
        int EntryCounts = 0;

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return GraphicTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return GraphicTreeNode.graphicTreeNodeFlavor.equals(flavor);
        }
    }
}

