/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import GraphicTreeClass.GraphicTree;
import GraphicTreeClass.GraphicTreeNode;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;

public class GraphicTreeCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener {
    boolean added = false;
    boolean cancelled = false;

    public GraphicTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.addCellEditorListener(this);
    }

    public GraphicTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
        this.addCellEditorListener(this);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.lastPath != null) {
            this.applyEdit((GraphicTreeNode)this.lastPath.getLastPathComponent(), (String)this.getCellEditorValue());
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        if (!this.cancelled && this.lastPath != null) {
            this.applyEdit((GraphicTreeNode)this.lastPath.getLastPathComponent(), (String)this.getCellEditorValue());
        }
    }

    @Override
    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
            GraphicTreeNode editedNode = (GraphicTreeNode)this.lastPath.getLastPathComponent();
            this.editingIcon = editedNode.getIcon();
            if (this.editingComponent instanceof JTextComponent) {
                ((JTextComponent)this.editingComponent).setText(editedNode.getText());
            }
            this.cancelled = false;
            if (!this.added) {
                this.editingComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        GraphicTreeCellEditor.this.tree.stopEditing();
                        if (GraphicTreeCellEditor.this.editingComponent != null) {
                            GraphicTreeCellEditor.this.editingComponent.setVisible(false);
                        }
                    }
                });
                this.editingComponent.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent arg0) {
                    }

                    @Override
                    public void keyPressed(KeyEvent arg0) {
                        if (arg0.getKeyCode() == 27) {
                            GraphicTreeCellEditor.this.cancelled = true;
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent arg0) {
                    }
                });
                this.added = true;
            }
            this.editingComponent.setVisible(true);
        }
    }

    public void applyEdit(GraphicTreeNode node, String newVal) {
        String oldVal = node.getText();
        if (newVal.equals(oldVal)) {
            return;
        }
        node.setText(newVal);
        this.tree.getModel().valueForPathChanged(this.lastPath, this.getCellEditorValue());
        ((GraphicTree)this.tree).nodeRenamed(node);
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return super.isCellEditable(event);
    }
}

