/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import GraphicTreeClass.GraphicTreeCellEditor;
import GraphicTreeClass.GraphicTreeNode;
import GraphicTreeClass.GraphicTreeRenderer;
import GraphicTreeClass.GraphicTreeTransferHandler;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanProperty;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class GraphicTree
extends JTree
implements TreeModelListener,
TreeExpansionListener,
TreeSelectionListener {
    protected GraphicTreeRenderer renderer;
    protected GraphicTreeCellEditor editor;

    public GraphicTree() {
        this.initTree();
    }

    public GraphicTree(GraphicTreeNode node) {
        super(node);
        this.initTree();
    }

    @BeanProperty(hidden=true)
    public void setRoot(GraphicTreeNode node) {
        this.setModel(new DefaultTreeModel(node));
    }

    @BeanProperty(hidden=true)
    public GraphicTreeNode getRoot() {
        return (GraphicTreeNode)this.getModel().getRoot();
    }

    public void ResetModel(GraphicTreeNode rootnode) {
        this.setModel(new DefaultTreeModel(rootnode));
    }

    public void notifyNodeChanged(GraphicTreeNode node) {
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public void setSelectionModel(int selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateFonts();
    }

    @Override
    @BeanProperty(description="The TreeCellRenderer that will be used to draw each cell.")
    public void setCellRenderer(TreeCellRenderer x) {
        super.setCellRenderer(x);
        this.updateFonts();
    }

    private void updateFonts() {
        if (this.renderer != null) {
            this.renderer.setDefFont(this.getFont());
            this.renderer.setBoldFont(this.getFont().deriveFont(1));
            this.renderer.setItalFont(this.getFont().deriveFont(2));
            this.renderer.setItalBoldFont(this.getFont().deriveFont(3));
        }
    }

    private void initTree() {
        this.getSelectionModel().setSelectionMode(2);
        this.renderer = new GraphicTreeRenderer();
        this.setCellRenderer(this.renderer);
        this.editor = new GraphicTreeCellEditor(this, this.renderer);
        this.setCellEditor(this.editor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                me.consume();
                GraphicTree.this.treeMouseClicked(me);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.ClickEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.ClickEvent(e);
                }
            }

            private void ClickEvent(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(x, y);
                if (path == null) {
                    return;
                }
                TreePath[] selectionPaths = tree.getSelectionPaths();
                boolean isSelected = false;
                if (selectionPaths != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (!selectionPath.equals(path)) continue;
                        isSelected = true;
                    }
                }
                if (!isSelected) {
                    tree.setSelectionPath(path);
                }
                e.consume();
            }
        });
        this.addTreeExpansionListener(this);
        this.addTreeSelectionListener(this);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new GraphicTreeTransferHandler(){

            @Override
            public void filesNodeDrop(GraphicTreeNode target, List fileList) {
                GraphicTree.this.nodeFilesDrop(target, fileList);
            }

            @Override
            public void nodesNodeDrop(GraphicTreeNode parent, GraphicTreeNode[] nodes) {
                GraphicTree.this.nodeNodesDrop(parent, nodes);
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeNode mtNode = (TreeNode)e.getPath().getLastPathComponent();
        if (mtNode instanceof GraphicTreeNode) {
            GraphicTreeNode node = (GraphicTreeNode)mtNode;
            this.nodeSelected(node);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreeNode mtNode;
        TreePath path = event.getPath();
        if (path != null && (mtNode = (TreeNode)path.getLastPathComponent()) instanceof GraphicTreeNode) {
            GraphicTreeNode node = (GraphicTreeNode)mtNode;
            this.nodeExpanded(node);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        GraphicTreeNode node;
        TreePath path = event.getPath();
        if (path != null && (node = (GraphicTreeNode)path.getLastPathComponent()) != null) {
            this.nodeCollapsed(node);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent arg0) {
        GraphicTreeNode node = (GraphicTreeNode)arg0.getTreePath().getLastPathComponent();
        System.out.println("The user has finished editing the node.");
        System.out.println("New value: " + node.getText());
    }

    @Override
    public void treeNodesInserted(TreeModelEvent arg0) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent arg0) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent arg0) {
    }

    public void addNode(GraphicTreeNode node) {
        this.addNode(node, this.getRoot());
    }

    public void addNode(GraphicTreeNode node, GraphicTreeNode parentNode) {
        this.addNode(node, parentNode, parentNode.getChildCount());
    }

    public void addNode(GraphicTreeNode node, GraphicTreeNode parentNode, int index) {
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, parentNode, index);
    }

    public void removeNode(GraphicTreeNode node) {
        if (node == this.getRoot()) {
            return;
        }
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
        this.notifyNodeChanged(node);
    }

    public void setSelectedNode(GraphicTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.getSelectionModel().setSelectionPath(path);
            this.scrollRowToVisible(this.getRowForPath(path));
        }
    }

    public void setNodeText(GraphicTreeNode node, String text) {
        node.setText(text);
        this.notifyNodeChanged(node);
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.collapseRow(row);
        }
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    private void expandNodePath(GraphicTreeNode node) {
        this.expandNode(node);
        for (int x = 0; x < node.getChildCount(); ++x) {
            this.expandNodePath((GraphicTreeNode)node.getChildAt(x));
        }
    }

    private void collapseNodePath(GraphicTreeNode node) {
        for (int x = 0; x < node.getChildCount(); ++x) {
            this.collapseNodePath((GraphicTreeNode)node.getChildAt(x));
        }
        this.collapseNode(node);
    }

    public void expandChildren(GraphicTreeNode node) {
        this.expandNode(node);
        for (int x = 0; x < node.getChildCount(); ++x) {
            this.expandNodePath((GraphicTreeNode)node.getChildAt(x));
        }
    }

    public void collapseChildren(GraphicTreeNode node) {
        for (int x = 0; x < node.getChildCount(); ++x) {
            TreeNode cNode = node.getChildAt(x);
            this.collapseNodePath((GraphicTreeNode)cNode);
        }
    }

    public void collapseNode(GraphicTreeNode node) {
        this.collapsePath(new TreePath(node.getPath()));
    }

    public void expandNode(GraphicTreeNode node) {
        this.expandPath(new TreePath(node.getPath()));
    }

    public void expandNodeParent(GraphicTreeNode node) {
        TreePath tmpPath;
        GraphicTreeNode parent = (GraphicTreeNode)node.getParent();
        if (parent != null && (tmpPath = new TreePath(parent.getPath())) != null) {
            this.expandPath(tmpPath);
        }
    }

    @Override
    public void startEditingAtPath(TreePath selectionpath) {
        GraphicTreeNode node = (GraphicTreeNode)this.getLastSelectedPathComponent();
        if (node != null && node.editable) {
            super.startEditingAtPath(selectionpath);
        }
    }

    public void editSelectedNodeName() {
        GraphicTreeNode node = (GraphicTreeNode)this.getLastSelectedPathComponent();
        if (node == null | !node.editable) {
            return;
        }
        if (this.getSelectionPath() != null) {
            this.startEditingAtPath(this.getSelectionPath());
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
    }

    private void treeMouseClicked(MouseEvent me) {
        TreeNode mtNode = (TreeNode)this.getLastSelectedPathComponent();
        if (mtNode instanceof GraphicTreeNode) {
            GraphicTreeNode node = (GraphicTreeNode)mtNode;
            if (me.getButton() == 1) {
                if (me.getClickCount() == 1) {
                    this.nodeLeftClicked(node, me.getX(), me.getY());
                    me.consume();
                } else if (me.getClickCount() == 2) {
                    this.nodeDoubleClicked(node);
                    me.consume();
                }
            } else if (me.getButton() == 3 && me.getClickCount() == 1) {
                this.nodeRightClicked(node, me.getX(), me.getY());
                me.consume();
            }
        }
    }

    public abstract void nodeCollapsed(GraphicTreeNode var1);

    public abstract void nodeExpanded(GraphicTreeNode var1);

    public abstract void nodeRightClicked(GraphicTreeNode var1, int var2, int var3);

    public abstract void nodeLeftClicked(GraphicTreeNode var1, int var2, int var3);

    public abstract void nodeDoubleClicked(GraphicTreeNode var1);

    public abstract void nodeSelected(GraphicTreeNode var1);

    public abstract void nodeChanged(GraphicTreeNode var1);

    public abstract void nodeFilesDrop(GraphicTreeNode var1, List var2);

    public abstract void nodeNodesDrop(GraphicTreeNode var1, GraphicTreeNode[] var2);

    public abstract void nodeRenamed(GraphicTreeNode var1);
}

