/*
 * Decompiled with CFR 0.152.
 */
package GenbankFileReader;

import Sequences.Coordinate;
import java.util.Comparator;

public class Locus
extends Coordinate {
    protected boolean antisense = false;
    public static final SortPosComp firstToLast = new SortPosComp();

    public Locus() {
    }

    public Locus(int startBP, int stopBP, boolean antisense) {
        this.start = startBP;
        this.stop = stopBP;
        this.antisense = antisense;
    }

    public Locus(int bpstart, int bpstop) {
        this.start = bpstart;
        this.stop = bpstop;
    }

    public Locus(int startBP, int stopBP, boolean antisense, int maxSeqLen) {
        this.start = startBP;
        this.stop = stopBP;
        if (this.start > maxSeqLen) {
            this.start = startBP - maxSeqLen;
        }
        if (this.stop > maxSeqLen) {
            this.stop = stopBP - maxSeqLen;
        }
        this.antisense = antisense;
    }

    public static int getAdjustedPosition(int bp, int seqLen) {
        return bp > seqLen ? bp - seqLen : bp;
    }

    public Locus(int bpstart, int bpstop, int maxSeqLen) {
        this.start = bpstart;
        this.stop = bpstop;
        if (this.start > maxSeqLen) {
            this.start = bpstart - maxSeqLen;
        }
        if (this.stop > maxSeqLen) {
            this.stop = bpstop - maxSeqLen;
        }
    }

    public Locus clone() {
        return new Locus(this.start, this.stop, this.antisense);
    }

    public void cloneFrom(Locus locus) {
        this.start = locus.start;
        this.stop = locus.stop;
        this.antisense = locus.antisense;
    }

    public String toString() {
        return super.toString() + ". start=" + this.start + ", stop=" + this.stop + ", antisense=" + this.antisense;
    }

    public String toGBString() {
        if (this.antisense) {
            return "complement(" + this.start + ".." + this.stop + ")";
        }
        return this.start + ".." + this.stop;
    }

    public boolean isValid() {
        return this.start > -1 && this.stop > -1;
    }

    public void invalidate() {
        this.start = -1;
        this.stop = -1;
    }

    public void rotateOrigin(int newOrigin, int seqLength) {
        Locus.rotateOrigin(this, newOrigin, seqLength);
    }

    public boolean spansOrigin() {
        return this.start > this.stop;
    }

    public int getLength(int seqLength) {
        return Locus.getLength(this.start, this.stop, seqLength);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public void set(int start, int stop) {
        this.start = start;
        this.stop = stop;
    }

    public void set(int start, int stop, boolean antisense) {
        this.start = start;
        this.stop = stop;
        this.antisense = antisense;
    }

    public void set(Locus locus) {
        this.start = locus.start;
        this.stop = locus.stop;
        this.antisense = locus.antisense;
    }

    public boolean isAntisense() {
        return this.antisense;
    }

    public void setAntisense(boolean Antisense) {
        this.antisense = Antisense;
    }

    public void antisense(int sequenceLength) {
        Locus.antisense(this, sequenceLength);
    }

    public boolean equals(Locus pos) {
        return this.start == pos.start && this.stop == pos.stop && this.antisense == pos.antisense;
    }

    public boolean intersects(Locus locus) {
        return this.intersects(locus.start, locus.stop);
    }

    public boolean intersects(int start, int stop) {
        if (start > stop && this.start > this.stop) {
            return true;
        }
        if (start > stop) {
            return this.start <= stop || this.stop >= start;
        }
        if (this.start > this.stop) {
            return start <= this.stop || stop >= this.start;
        }
        return this.start >= start && this.start <= stop || this.stop >= start && this.stop <= stop || this.start <= start && this.stop >= stop;
    }

    public boolean intersects(int start) {
        return this.start <= this.stop && start >= this.start && start <= this.stop || this.start > this.stop && (start >= this.start || start <= this.stop);
    }

    public static String getSequence(String sequence, Locus locus) {
        return Locus.getSequence(sequence, locus.start, locus.stop);
    }

    public static String getSequence(String sequence, int start, int stop) {
        if (start < 1 || stop > sequence.length() || stop < 1 || start > sequence.length()) {
            return null;
        }
        if (start <= stop) {
            return sequence.substring(start - 1, stop);
        }
        return sequence.substring(start - 1) + sequence.substring(0, stop);
    }

    public static void antisense(Locus locus, int sequenceLength) {
        int start;
        locus.antisense = !locus.antisense;
        int stop = sequenceLength - locus.start + 1;
        if (stop < 1) {
            stop = sequenceLength;
        }
        if ((start = sequenceLength - locus.stop + 1) < 1) {
            start = sequenceLength;
        }
        locus.start = start;
        locus.stop = stop;
    }

    public static int getLength(int start, int stop, int seqLength) {
        if (start < 1 || stop < 1 || start > seqLength || stop > seqLength) {
            return 0;
        }
        if (start <= stop) {
            return stop - start + 1;
        }
        if (start > seqLength || stop > seqLength || start < 1 || stop < 1) {
            return 0;
        }
        return seqLength - start + stop + 1;
    }

    public static void rotateOrigin(Locus locus, int newOrigin, int seqLength) {
        int lengthMoved = seqLength - newOrigin + 1;
        locus.start = locus.start < newOrigin ? locus.start + lengthMoved : locus.start - newOrigin + 1;
        int n = locus.stop = locus.stop < newOrigin ? locus.stop + lengthMoved : locus.stop - newOrigin + 1;
        if (locus.start > seqLength) {
            locus.start -= seqLength;
        }
        if (locus.stop > seqLength) {
            locus.stop -= seqLength;
        }
    }

    public static void adjustForSelection(Locus originalLocus, Locus selection) {
        boolean originalCrosses = originalLocus.start > originalLocus.stop;
        int adjustedSelStart = 1;
        int adjustedSelEnd = selection.stop - selection.start + 1;
        originalLocus.start = originalCrosses && originalLocus.start > selection.stop || originalLocus.start < selection.start ? adjustedSelStart : originalLocus.start - selection.start + 1;
        originalLocus.stop = originalCrosses && originalLocus.stop > selection.stop || originalLocus.stop > selection.stop ? adjustedSelEnd : (originalCrosses && originalLocus.start < selection.stop && originalLocus.stop < selection.start ? adjustedSelEnd : originalLocus.stop - selection.start + 1);
    }

    public static Locus adjustFromSelection(Locus originalLocus, Locus selection) {
        Locus newLocus = new Locus(originalLocus.start, originalLocus.stop, originalLocus.antisense);
        Locus.adjustForSelection(newLocus, selection);
        return newLocus;
    }

    public static void adjustForDeletion(Locus locus, int delStart, int delStop, int seqLen, boolean circular) {
        if (delStart > delStop) {
            Locus.adjustForDeletion(locus, delStart, seqLen, seqLen, circular);
            Locus.adjustForDeletion(locus, 1, delStop, seqLen, circular);
            return;
        }
        int delLen = delStop - delStart + 1;
        if (locus.start > locus.stop) {
            locus.stop += seqLen;
        }
        if (delStart >= locus.start && delStop < locus.stop) {
            locus.stop -= delLen;
        } else if (delStart <= locus.start) {
            if (delStop < locus.start) {
                locus.start -= delLen;
                locus.stop -= delLen;
            } else if (delStop >= locus.stop) {
                locus.invalidate();
            } else if (delStop < locus.stop) {
                locus.start = delStart;
                locus.stop -= delLen;
            }
        } else if (delStart <= locus.stop) {
            locus.stop = delStop >= locus.stop ? delStart - 1 : (locus.stop -= delLen);
        }
        if (locus.start > seqLen) {
            locus.start -= seqLen;
        }
        if (locus.stop > seqLen) {
            locus.stop -= seqLen;
        }
    }

    public static void adjustForInsertion(Locus locus, int insStart, int insLen) {
        if (locus.start > locus.stop) {
            if (locus.start >= insStart && locus.stop < insStart) {
                locus.start += insLen;
                locus.stop += insLen;
            } else if (locus.start < insStart) {
                locus.start += insLen;
                locus.stop = insStart - 1;
            } else if (locus.stop > insStart) {
                locus.stop += insLen;
            }
        } else if (locus.start >= insStart) {
            locus.start += insLen;
            locus.stop += insLen;
        } else if (locus.start < insStart && locus.stop > insStart) {
            locus.stop += insLen;
        }
    }

    public static class SortPosComp
    implements Comparator<Locus> {
        @Override
        public int compare(Locus p1, Locus p2) {
            int s2;
            int s1 = p1.antisense ? p1.stop : p1.start;
            int n = s2 = p2.antisense ? p2.stop : p2.start;
            if (s1 > s2) {
                return 1;
            }
            if (s2 > s1) {
                return -1;
            }
            return 0;
        }
    }
}

