/*
 * Decompiled with CFR 0.152.
 */
package GenbankFileReader;

import CloneManagerFileReader.CloneManagerReader;
import FileProgressListeners.FileLoadListener;
import GenbankFileReader.Annotation;
import GenbankFileReader.Header;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import SnapGeneFileReader.SnapGeneReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GenBankFile {
    private static final String GENBANK_GET_GB_URL1 = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=nuccore&id=";
    private static final String GENBANK_GET_GB_URL2 = "&rettype=gb&retmode=text";
    public static final String GB_NAME_FILTER = "\\w\\-'";
    public static final String GB_IS_HEADER = "(?i:^\\s*LOCUS\\s+(?<name>\\S+.*)\\s+\\b\\d+\\s*\\bbp\\s+(?<dataType>(ss-|ds-)?[RD]NA)\\s*(?<circular>linear|circular)?)(?<date>[^\\n]*)$";
    public static final String GB_GET_HEADER_BLOCK = "(?i:\\s*LOCUS\\s+(?<name>\\S+.*).*\\b\\d+\\s*\\bbp\\s+(?<dataType>(ss-|ds-)?[RD]NA)\\s*(?<circular>linear|circular)?)([^\\n]*)$(.*)(?i:(features|key)\\s+(location\\/qualifiers))\\s*$";
    public static final String GB_IS_FEATURE_ENTRY = "^\\s*(?<GBType>[\\w-]+)\\s+(?<antisense>(complement\\()?)(?<start>\\d+)\\.\\.(?<stop>\\d+)\\)?";
    public static final String GB_GET_LOCATION = "\\b(\\d+)\\.\\.(\\d+)\\b";
    public static final String GB_FEATURES_START = "(?i:(features|key)\\s+(location\\/qualifiers))\\s*\\n";
    public static final String GB_GET_SEQUENCE = "(?i)(?<=^ORIGIN)(?s)(?<sequence>(.*))(?=\\/\\/)";
    public static final String GB_GET_FEATURE_AND_QUALIFIERS = "^\\s*(?<GBType>[\\w-]+)\\s+((?<antisense>complement\\()?)(?<start>\\d+)\\.\\.(?<stop>\\d+)\\)?(?s)(?<qualifiers>.*?)(?=(^\\s*[\\w-]+\\s+(?i:(?:complement\\()?)\\d+\\.\\.\\d+\\)?|^ORIGIN$))";
    public static final String GB_GET_QUALIFIER = "^\\s*\\/(?<key>.+)=(?<value>(?:(?:[^\"]+?)$)|(?:(?:\"(?:[^\"]*?)\")))";
    public static final String GB_GET_FEATURE_BLOCK = "^(?i:(features|key))\\s+(?i:(location\\/qualifiers))$(([.\\n\\s\\S\\W\\w])*)^[\\s]*ORIGIN[\\s]*$";
    public static final String CSV_PARSE = "(\\,|\\n|^)(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|([^\"\\,\\n]*))";
    public static final String GB_REF_START = "\\s*(?i:reference)\\s+(?<refnum>\\d+)+\\s*\\(bases\\s+(?<refstart>\\d+)+\\s+to\\s+(?<refend>\\d+)\\)";
    public static final String PLOT_GET_ENZYME_MIX = "^COMMENT ENZMIX \\= \\[(?<mixname>.*)\\],\\[(?<mixseqs>.*)\\]$";
    public static final String PLOT_GET_ENZYME = "^\\s*COMMENT\\s+ENZYME\\s*=\\s*(?<rename>.*)$";
    public static final String PLOT_GET_ENZYME_FILTER = "^COMMENT RE_Filter\\:\\t(?<min>\\d+)\\t(?<max>\\d+)\\t(?<start>\\d+)\\t(?<stop>\\d+)$";
    public static final String PLOT_COMMENT = "^\\s*COMMENT Note\\: (?<note>.*)$";
    public static final String GET_UPPERCASE_BLOCKS = "([A-Z])+(?=[a-z])*";
    public static final String PLOT_GET_CODON_TABLE = "^\\s*COMMENT\\s+Project Codon Table\\s*=\\s*(?<orgname>.*)$";
    public static final String SNAPGENE_COLOR_NOTE = "(?i)\\/note\\s*=\\s*\"color:\\s* (?<hexcolor>#[0-9a-f]*)(\\s*;\\s*direction:\\s*(?<direction>(LEFT)||(RIGHT))){0,1}\\s*\"$";
    public static final String SNAPGENE_COLOR_NOTE2 = "(?i)(?:color:\\s*)(?<hexcolor>#[0-9a-f]*)(?:\\s*;\\s*direction:\\s*(?<direction>(?:LEFT)||(?:RIGHT))){0,1}\\s*";
    private static Pattern GBQualifier = Pattern.compile("^\\s*\\/(?<key>.+)=(?<value>(?:(?:[^\"]+?)$)|(?:(?:\"(?:[^\"]*?)\")))", 8);
    private static Pattern headerBlockPattern = Pattern.compile("(?i:\\s*LOCUS\\s+(?<name>\\S+.*).*\\b\\d+\\s*\\bbp\\s+(?<dataType>(ss-|ds-)?[RD]NA)\\s*(?<circular>linear|circular)?)([^\\n]*)$(.*)(?i:(features|key)\\s+(location\\/qualifiers))\\s*$", 42);
    private static Pattern SeqPattern = Pattern.compile("(?i)(?<=^ORIGIN)(?s)(?<sequence>(.*))(?=\\/\\/)", 40);
    private static Pattern FeaturesBlockPattern = Pattern.compile("^(?i:(features|key))\\s+(?i:(location\\/qualifiers))$(([.\\n\\s\\S\\W\\w])*)^[\\s]*ORIGIN[\\s]*$", 40);
    private static Pattern FeaturesPattern = Pattern.compile("^\\s*(?<GBType>[\\w-]+)\\s+((?<antisense>complement\\()?)(?<start>\\d+)\\.\\.(?<stop>\\d+)\\)?(?s)(?<qualifiers>.*?)(?=(^\\s*[\\w-]+\\s+(?i:(?:complement\\()?)\\d+\\.\\.\\d+\\)?|^ORIGIN$))", 40);
    private static Pattern NumberMatcher = Pattern.compile("(?<value>(?:\\-?)\\d+(?:[.]{0,1}\\d+)?)");
    private static Matcher featureMatcher;
    private static String error;
    private static boolean isLoaded;
    public static final int EOL_WINDOWS = 0;
    public static final int EOL_UNIX = 1;
    public static final int EOL_MAC = 2;
    private File file = null;
    public Header header = new Header();
    public ExtensibleArray<Annotation> features = new ExtensibleArray<Annotation>(Annotation.class);
    public String sequence = "";
    private String EOL = "\r\n";

    public void setEOL(int eol) {
        switch (eol) {
            case 0: {
                this.EOL = "\r\n";
                break;
            }
            case 1: {
                this.EOL = "\n";
                break;
            }
            case 2: {
                this.EOL = "\r";
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int FeatureCount() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    public boolean isCircular() {
        return this.header.circular;
    }

    public String getName() {
        return this.header.name;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getOrg() {
        return this.header.organism;
    }

    public String getAccession() {
        return this.header.accession;
    }

    public String getSource() {
        return this.header.source;
    }

    public boolean loaded() {
        return isLoaded;
    }

    public String getComments() {
        return this.header.notes != null ? this.header.notes.toString() : "";
    }

    public String getDataType() {
        return this.header.dataType;
    }

    public static String getErrorMessage() {
        return error;
    }

    public static GenBankFile getGenBankEntry(String genBankID) {
        return GenBankFile.getGenBankEntry(genBankID, false);
    }

    public static GenBankFile getGenBankEntry(String genBankID, boolean convertUracil) {
        String GBContents;
        URL url;
        try {
            url = new URL(GENBANK_GET_GB_URL1 + genBankID.trim() + GENBANK_GET_GB_URL2);
        }
        catch (MalformedURLException ex) {
            error = ex.getMessage();
            return null;
        }
        try {
            InputStream in = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            GBContents = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException ex) {
            error = ex.getMessage();
            return null;
        }
        return GenBankFile.loadString(GBContents, convertUracil, null);
    }

    public static GenBankFile loadGBFile(File file) {
        return GenBankFile.pLoadFile(file, null);
    }

    public static GenBankFile loadGBFile(File file, FileLoadListener listener) {
        return GenBankFile.pLoadFile(file, listener);
    }

    public static GenBankFile loadString(String fileContent) {
        return GenBankFile.loadString(fileContent, false, null);
    }

    public static GenBankFile loadString(String fileContent, FileLoadListener listener) {
        return GenBankFile.loadString(fileContent, false, listener);
    }

    private static String getExtension(File file) {
        return GenBankFile.getExtension(file.getName());
    }

    private static String getExtension(String filename) {
        int lestPer = filename.lastIndexOf(".");
        if (lestPer > -1) {
            return filename.substring(lestPer);
        }
        return "";
    }

    private static GenBankFile pLoadFile(File file, FileLoadListener listener) {
        String extention;
        switch (extention = GenBankFile.getExtension(file)) {
            case ".dna": {
                return SnapGeneReader.loadSnapGeneFile(file);
            }
            case ".cm5": {
                return CloneManagerReader.loadCM5File(file);
            }
        }
        return GenBankFile.pLoadGBFile(file, listener);
    }

    private static GenBankFile pLoadGBFile(File file, FileLoadListener listener) {
        String fileContent;
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0])));
        }
        catch (IOException ex) {
            error = ex instanceof NoSuchFileException ? "File could not be found." : ex.getLocalizedMessage();
            return null;
        }
        GenBankFile retFile = GenBankFile.loadString(fileContent, listener);
        retFile.file = file;
        return retFile;
    }

    private static void genFeature(Annotation feature, String QualBlock) {
        Matcher matcher2 = GBQualifier.matcher(QualBlock);
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        while (matcher2.find()) {
            Qualifier sQual = new Qualifier(matcher2.group("key"), matcher2.group("value"));
            qualifiers.add(sQual);
        }
        Qualifier[] outArray = new Qualifier[qualifiers.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = (Qualifier)qualifiers.get(x);
        }
        feature.qualifiers = outArray;
    }

    private static void processHeaderBlock(String headerBlock, GenBankFile outFile) {
        Matcher headerMatcher = Pattern.compile(PLOT_COMMENT, 8).matcher(headerBlock);
        while (headerMatcher.find()) {
            if (outFile.header.notes == null || outFile.header.notes.length() == 0) {
                outFile.header.notes = headerMatcher.group("note");
                continue;
            }
            outFile.header.notes = outFile.header.notes + "\n" + headerMatcher.group("note");
        }
        headerMatcher = Pattern.compile(PLOT_GET_ENZYME, 8).matcher(headerBlock);
        ArrayList<Qualifier> headerQualifiers = new ArrayList<Qualifier>();
        while (headerMatcher.find()) {
            headerQualifiers.add(new Qualifier("ENZYME", headerMatcher.group("rename")));
        }
        headerMatcher = Pattern.compile(PLOT_GET_ENZYME_MIX, 8).matcher(headerBlock);
        while (headerMatcher.find()) {
            headerQualifiers.add(new Qualifier("ENZMIX", headerMatcher.group("mixname")));
        }
        headerMatcher = Pattern.compile(PLOT_GET_ENZYME_FILTER, 8).matcher(headerBlock);
        while (headerMatcher.find()) {
            headerQualifiers.add(new Qualifier("RE_FILTER", headerMatcher.group("min") + "\t" + headerMatcher.group("max") + "\t" + headerMatcher.group("start") + "\t" + headerMatcher.group("stop")));
        }
        headerMatcher = Pattern.compile(PLOT_GET_CODON_TABLE, 8).matcher(headerBlock);
        if (headerMatcher.find()) {
            headerQualifiers.add(new Qualifier("Codon_Table", headerMatcher.group("orgname")));
        }
        Qualifier[] outArray = new Qualifier[headerQualifiers.size()];
        for (int x = 0; x < outArray.length; ++x) {
            outArray[x] = (Qualifier)headerQualifiers.get(x);
        }
        outFile.header.qualifiers = outArray;
    }

    private static int FilterStringToInt(String number, int defaultErrNum) {
        if (number == null || number.length() == 0) {
            return defaultErrNum;
        }
        Matcher numMatcher = NumberMatcher.matcher(number);
        if (numMatcher.find()) {
            return Integer.parseInt(numMatcher.group(1));
        }
        return defaultErrNum;
    }

    private static GenBankFile loadString(String fileContent, boolean convertUracil, FileLoadListener listener) {
        int headerEnd;
        int featuresStart;
        String[] lines;
        if (fileContent.contains("\r\n")) {
            lines = fileContent.split("\r\n");
        } else if (fileContent.contains("\n")) {
            lines = fileContent.split("\n");
        } else if (fileContent.contains("\r")) {
            lines = fileContent.split("\r");
        } else {
            return null;
        }
        GenBankFile outFile = new GenBankFile();
        if (!GenBankFile.parseHeader(lines[0], outFile)) {
            error = "Did not recognize file format.  Header not recognized";
            System.err.println(error);
            return null;
        }
        int seqStartLine = GenBankFile.parseSequence(lines, outFile);
        if (seqStartLine == -1) {
            error = "Sequence block could not be found";
            return null;
        }
        if (convertUracil) {
            switch (outFile.header.dataType.toUpperCase()) {
                case "RNA": 
                case "SS-RNA": 
                case "DS-RNA": {
                    outFile.sequence = outFile.sequence.replace("u", "t");
                    outFile.sequence = outFile.sequence.replace("U", "T");
                }
            }
        }
        if ((featuresStart = GenBankFile.getFeaturesStart(lines, seqStartLine - 1)) > -1) {
            headerEnd = featuresStart - 1;
            String featuresBlock = GenBankFile.getDataBlock(lines, featuresStart + 1, seqStartLine - 1);
            featureMatcher = FeaturesPattern.matcher(featuresBlock + "\nORIGIN");
            while (featureMatcher.find()) {
                int Start2 = GenBankFile.FilterStringToInt(featureMatcher.group("start"), 0);
                int Stop = GenBankFile.FilterStringToInt(featureMatcher.group("stop"), 0);
                Annotation feature = new Annotation(featureMatcher.group("GBType"), Start2, Stop, featureMatcher.group("antisense") != null);
                outFile.features.add(feature);
                GenBankFile.genFeature(feature, featureMatcher.group("qualifiers"));
            }
        } else {
            headerEnd = seqStartLine - 1;
        }
        GenBankFile.processHeaderBlock(GenBankFile.getDataBlock(lines, 1, headerEnd), outFile);
        return outFile;
    }

    private static int getFeaturesStart(String[] data, int startLine) {
        for (int x = startLine; x > -1; --x) {
            String line = data[x].trim().toLowerCase();
            if ((!line.startsWith("features") || !line.endsWith("location/qualifiers")) && !line.equals("features")) continue;
            return x;
        }
        return -1;
    }

    private static String getDataBlock(String[] data, int startLine, int stopLine) {
        StringBuilder outString = new StringBuilder();
        for (int x = startLine; x <= stopLine; ++x) {
            outString.append(data[x]).append("\n");
        }
        return outString.toString();
    }

    private static int parseSequence(String[] data, GenBankFile outFile) {
        int x;
        int blockEnd = -1;
        int blockStart = -1;
        for (x = data.length - 1; x > -1; --x) {
            if (!data[x].trim().equals("//")) continue;
            blockEnd = x;
            break;
        }
        if (blockEnd == -1) {
            return -1;
        }
        for (x = blockEnd - 1; x > -1; --x) {
            if (!data[x].trim().equals("ORIGIN")) continue;
            blockStart = x;
            break;
        }
        if (blockStart == -1) {
            return -1;
        }
        DNA sequence = new DNA(GenBankFile.getDataBlock(data, blockStart + 1, blockEnd - 1));
        outFile.sequence = sequence.getSequence();
        return blockStart;
    }

    private static boolean parseHeader(String gbHeader, GenBankFile outFile) {
        int aa;
        String p3;
        int rna;
        int circular;
        String header = (gbHeader = gbHeader.trim()).toLowerCase();
        int locus = header.lastIndexOf("locus");
        if (locus != 0) {
            return false;
        }
        int linear = header.lastIndexOf("linear");
        int topology = Math.max(linear, circular = header.lastIndexOf("circular"));
        if (topology < 0) {
            return false;
        }
        int startDate = header.indexOf(" ", topology);
        int dna = header.lastIndexOf("dna", topology);
        int type = Math.max(dna, rna = header.lastIndexOf("rna", topology));
        if (type > 3 && ((p3 = header.substring(type - 3, type)).equals("ds-") || p3.equals("ss-"))) {
            type -= 3;
        }
        if (type < 0) {
            return false;
        }
        int bp = header.lastIndexOf("bp", type);
        int bps = Math.max(bp, aa = header.lastIndexOf("aa", type));
        if (bps < 0) {
            return false;
        }
        boolean foundNum = false;
        int startLen = 0;
        int endLen = 0;
        for (int x = bps - 1; x > 0; --x) {
            char cChar = header.charAt(x);
            if (!foundNum && cChar >= '0' && cChar <= '9') {
                foundNum = true;
                endLen = x;
                continue;
            }
            if (!foundNum || cChar >= '0' && cChar <= '9' || cChar == ',') continue;
            startLen = x + 1;
            break;
        }
        if (startLen == 0 || endLen == 0) {
            return false;
        }
        outFile.header.name = gbHeader.substring(locus + 6, startLen).trim();
        outFile.header.dataType = gbHeader.substring(type, topology).trim();
        if (startDate > -1) {
            outFile.header.date = gbHeader.substring(startDate).trim();
            outFile.header.circular = topology == circular;
        } else {
            outFile.header.date = "";
            outFile.header.circular = topology == circular;
        }
        return true;
    }

    public static String formatGBTypeName(String gbType) {
        if (gbType == null || gbType.length() == 0) {
            return "misc_feature";
        }
        return (gbType = gbType.replaceAll("[^\\w\\-']", "")).length() == 0 ? "misc_feature" : gbType;
    }

    static {
        error = "";
        isLoaded = false;
    }
}

