/*
 * Decompiled with CFR 0.152.
 */
package FileWriters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.Scanner;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public abstract class AbstractSavingFile {
    File file = null;
    FileOutputStream fos = null;
    BufferedWriter writer;
    private Scanner scanner;
    String error;
    private JFileChooser openSaveDialog = null;
    private String extensionDescription = "Text files (*.txt)";
    private String extension = "txt";
    private String EOL = "\r\n";
    public static final int EOL_WINDOWS = 0;
    public static final int EOL_UNIX = 1;
    public static final int EOL_MAC = 2;

    public File getFile() {
        return this.file;
    }

    public boolean hasError() {
        return this.getError().length() > 0;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        if (this.error == null) {
            return "";
        }
        return this.error;
    }

    private boolean openToRead() {
        return this.file != null && this.scanner != null;
    }

    private boolean openToWrite() {
        return this.file != null && this.fos != null && this.writer != null;
    }

    public boolean isOpen() {
        return this.openToWrite() || this.openToRead();
    }

    public void close() {
        if (this.openToWrite()) {
            this.closeWriter();
        } else if (this.openToRead()) {
            this.closeReader();
        }
    }

    private void closeWriter() {
        this.file = null;
        this.fos = null;
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException ex) {
                this.error = ex.getLocalizedMessage();
            }
        }
        this.writer = null;
    }

    private void closeReader() {
        if (this.scanner != null) {
            this.scanner.close();
            this.scanner = null;
        }
    }

    public Scanner getFileReadScanner(File file) {
        if (!this.isValidReadableFile(file)) {
            return null;
        }
        try {
            this.scanner = new Scanner(file);
        }
        catch (FileNotFoundException ex) {
            this.error = ex.getLocalizedMessage();
            return null;
        }
        return this.scanner;
    }

    public void setExtension(String extention) {
        this.extension = extention;
        this.openSaveDialog = null;
    }

    public void setExtensionDescription(String desc) {
        this.extensionDescription = desc;
        this.openSaveDialog = null;
    }

    private static FileNameExtensionFilter GenerateFilter(String BaseText, String ... extensions) {
        String finalString = BaseText + " (*." + extensions[0];
        for (int x = 1; x < extensions.length; ++x) {
            finalString = finalString + ", *." + extensions[x];
        }
        finalString = finalString + ")";
        return new FileNameExtensionFilter(finalString, extensions);
    }

    private JFileChooser fileDialog() {
        if (this.openSaveDialog == null) {
            this.openSaveDialog = new JFileChooser();
            this.openSaveDialog.setFileView(new FileView(){

                @Override
                public Icon getIcon(File f) {
                    return FileSystemView.getFileSystemView().getSystemIcon(f);
                }
            });
            this.openSaveDialog.setFileFilter(AbstractSavingFile.GenerateFilter(this.extensionDescription, this.extension));
        }
        return this.openSaveDialog;
    }

    public boolean saveAs() {
        return this.saveAs(true);
    }

    public boolean saveAs(boolean promptOverwrite) {
        if (this.fileDialog().showSaveDialog(null) != 0) {
            return false;
        }
        File file = this.fileDialog().getSelectedFile();
        if (file == null) {
            return false;
        }
        String absolutePath = file.getAbsoluteFile().toString();
        if (!absolutePath.toLowerCase().endsWith(this.extension.toLowerCase()) && !this.extension.equals("*")) {
            absolutePath = absolutePath + "." + this.extension;
            file = new File(absolutePath);
        }
        if (file.exists() && promptOverwrite && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "File exists", 0, 0) == 1) {
            this.error = "File overwrite was canceled by user.";
            return false;
        }
        return this.saveFile(file, false);
    }

    public boolean saveFile(String file) {
        return this.saveFile(new File(file), false);
    }

    public boolean saveFile(String file, boolean promptOverwrite) {
        return this.saveFile(new File(file), promptOverwrite);
    }

    public boolean saveFile(File file) {
        return this.saveFile(file, false);
    }

    public boolean saveFile(File file, boolean promptOverwrite) {
        this.error = null;
        if (!this.isValidWritableFile(file)) {
            return false;
        }
        if (file.exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "File exists", 0, 0) == 1) {
            this.error = "File overwrite was canceled by user.";
            return false;
        }
        try {
            this.fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        this.file = file;
        this.writer = new BufferedWriter(new OutputStreamWriter(this.fos));
        this.closeWriter();
        return this.saveContents();
    }

    public boolean openFile() {
        if (this.fileDialog().showOpenDialog(null) != 0) {
            this.error = "Open aborted by user.";
            return false;
        }
        File file = this.fileDialog().getSelectedFile();
        return this.openFile(file);
    }

    public boolean openFile(String file) {
        return true;
    }

    public boolean openFile(File file) {
        if (!this.isValidReadableFile(file)) {
            return false;
        }
        return this.getFileContents(file);
    }

    public boolean isValidReadableFile(File file) {
        if (file == null) {
            this.error = "File path was not specified (set as null).";
            return false;
        }
        if (!file.exists()) {
            this.error = "Specified path does not exists.";
            return false;
        }
        if (!file.isFile()) {
            this.error = "Specified path exists but is not a file.";
            return false;
        }
        if (!file.canRead()) {
            this.error = "Specified file does not have read permissions.";
            return false;
        }
        return true;
    }

    public boolean isValidWritableFile(File file) {
        if (file == null) {
            this.error = "File path was not specified (set as null).";
            return false;
        }
        if (file.exists()) {
            if (!file.isFile()) {
                this.error = "Specified path exists and is not a file";
                return false;
            }
            if (file.isFile() && !file.canWrite()) {
                this.error = "Specified file exists and does not have write permissions";
                return false;
            }
        }
        return true;
    }

    public String getFileDataString(File file) {
        if (!this.isValidReadableFile(file)) {
            return null;
        }
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return null;
        }
    }

    public String[] getFileDataLines(File file) {
        String data = this.getFileDataString(file);
        if (data == null) {
            return null;
        }
        if (data.contains("\r\n")) {
            return data.split("\r\n");
        }
        if (data.contains("\n")) {
            return data.split("\n");
        }
        return data.split("\r");
    }

    public byte[] getFileDataBytes(File file) {
        if (!this.isValidReadableFile(file)) {
            return null;
        }
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return null;
        }
    }

    public abstract boolean getFileContents(File var1);

    public abstract boolean saveContents();

    public BufferedWriter getBufferedWritter() {
        return this.writer;
    }

    public void setEOL(int eol) {
        switch (eol) {
            case 0: {
                this.EOL = "\r\n";
                break;
            }
            case 1: {
                this.EOL = "\n";
                break;
            }
            case 2: {
                this.EOL = "\r";
            }
        }
    }

    public boolean writeLn() {
        this.error = null;
        if (this.file == null || this.fos == null) {
            return false;
        }
        try {
            this.writer.write(this.EOL);
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        return true;
    }

    public boolean writeLn(String text) {
        this.error = null;
        if (this.file == null || this.fos == null) {
            return false;
        }
        try {
            this.writer.write(text + this.EOL);
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        return true;
    }

    boolean write(String text) {
        this.error = null;
        if (this.file == null || this.fos == null) {
            return false;
        }
        try {
            this.writer.write(text);
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        return true;
    }
}

