/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class TextFileWriter {
    public static final int CRLF = 0;
    public static final int LF = 1;
    private String lineFeed = "\r\n";
    File file = null;
    FileOutputStream fos = null;
    BufferedWriter bw;
    String error;

    public static TextFileWriter openFilePath(String filename) {
        TextFileWriter writer = new TextFileWriter(filename);
        return writer.isOpen() ? writer : null;
    }

    public static TextFileWriter openFilePath(File file) {
        TextFileWriter writer = new TextFileWriter(file);
        return writer.isOpen() ? writer : null;
    }

    public File getFile() {
        return this.file;
    }

    public TextFileWriter() {
    }

    public TextFileWriter(File file) {
        this.openFile(file);
    }

    public TextFileWriter(String file) {
        this.openFile(file);
    }

    public boolean hasError() {
        return this.getError().length() > 0;
    }

    public String getError() {
        if (this.error == null) {
            return "";
        }
        return this.error;
    }

    public void setEOL(int style) {
        if (style == 0) {
            this.lineFeed = "\r\n";
        } else if (style == 1) {
            this.lineFeed = "\n";
        }
    }

    public boolean isOpen() {
        return this.file != null && this.fos != null && this.bw != null;
    }

    public void close() {
        this.file = null;
        this.fos = null;
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException ex) {
                this.error = ex.getLocalizedMessage();
            }
        }
        this.bw = null;
    }

    public boolean openFile(String file) {
        return this.openFile(new File(file), false);
    }

    public boolean openFile(String file, boolean promptOverwrite) {
        return this.openFile(new File(file), promptOverwrite);
    }

    public boolean openFile(File file) {
        return this.openFile(file, false);
    }

    public boolean openFile(File file, boolean promptOverwrite) {
        this.error = null;
        if (file.exists()) {
            if (!file.isFile()) {
                this.error = "Specified path exists and is not a file";
                return false;
            }
            if (file.isFile() && !file.canWrite()) {
                this.error = "Specified file exists and does not have write permissions";
                return false;
            }
            if (file.isFile() && file.canWrite() && promptOverwrite && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "File exists", 0, 0) == 1) {
                this.error = "File overwrite was canceled by user.";
                return false;
            }
        }
        try {
            this.fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        this.file = file;
        this.bw = new BufferedWriter(new OutputStreamWriter(this.fos));
        return true;
    }

    public boolean writeLine(String text) {
        return this.writedata(text, true);
    }

    public boolean write(String text) {
        return this.writedata(text, false);
    }

    private boolean writedata(String text, boolean insertEOL) {
        this.error = null;
        if (this.file == null || this.fos == null) {
            return false;
        }
        try {
            if (insertEOL) {
                this.bw.write(text + this.lineFeed);
            } else {
                this.bw.write(text);
            }
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        return true;
    }
}

