/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import FileReaders.ExternalLibrary;
import javax.swing.JOptionPane;

public abstract class ExternalHistoryLibrary
extends ExternalLibrary {
    String historyKey = "";

    @Override
    public void setHistoryKey(String key) {
        this.historyKey = (key = key.trim()) != null && key.length() > 0 ? key : "";
    }

    @Override
    public String getHistoryKey() {
        return this.historyKey;
    }

    public ExternalHistoryLibrary() {
    }

    public ExternalHistoryLibrary(String filepath) {
        super(filepath);
    }

    @Override
    public void open(String filePath) {
        super.open(filePath);
        if (this.isLoaded() || filePath == null || filePath.length() == 0 && this.haveHistoryKey()) {
            this.history.getUserPref().put(this.historyKey, this.getLoadedFilePath());
        }
    }

    @Override
    public boolean save(String filePath) {
        if (super.save(filePath) && this.haveHistoryKey()) {
            this.history.getUserPref().put(this.historyKey, this.getLoadedFilePath());
            return true;
        }
        return false;
    }

    private boolean haveHistoryKey() {
        return this.historyKey != null && this.historyKey.length() > 0;
    }

    public boolean verify() {
        if (ExternalHistoryLibrary.verifyExternalLibrary(this)) {
            if (this.haveHistoryKey()) {
                this.history.getUserPref().put(this.historyKey, this.getLoadedFilePath());
            }
            return true;
        }
        return false;
    }

    static boolean verifyExternalLibrary(ExternalLibrary lib) {
        if (!lib.isLoaded()) {
            return lib.saveAs();
        }
        if (!lib.isUpToDate()) {
            int reply = JOptionPane.showConfirmDialog(null, "The " + lib.getTitle() + " database has been externally modified since it was last loaded.\nReload it now?", "Update database?", 1, 3);
            switch (reply) {
                case 2: {
                    return false;
                }
                case 0: {
                    lib.update();
                    return true;
                }
            }
            return true;
        }
        return true;
    }
}

