/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.CellEditor;
import EditorTable.DataTable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public abstract class ComponentCellEditor
extends CellEditor {
    protected JComponent editor;
    private boolean apply = true;
    private boolean gainedFocus = false;
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    ComponentCellEditor.this.apply = false;
                    ComponentCellEditor.this.cancelEdit();
                    break;
                }
                case 9: 
                case 10: {
                    ComponentCellEditor.this.apply = true;
                    ComponentCellEditor.this.applyEdit();
                }
            }
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent arg0) {
            ComponentCellEditor.this.gainedFocus = true;
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (ComponentCellEditor.this.gainedFocus && ComponentCellEditor.this.apply) {
                ComponentCellEditor.this.applyEdit();
            } else {
                ComponentCellEditor.this.cancelEdit();
            }
        }
    };

    public ComponentCellEditor(JComponent editor) {
        this.editor = editor;
        if (editor != null) {
            editor.setBorder(new EmptyBorder(0, 0, 0, 0));
            editor.setVisible(false);
            this.init();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    @Override
    public boolean isVisible() {
        return this.editor.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.editor.setVisible(visible);
    }

    @Override
    public boolean beforeEdit() {
        this.editor.setBackground(this.table.backcolor);
        this.editor.setForeground(this.table.forecolor);
        this.editor.setFont(this.table.getFont());
        this.editor.addFocusListener(this.focusListener);
        this.editor.addKeyListener(this.keyListener);
        return true;
    }

    @Override
    public void startEdit(DataTable table, int colIndex, int rowIndex, int x, int y, int width, int height) {
        super.startEdit(table, colIndex, rowIndex, x, y, width, height);
        if (!this.beforeEdit()) {
            this.cancelEdit();
            return;
        }
        table.displayPanel.add(this.editor);
        table.activeEditor = this;
        this.editor.setBounds(x, y, width - 1, height - 1);
        this.editor.setVisible(true);
        this.editor.requestFocus();
    }

    public void closeEditor() {
        this.editor.removeFocusListener(this.focusListener);
        this.editor.removeKeyListener(this.keyListener);
        this.editor.setVisible(false);
        this.table.remove(this.editor);
        this.table.activeEditor = null;
    }

    @Override
    public void applyEdit() {
        this.table.getModel().setValue(this.colIndex, this.rowIndex, this.getEnteredValue());
        this.isEditing = false;
        this.table.reDraw(true);
        this.closeEditor();
        this.afterEdit();
    }

    @Override
    public void cancelEdit() {
        this.closeEditor();
        this.afterCancel();
    }
}

