/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.BinaryTree;
import EditorTable.CellEditor;
import EditorTable.CellRenderer;
import EditorTable.EditorWindow;

class Cell {
    boolean editable = EditorWindow.defaultCellEdit;
    CellEditor editor = null;
    CellRenderer renderer = null;
    Object value = null;
    BinaryTree<Object> properties = null;

    public Cell() {
        this.value = "";
    }

    public Cell(Object text) {
        this.value = text;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean hasProperty(String property) {
        return this.properties != null ? this.properties.contains(property) : false;
    }

    public Object getProperty(String property) {
        return this.properties != null ? this.properties.get(property) : null;
    }

    public Object getProperty(String property, Object defaultValue) {
        if (this.properties == null) {
            return defaultValue;
        }
        Object value = this.properties.get(property);
        return value != null ? value : defaultValue;
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new BinaryTree();
        }
        this.properties.put(property, value);
    }

    public void clearProperties() {
        this.properties.clear();
        this.properties = null;
    }

    public void removeProperty(String property) {
        if (this.properties == null) {
            this.properties = new BinaryTree();
        }
        this.properties.put(property, this.value);
    }
}

