/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNATools.MutationAnnotation;
import DNATools.PrimerPair;
import DNATools.TmCalculator;
import ProteinTools.CodonTable;
import Sequences.DNA;
import java.util.ArrayList;

public class OligoMutator {
    public static final int CODON_CLOSEST_SEQUENCE = 0;
    public static final int CODON_HIGHEST_FREQUENCY = 1;
    private int codonChoice = 0;
    CodonTable codonTable = new CodonTable();
    private String prefix = "";
    private int tmFwd = 0;
    private int tmRev = 0;
    private int minTm = 60;
    private int minLen = 20;
    private int overlapLen = 20;
    private String name = "";
    private String error = "";
    private final PrimerPair outPrimers = new PrimerPair();
    private final DNA sequence = new DNA();
    private final ArrayList<MutationAnnotation> mutations = new ArrayList();
    private String comment = "";
    private int calcType = 0;

    public void setCodonChoice(int choice) {
        if (choice >= 0 && choice <= 1) {
            this.codonChoice = choice;
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String Prefix) {
        this.prefix = Prefix;
    }

    public int get_TmFwd() {
        return this.tmFwd;
    }

    public int get_TmRev() {
        return this.tmRev;
    }

    public String getError() {
        return this.error;
    }

    public PrimerPair getPrimers() {
        return this.outPrimers;
    }

    public int getMinTm() {
        return this.minTm;
    }

    public void setMinTm(int MinTm) {
        this.minTm = MinTm;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public void setMinLen(int MinLen) {
        this.minLen = MinLen;
    }

    public int getOverlapLen() {
        return this.overlapLen;
    }

    public void setOverlapLen(int OverlapLen) {
        this.overlapLen = OverlapLen;
    }

    public String getSequence() {
        return this.sequence.getSequence();
    }

    public void setSequence(String Seq) {
        this.sequence.setSequence(Seq.toUpperCase());
    }

    public boolean isValid() {
        return this.name != null && this.name.length() != 0 && this.outPrimers.fwdPrimer.name != null && this.outPrimers.fwdPrimer.name.length() != 0 && this.outPrimers.revPrimer.name != null && this.outPrimers.revPrimer.name.length() != 0 && this.outPrimers.fwdPrimer.sequence != null && this.outPrimers.fwdPrimer.sequence.length() != 0 && this.outPrimers.revPrimer.sequence != null && this.outPrimers.revPrimer.sequence.length() != 0;
    }

    private static boolean addcDNAMutation(MutationAnnotation Mutation, OligoMutator dst) {
        if (Mutation.get_DNAStart() < 1 || Mutation.get_DNAStart() > dst.sequence.length()) {
            dst.error = "Invalid base specified";
            return false;
        }
        if (!dst.mutations.isEmpty()) {
            for (int x = 0; x < dst.mutations.size(); ++x) {
                if (dst.mutations.get(x).get_DNAStart() != Mutation.get_DNAStart()) continue;
                dst.error = "A mutation has already been made to this base position";
                return false;
            }
        }
        if (!dst.sequence.getSequence(Mutation.get_DNAStart(), Mutation.get_DNAStart() + Mutation.getOriginalResidue().length() - 1).equals(Mutation.getOriginalResidue())) {
            System.err.println("Mutation:    " + Mutation.getAnnotationDNA());
            System.err.println("Start:       " + Mutation.get_DNAStart());
            System.err.println("Length:      " + Mutation.getOriginalResidue().length());
            System.err.println("SelLen:      " + (Mutation.get_DNAStart() + Mutation.getOriginalResidue().length() - 1));
            System.err.println("Original:    " + dst.sequence.getSequence(Mutation.get_DNAStart(), Mutation.get_DNAStart() + Mutation.getOriginalResidue().length() - 1));
            dst.error = "Original base at position " + Mutation.get_DNAStart() + " (" + dst.sequence.getSequence(Mutation.get_DNAStart(), Mutation.get_DNAStart() + Mutation.getOriginalResidue().length() - 1) + ") was not the specified expected base " + Mutation.getOriginalResidue();
            return false;
        }
        dst.error = "";
        dst.mutations.add(Mutation);
        return true;
    }

    private static boolean addAAMutation(MutationAnnotation mutation, OligoMutator dst) {
        String curCodonAA;
        String codonSeq = dst.sequence.getSequence(mutation.get_DNAStart(), mutation.get_DNAStart() + 2);
        if (codonSeq == null) {
            return false;
        }
        switch (mutation.getOriginalResidue().length()) {
            case 1: {
                curCodonAA = dst.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e1_Letter_Code);
                break;
            }
            case 3: {
                curCodonAA = dst.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e3_Letter_Code);
                break;
            }
            default: {
                dst.error = "Invalid amino acid specified as the original residue(" + mutation.getOriginalResidue() + ")";
                return false;
            }
        }
        String cAAUC = curCodonAA.toUpperCase();
        boolean same1 = cAAUC.equals(mutation.getOriginalResidue().toUpperCase());
        if (!same1) {
            dst.error = "Found codon (" + codonSeq + ", " + curCodonAA + ") did not match the expected amino acid (" + mutation.getOriginalResidue() + ")";
            return false;
        }
        boolean same2 = cAAUC.equals(mutation.getNewResidue().toUpperCase());
        if (same2) {
            dst.error = "Target and mutated amino acids are the same)";
            return false;
        }
        boolean deletion = OligoMutator.isDeletion(mutation.getNewResidue());
        if (deletion) {
            int bpPos = mutation.get_DNAStart();
            OligoMutator.addDeletionRangeToDest(dst, bpPos, bpPos + 2);
        } else {
            String newCodon = dst.codonChoice == 0 ? dst.codonTable.getNearestCodon(mutation.getNewResidue(), codonSeq) : dst.codonTable.getHighestCodon(mutation.getNewResidue());
            int BpPos = mutation.get_DNAStart();
            for (int x = 0; x < 3; ++x) {
                String newBp;
                String oldBp = codonSeq.substring(x, x + 1);
                if (oldBp.equals(newBp = newCodon.substring(x, x + 1))) continue;
                String tmpDNAString = "c." + oldBp + String.valueOf(BpPos + x) + newBp;
                if (!OligoMutator.addcDNAMutation(new MutationAnnotation(tmpDNAString), dst)) {
                    return false;
                }
                dst.comment = dst.comment.length() > 0 ? dst.comment + "+" + tmpDNAString : tmpDNAString;
            }
            if (dst.comment.length() > 0) {
                dst.comment = dst.comment + " (" + codonSeq + ">" + newCodon + ")";
                String refName = mutation.sequenceName;
                if (refName != null && refName.length() > 0 && !refName.equalsIgnoreCase("reference")) {
                    dst.comment = dst.comment + " in " + refName;
                }
            }
        }
        return true;
    }

    private static boolean isDeletion(String newCodon) {
        return newCodon == null || newCodon.length() == 0 || newCodon.toUpperCase().equals("DEL");
    }

    public boolean addMutation(MutationAnnotation mutation) {
        if (!mutation.isValid()) {
            this.error = mutation.getError();
            return false;
        }
        switch (mutation.getAnnotationType()) {
            case 99: {
                System.out.println("mutation type unknown");
                return false;
            }
            case 1: {
                if (OligoMutator.addAAMutation(mutation, this)) break;
                return false;
            }
            case 0: {
                if (OligoMutator.addcDNAMutation(mutation, this)) break;
                return false;
            }
        }
        this.name = this.name.length() == 0 ? this.prefix + mutation.getAnnotation() : this.name + "_" + mutation.getAnnotation();
        return true;
    }

    public boolean deleteRegion(int bpStart, int bpStop) {
        return false;
    }

    public boolean addMutation(String mutation) {
        MutationAnnotation Results2 = new MutationAnnotation();
        String uMutation = mutation.toUpperCase();
        if (Results2.setMutation(uMutation)) {
            return this.addMutation(Results2);
        }
        this.error = Results2.getError();
        return false;
    }

    public boolean addMutation(int bpPos, String origBase, String newBase) {
        return this.addMutation(new MutationAnnotation(bpPos, origBase, newBase));
    }

    public boolean addDeletionRange(int bpDelPosStart, int bpDelPosStop) {
        return OligoMutator.addDeletionRangeToDest(this, bpDelPosStart, bpDelPosStop);
    }

    private static boolean addDeletionRangeToDest(OligoMutator dest, int bpDelPosStart, int bpDelPosStop) {
        if (bpDelPosStart <= bpDelPosStop && bpDelPosStop <= dest.sequence.length()) {
            for (int x = bpDelPosStart; x <= bpDelPosStop; ++x) {
                dest.addMutation(new MutationAnnotation(x, dest.sequence.getSequence(x, x), ""));
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.name = "";
        this.mutations.clear();
        this.error = "";
        this.outPrimers.fwdPrimer.sequence = "";
        this.outPrimers.revPrimer.sequence = "";
        this.outPrimers.setName("");
        this.comment = "";
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public int getCalcType() {
        return this.calcType;
    }

    public boolean generatePrimers() {
        return OligoMutator.generatePrimers(this, this.calcType);
    }

    public boolean generatePrimers(int calcType) {
        return OligoMutator.generatePrimers(this, calcType);
    }

    private static boolean generatePrimers(OligoMutator dst, int calcType) {
        int revStart;
        int fwdStop;
        if (dst.mutations.isEmpty()) {
            dst.error = "No Mutations Found.";
            return false;
        }
        DNA tmpDNA = new DNA();
        tmpDNA.setSequence(dst.sequence.getSequence().toLowerCase());
        int firstPos = dst.sequence.length() + 1;
        int lastPos = 0;
        for (int x = 0; x < dst.mutations.size(); ++x) {
            int cBase = dst.mutations.get(x).get_DNAStart();
            if (cBase < firstPos) {
                firstPos = cBase;
            }
            if (cBase > lastPos) {
                lastPos = cBase;
            }
            tmpDNA.replace(cBase, cBase, dst.mutations.get(x).getNewResidue().toUpperCase());
        }
        int fwdStart = lastPos + 1;
        int revStop = firstPos - 1;
        boolean lenOK = false;
        for (fwdStop = fwdStart + (dst.minLen - 1); fwdStop < dst.sequence.length(); ++fwdStop) {
            int fwdTm = TmCalculator.getTm(dst.sequence.getSequence(fwdStart, fwdStop), calcType);
            if (fwdTm < dst.minTm) continue;
            dst.tmFwd = fwdTm;
            lenOK = true;
            break;
        }
        if (!lenOK) {
            dst.error = "Fwd Primer could not be extended to meet minimum Tm.";
            return false;
        }
        lenOK = false;
        for (revStart = revStop - dst.minLen + 1; revStart > 0; --revStart) {
            int revTm = TmCalculator.getTm(dst.sequence.getSequence(revStart, revStop), calcType);
            if (revTm < dst.minTm) continue;
            dst.tmRev = revTm;
            lenOK = true;
            break;
        }
        if (!lenOK) {
            dst.error = "Rev Primer could not be extended to meet minimum Tm.";
            return false;
        }
        int fwdLen = fwdStop - fwdStart + 1;
        int revLen = revStop - revStart + 1;
        int ol1 = dst.overlapLen + 1;
        while (revStop - fwdStart < ol1) {
            if (revLen <= fwdLen) {
                ++revStop;
                ++revLen;
                continue;
            }
            --fwdStart;
            ++fwdLen;
        }
        dst.outPrimers.fwdPrimer.sequence = tmpDNA.getSequence(fwdStart, fwdStop);
        dst.outPrimers.setName(dst.name);
        dst.outPrimers.revPrimer.sequence = tmpDNA.getSequence(revStart, revStop, true);
        dst.outPrimers.setPBS(dst.tmFwd, dst.tmRev);
        dst.outPrimers.comment = dst.comment.length() == 0 ? "Designed for " + TmCalculator.getTmTypeName(calcType) : dst.comment + ".  Designed for " + TmCalculator.getTmTypeName(calcType);
        dst.outPrimers.fwdPrimer.comment = dst.outPrimers.comment;
        dst.outPrimers.revPrimer.comment = dst.outPrimers.comment;
        return true;
    }

    private static String getSequence(String SrcString, int Start2, int Stop) {
        if (Start2 < 1 || Stop > SrcString.length() || Stop < 1 || Start2 > SrcString.length()) {
            return null;
        }
        if (Start2 <= Stop) {
            return SrcString.substring(Start2 - 1, Stop);
        }
        return SrcString.substring(Start2 - 1) + SrcString.substring(0, Stop);
    }
}

