/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNATools.Primer;
import DNATools.PrimerPair;
import DNATools.TmCalculator;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import java.util.Comparator;

class GibsonPrimerMaker {
    public static final int MIN_PBS_LEN = 19;
    public static final int MIN_HA_LEN = 20;
    public static final int MAX_PBS_GC = 55;
    public static final int MIN_PBS_TM = 55;
    protected static int min_PBS_Len = 19;
    protected static int min_HA_Len = 20;
    protected static int max_PBS_GC = 55;
    protected static int min_PBS_tm = 55;
    protected static int tm_Calc_Type = 3;
    public static final int TM_CALC_TYPE = 3;

    GibsonPrimerMaker() {
    }

    public static int getMin_PBS_Len() {
        return min_PBS_Len;
    }

    public static void setMin_PBS_Len(int len) {
        if (len > 14) {
            min_PBS_Len = len;
        }
    }

    public static int getMin_HA_Len() {
        return min_HA_Len;
    }

    public static void setMin_HA_Len(int len) {
        if (len > 14) {
            min_HA_Len = len;
        }
    }

    public static int getMax_PBS_GC() {
        return max_PBS_GC;
    }

    public static void setMax_PBS_GC(int gc) {
        max_PBS_GC = gc;
    }

    public static int getMin_PBS_tm() {
        return min_PBS_tm;
    }

    public static void setMin_PBS_tm(int tm) {
        if (tm > 45) {
            min_PBS_tm = tm;
        }
    }

    public static int getTm_Calc_Type() {
        return tm_Calc_Type;
    }

    public static void setTm_Calc_Type(int calc_Type) {
        switch (calc_Type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                tm_Calc_Type = calc_Type;
            }
        }
    }

    public static Primer[] makePrimers(String vector, String ... inserts) {
        String[] insertStrings = new String[inserts.length];
        for (int x = 0; x < inserts.length; ++x) {
            insertStrings[x] = DNA.filterSequence(inserts[x]);
        }
        return GibsonPrimerMaker.pMakePrimers(DNA.filterSequence(vector), true, insertStrings);
    }

    public static Primer[] makePrimers(String vector, boolean makeVectorPrimers, String ... inserts) {
        String[] insertStrings = new String[inserts.length];
        for (int x = 0; x < inserts.length; ++x) {
            insertStrings[x] = DNA.filterSequence(inserts[x]);
        }
        return GibsonPrimerMaker.pMakePrimers(DNA.filterSequence(vector), makeVectorPrimers, insertStrings);
    }

    public static Primer[] makePrimers(DNA vector, DNA ... inserts) {
        ExtensibleArray<String> insertStrings = new ExtensibleArray<String>(String.class);
        if (vector == null || vector.length() == 0 || inserts == null || inserts.length == 0) {
            return null;
        }
        for (DNA insert : inserts) {
            if (insert.getSequence().length() < 20) continue;
            insertStrings.add(insert.getSequence());
        }
        return GibsonPrimerMaker.pMakePrimers(vector.getSequence(), true, insertStrings.toArray());
    }

    public static Primer[] makePrimers(DNA vector, boolean makeVectorPrimers, DNA ... inserts) {
        ExtensibleArray<String> insertStrings = new ExtensibleArray<String>(String.class);
        if (vector == null || vector.length() == 0 || inserts == null || inserts.length == 0) {
            return null;
        }
        for (DNA insert : inserts) {
            if (insert.getSequence().length() < 20) continue;
            insertStrings.add(insert.getSequence());
        }
        return GibsonPrimerMaker.pMakePrimers(vector.getSequence(), true, insertStrings.toArray());
    }

    private static Primer[] pMakePrimers(String vector, boolean makeVectorPrimers, String ... inserts) {
        ExtensibleArray<Primer> pairs = new ExtensibleArray<Primer>(Primer.class);
        PrimerPair pair = makeVectorPrimers ? GibsonPrimerMaker.makePrimersPair(vector, inserts[0]) : GibsonPrimerMaker.makePrimersPair(vector, inserts[0], false, true);
        if (pair == null) {
            return null;
        }
        pair.fwdPrimer.name = "insert_1_F";
        pair.revPrimer.name = "Vector_R";
        pairs.add(pair.fwdPrimer);
        if (makeVectorPrimers) {
            pairs.add(pair.revPrimer);
        }
        for (int x = 0; x < inserts.length - 1; ++x) {
            pair = GibsonPrimerMaker.makePrimersPair(inserts[x], inserts[x + 1]);
            pair.fwdPrimer.name = "insert_" + (x + 2) + "_F";
            pair.revPrimer.name = "insert_" + (x + 1) + "_R";
            pairs.add(pair.fwdPrimer);
            pairs.add(pair.revPrimer);
        }
        pair = makeVectorPrimers ? GibsonPrimerMaker.makePrimersPair(inserts[inserts.length - 1], vector) : GibsonPrimerMaker.makePrimersPair(inserts[inserts.length - 1], vector, true, false);
        pair.fwdPrimer.name = "Vector_F";
        pair.revPrimer.name = "insert_" + inserts.length + "_R";
        if (makeVectorPrimers) {
            pairs.add(pair.fwdPrimer);
        }
        pairs.add(pair.revPrimer);
        pairs.sort(new Comparator<Primer>(){

            @Override
            public int compare(Primer o1, Primer o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return pairs.toArray();
    }

    private static PrimerPair makePrimersPair(String seq1, String seq2) {
        return GibsonPrimerMaker.makePrimersPair(seq1, seq2, true, true);
    }

    private static PrimerPair makePrimersPair(String seq1, String seq2, boolean revOverHang, boolean fwdOverHang) {
        int revStart;
        int fwdStop;
        PrimerPair outPrimers = new PrimerPair();
        DNA tmpDNA = new DNA();
        String mergedSeq = seq1.toLowerCase() + seq2.toLowerCase();
        tmpDNA.setSequence(mergedSeq);
        int fwdStart = seq1.length() + 1;
        int revStop = seq1.length();
        boolean lenOK = false;
        for (fwdStop = fwdStart + (min_PBS_Len - 1); fwdStop < tmpDNA.length(); ++fwdStop) {
            int fwdTm = TmCalculator.getTm(tmpDNA.getSequence(fwdStart, fwdStop), tm_Calc_Type);
            if (fwdTm < min_PBS_tm) continue;
            outPrimers.fwdPrimer.tmPBS = fwdTm;
            lenOK = true;
            break;
        }
        if (!lenOK) {
            outPrimers.fwdPrimer.comment = "Fwd Primer could not be extended to meet minimum Tm.";
            return outPrimers;
        }
        lenOK = false;
        for (revStart = revStop - min_PBS_Len + 1; revStart > 0; --revStart) {
            int revTm = TmCalculator.getTm(tmpDNA.getSequence(revStart, revStop), tm_Calc_Type);
            if (revTm < min_PBS_tm) continue;
            outPrimers.revPrimer.tmPBS = revTm;
            lenOK = true;
            break;
        }
        if (!lenOK) {
            outPrimers.revPrimer.comment = "Fwd Primer could not be extended to meet minimum Tm.";
            return outPrimers;
        }
        if (revOverHang && fwdOverHang) {
            int fwdLen = fwdStop - fwdStart + 1;
            int revLen = revStop - revStart + 1;
            int ol1 = min_HA_Len;
            while (revStop - fwdStart < ol1) {
                if (revLen <= fwdLen) {
                    ++revStop;
                    ++revLen;
                    continue;
                }
                --fwdStart;
                ++fwdLen;
            }
        } else if (revOverHang) {
            revStop += min_HA_Len;
        } else if (fwdOverHang) {
            fwdStart -= min_HA_Len;
        }
        tmpDNA.toUppercase(fwdStart, revStop);
        outPrimers.fwdPrimer.sequence = tmpDNA.getSequence(fwdStart, fwdStop);
        outPrimers.revPrimer.sequence = tmpDNA.getSequence(revStart, revStop, true);
        outPrimers.comment = outPrimers.comment.length() == 0 ? ".  Tm calculated for " + TmCalculator.getTmTypeName(tm_Calc_Type) : outPrimers.comment + ".  Tm calculated for " + TmCalculator.getTmTypeName(tm_Calc_Type);
        outPrimers.fwdPrimer.comment = outPrimers.comment;
        outPrimers.revPrimer.comment = outPrimers.comment;
        return outPrimers;
    }
}

