/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import AbstractClasses.AbstractGappedFinder;
import GenbankFileReader.Locus;
import Sequences.DNA;

public class DNAGappedFinder
extends AbstractGappedFinder {
    String aSequence = null;

    public DNAGappedFinder() {
    }

    public DNAGappedFinder(String sequence) {
        this(sequence, false);
    }

    public DNAGappedFinder(String sequence, boolean circular) {
        this(sequence, circular, false);
    }

    public DNAGappedFinder(String sequence, boolean circular, boolean caseSensitive) {
        super(sequence, circular, caseSensitive);
    }

    @Override
    public boolean find(String qry, boolean searchSense, boolean searchAntisense) {
        Locus[] senseResults;
        this.matches.clear();
        if (!searchSense && !searchAntisense) {
            return false;
        }
        if (searchSense && (senseResults = this.findOnStrand(this.sequence, qry)) != null) {
            this.matches.add((T[])senseResults);
        }
        if (searchAntisense) {
            Locus[] aSenseResults;
            if (this.aSequence == null) {
                this.aSequence = DNA.getAntisense(this.sequence);
            }
            if ((aSenseResults = this.findOnStrand(this.aSequence, qry)) != null) {
                for (Locus locus : aSenseResults) {
                    locus.antisense(this.searchLimit);
                }
                this.matches.add((T[])aSenseResults);
            }
        }
        return !this.matches.isEmpty();
    }

    @Override
    public String stringToDegenerate(String qry) {
        return DNA.DNAtoRegex(qry);
    }
}

